package com.mushiny.wms.application.web;

import com.mushiny.wms.application.service.tripService;
import com.mushiny.wms.common.utils.JSONUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;


@RestController
@RequestMapping("/change")
public class tripController {
    private final tripService tripservice;
    @Autowired
    public tripController(tripService tripservice){
        this.tripservice=tripservice;
    }

    @GetMapping(value = "/agv", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<String> change(Integer podIndex){
        return ResponseEntity.ok(tripservice.changeAgv(podIndex));
    }
    @GetMapping(value ="/task",produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<String> changeTask(String driveId){
        return ResponseEntity.ok(tripservice.deleteTrip(driveId));
    }
    @GetMapping(value = "haha",produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<String> wex(){
        HashMap h=new HashMap();
        h.put("code","0");
        h.put("msg","回传成功");
        return ResponseEntity.ok(JSONUtil.mapToJSon(h));
    }
}
