package com.mushiny.wms.application.service.impl;

import com.mushiny.wms.application.domain.Pod;
import com.mushiny.wms.application.domain.Trip;
import com.mushiny.wms.application.repository.PodRepository;
import com.mushiny.wms.application.repository.TripRepository;
import com.mushiny.wms.application.service.tripService;
import com.mushiny.wms.common.utils.JSONUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;


@Service
@Transactional
public class tripServiceImpl implements tripService {
    @Autowired
    private TripRepository tripRepository;
    @Autowired
    private PodRepository podRepository;

    @Override
    public String changeAgv(Integer podIndex)  {
        HashMap h=new HashMap();

        Pod pod=podRepository.getByPodIndex2(podIndex);
        if (pod!=null){
            Trip trip= tripRepository.getByPodIndex(pod.getId());
            if(trip!=null){
                trip.setTripState("New");
                trip.setDriveId(null);
                h.put("code","0");
                h.put("msg","换车成功");
                return JSONUtil.mapToJSon(h);
            }else {
                h.put("code","1");
                h.put("msg","没有该货架任务");
                return JSONUtil.mapToJSon(h);
            }
        }else {
            h.put("code","2");
            h.put("msg","没有该货架");
            return JSONUtil.mapToJSon(h);
        }


    }

    @Override
    public String deleteTrip(String driveId) {
        HashMap t=new HashMap();
        Trip trip=tripRepository.getByDriveId(driveId);
        if (trip!=null){
            trip.setTripState("Finish");
            t.put("code","0");
            t.put("msg","任务删除成功");
            return JSONUtil.mapToJSon(t);
        }else{
            t.put("code","1");
            t.put("msg","该小车没有正在执行的任务");
            return  JSONUtil.mapToJSon(t);
        }
    }
}
