package com.mushiny.wms.rfid;

import com.mushiny.wms.application.domain.OutboundInstruct;
import com.mushiny.wms.application.domain.Trip;
import com.mushiny.wms.application.repository.OutboundInstructRepository;
import com.mushiny.wms.application.repository.TripRepository;
import com.mushiny.wms.common.utils.JSONUtil;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

/**
 * 电梯配置
 */
@RestController
@RequestMapping("/mq")
public class MqTestController {
    @Autowired
    private RabbitTemplate template;
    @Autowired
    private TripRepository tripRepository;
    @Autowired
    private OutboundInstructRepository outboundInstructRepository;
    @Autowired
    private RFIDWebApi rfidWebApi;

    @PostMapping(value = "/sendMessage")
    public String sendMessage(){
        Map data = new HashMap();
        /*String podId = (String) data.get(RFIDConstants.POD_INDEX);
        String addrCode = (String) data.get(RFIDConstants.TARGET_ADDRESS);
        String type = (String) data.get(RFIDConstants.TRIP_TYPE);
        String status = (String) data.get(RFIDConstants.INSTRUCT_STATUS);*/
        data.put(RFIDConstants.POD_INDEX,"731");
        data.put(RFIDConstants.TRIP_ID,"002a8331-5ece-43d8-9c06-508ef778f353");
        data.put(RFIDConstants.TARGET_ADDRESS,"21");
        data.put(RFIDConstants.TRIP_TYPE,RFIDConstants.TRIP_TYPE);
        data.put(RFIDConstants.INSTRUCT_STATUS, RFIDConstants.STOCKOUT);


        String tripId = (String) data.get(RFIDConstants.TRIP_ID);
        Trip trip = this.tripRepository.getTripByID(tripId);
        String instruct = trip.getInstruct();
        OutboundInstruct oi = outboundInstructRepository.getInstruByInstructId(instruct);
        //String res = rfidWebApi.podOutReq("731", JSONUtil.toJSon(oi),"21");
        //System.out.println(res);
        return "";
    }

    @PostMapping(value = "/sendMessage2")
    public String sendMessage2(){
        Map data = new HashMap();
        /*String podId = (String) data.get(RFIDConstants.POD_INDEX);
        String addrCode = (String) data.get(RFIDConstants.TARGET_ADDRESS);
        String type = (String) data.get(RFIDConstants.TRIP_TYPE);
        String status = (String) data.get(RFIDConstants.INSTRUCT_STATUS);*/
        data.put(RFIDConstants.POD_INDEX,"731");
        data.put(RFIDConstants.TRIP_ID,"002a8331-5ece-43d8-9c06-508ef778f353");
        data.put(RFIDConstants.TARGET_ADDRESS,"21");
        data.put(RFIDConstants.TRIP_TYPE,RFIDConstants.TRIP_TYPE);
        data.put(RFIDConstants.INSTRUCT_STATUS, RFIDConstants.STOCKOUT);


        String res = rfidWebApi.podInConfirm("731", "21",RFIDConstants.ANNTOMVIN);
        System.out.println(res);
        return res;
    }


    //测试代码
    @PostMapping(value = "/testPodInConfirm", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<Object> testPodInConfirm(@RequestBody String instruct) {

        return  ResponseEntity.ok(instruct);
    }

    @PostMapping(value = "/testPodOutReq", produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<Object> testPodOutReq(@RequestBody String instruct) {

        return  ResponseEntity.ok(instruct);
    }

}
