package com.mushiny.wms.slam;

import com.mushiny.wms.application.service.OutboundTripService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * 出库的定时任务
 */
@Component
public class SlamEmptyPodInTripTimer {
    private static final Logger LOG = LoggerFactory.getLogger(SlamEmptyPodInTripTimer.class);
    private final SlamTripService slamTripService;
    @Autowired
    public SlamEmptyPodInTripTimer(SlamTripService slamTripService) {
        this.slamTripService = slamTripService;
    }
    @Scheduled(fixedDelay=30000,initialDelay = 10000)
   // @Async
    public void build() {
        try {
            if(LOG.isDebugEnabled())
            {
                LOG.debug("开始运行SLAM空货架入库线程!");
            }
            this.slamTripService.buildSlamEmptyPodInTrip();
            if(LOG.isDebugEnabled())
            {
                LOG.debug("运行SLAM空货架入库线程结束!");
            }
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }

    }
}
