/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.slam;

import com.mushiny.wms.application.business.common.RfidBusiness;
import com.mushiny.wms.application.config.RestTempConfig;
import com.mushiny.wms.application.domain.MapNode;
import com.mushiny.wms.application.domain.MdStationnodeposition;
import com.mushiny.wms.application.domain.MushinyMessage;
import com.mushiny.wms.application.domain.OutboundInstruct;
import com.mushiny.wms.application.domain.Pod;
import com.mushiny.wms.application.domain.Section;
import com.mushiny.wms.application.domain.Stationnode;
import com.mushiny.wms.application.domain.Trip;
import com.mushiny.wms.application.domain.WmsSlamCar;
import com.mushiny.wms.application.domain.WmsSlamTrip;
import com.mushiny.wms.application.domain.enums.InstructStatus;
import com.mushiny.wms.application.domain.enums.TripState;
import com.mushiny.wms.application.domain.enums.TripType;
import com.mushiny.wms.application.rabbitMq.RabbitMessageSender;
import com.mushiny.wms.application.repository.MapNodeRepository;
import com.mushiny.wms.application.repository.MapRepository;
import com.mushiny.wms.application.repository.MdStationnodepositionRepository;
import com.mushiny.wms.application.repository.OutboundInstructRepository;
import com.mushiny.wms.application.repository.PodRepository;
import com.mushiny.wms.application.repository.SectionRepository;
import com.mushiny.wms.application.repository.TripRepository;
import com.mushiny.wms.application.repository.WmsSlamCarRepository;
import com.mushiny.wms.application.repository.WmsSlamTripRepository;
import com.mushiny.wms.common.utils.DateTimeUtil;
import com.mushiny.wms.common.utils.EntityManagerUtil;
import com.mushiny.wms.common.utils.JSONUtil;
import com.mushiny.wms.slam.CommonUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
@Transactional
public class SlamTripService {
    private static final Integer CODE_OK = 0;
    private String token;
    private final MapRepository mapRepository;
    private final WmsSlamTripRepository wmsSlamTripRepository;
    private final OutboundInstructRepository outboundInstructRepository;
    public static final Logger logger = LoggerFactory.getLogger(SlamTripService.class);
    @Value(value="${mushiny.midea.slam.url}")
    private String mideaUrl;
    @Value(value="${mushiny.midea.slam.url_select}")
    private String mideaUrl_select;
    @Value(value="${mushiny.midea.slam.appSecret}")
    private String appSecret;
    @Value(value="${mushiny.midea.slam.mes.callBack}")
    private String mesCallBackUrl;
    private final RestTemplateBuilder builder;
    private final EntityManagerUtil entityManagerUtil;
    private final RfidBusiness rfidBusiness;
    private final PodRepository podRepository;
    private final RabbitMessageSender sender;
    private final SectionRepository sectionRepository;
    private final TripRepository tripRepository;
    private final RestTempConfig restTempConfig;
    private final MapNodeRepository mapNodeRepository;
    private final MdStationnodepositionRepository mdStationnodepositionRepository;
    public final WmsSlamCarRepository wmsSlamCarRepository;
    public static final String SQL_FINDADDRCODEBYENDTAG = "SELECT WD_NODE.* FROM WD_NODE,WMS_SLAM_NODE WHERE WMS_SLAM_NODE.NODEID=WD_NODE.ID AND WMS_SLAM_NODE.SLAM_NODE=:endTag";
    public static final String SQL = "SELECT SLAM_NODE FROM WMS_SLAM_NODE WHERE SLAM_NODENAME=:tagName";
    public static final String SQL_SLAM_POD_IN = "SELECT WMS_SLAM_NODE.NODEID,WMS_SLAM_NODE.SLAM_NODE FROM MD_STATIONNODEPOSITION, MD_STATIONNODE ,WD_NODE,WMS_SLAM_NODE\nWHERE MD_STATIONNODE.ID=MD_STATIONNODEPOSITION.STATIONNODE_ID AND MD_STATIONNODE.TYPE=6 AND WMS_SLAM_NODE.NODEID=MD_STATIONNODEPOSITION.NODE_ID\nAND WD_NODE.ID=MD_STATIONNODEPOSITION.NODE_ID AND WD_NODE.ADDRESSCODEID \nNOT IN(SELECT PLACEMARK FROM MD_POD WHERE MD_POD.SECTION_ID='ec229eb7-7e2b-43a8-b1c7-91bd807e91cf')";
    public static final String CARBACK = "CARBACK";
    public static final String LMGETMATERIAL = "LMGETMATERIAL";
    public static final String SECTIONID = "ec229eb7-7e2b-43a8-b1c7-91bd807e91cf";
    public static final String MAPID = "8a55cdc8-dd5c-4a07-87e7-3979511949de";
    private static final String sql2 = "SELECT * FROM WMS_SLAM_NODE WHERE NODEID=:nodeId";
    private static final String sql3 = "SELECT SLAM_NODE FROM WMS_SLAM_NODE WHERE SLAM_NODENAME=:workcenterCode";

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    @Autowired
    public SlamTripService(MapRepository mapRepository, WmsSlamTripRepository wmsSlamTripRepository, OutboundInstructRepository outboundInstructRepository, RestTemplateBuilder builder, EntityManagerUtil entityManagerUtil, RfidBusiness rfidBusiness, PodRepository podRepository, RabbitMessageSender sender, SectionRepository sectionRepository, TripRepository tripRepository, RestTempConfig restTempConfig, MapNodeRepository mapNodeRepository, MdStationnodepositionRepository mdStationnodepositionRepository, WmsSlamCarRepository wmsSlamCarRepository) {
        this.mapRepository = mapRepository;
        this.wmsSlamTripRepository = wmsSlamTripRepository;
        this.outboundInstructRepository = outboundInstructRepository;
        this.builder = builder;
        this.entityManagerUtil = entityManagerUtil;
        this.rfidBusiness = rfidBusiness;
        this.podRepository = podRepository;
        this.sender = sender;
        this.sectionRepository = sectionRepository;
        this.tripRepository = tripRepository;
        this.restTempConfig = restTempConfig;
        this.mapNodeRepository = mapNodeRepository;
        this.mdStationnodepositionRepository = mdStationnodepositionRepository;
        this.wmsSlamCarRepository = wmsSlamCarRepository;
    }

    public void execute() {
        if (this.getToken() == null) {
            logger.error("Token\u672a\u751f\u6210\uff0c\u7b49\u5f85\u4e0b\u4e00\u6b21\u5faa\u73af!");
            return;
        }
        RestTemplate restTemplate = this.builder.build();
        List wmsSlamTrips = this.wmsSlamTripRepository.findAllAvailableTrip();
        logger.error("\u67e5\u8be2\u5230 wmsSlamTrips:" + wmsSlamTrips.size());
        if (wmsSlamTrips != null && !wmsSlamTrips.isEmpty()) {
            for (int i = 0; i < wmsSlamTrips.size(); ++i) {
                WmsSlamTrip wmsSlamTrip = (WmsSlamTrip)wmsSlamTrips.get(i);
                logger.debug("\u51c6\u5907\u6267\u884c:" + wmsSlamTrip);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("taskId", wmsSlamTrip.getId());
                params.put("areaCode", wmsSlamTrip.getAreaCode());
                params.put("warehouseCode", wmsSlamTrip.getWarehouseCode());
                params.put("taskType", wmsSlamTrip.getTaskType());
                params.put("startStationCode", wmsSlamTrip.getStartTag());
                params.put("endStationCode", wmsSlamTrip.getEndTag());
                params.put("storageNo", wmsSlamTrip.getStorageNo());
                params.put("priority", wmsSlamTrip.getPriority());
                params.put("taskDateTime", wmsSlamTrip.getTaskDateTime() + ".123");
                String timespan = System.currentTimeMillis() + "";
                String sign = this.exportSign(params, timespan);
                logger.debug("params:" + params);
                logger.debug("sign:" + sign);
                try {
                    HttpHeaders headers = new HttpHeaders();
                    headers.add("sign", sign.toLowerCase());
                    headers.add("ACCESS_TOKEN", this.getToken());
                    headers.add("timespan", timespan);
                    MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
                    headers.setContentType(type);
                    headers.add("Accept", MediaType.APPLICATION_JSON.toString());
                    HttpEntity httpEntity = new HttpEntity((Object)JSONUtil.mapToJSon(params), (MultiValueMap)headers);
                    ResponseEntity responseEntity = restTemplate.postForEntity(this.mideaUrl, (Object)httpEntity, String.class, new Object[0]);
                    logger.info("Slam\u670d\u52a1\u5668\u8fd4\u56de\u6570\u636e\u662f:" + (String)responseEntity.getBody());
                    this.updateState((String)responseEntity.getBody(), wmsSlamTrip);
                }
                catch (Exception e) {
                    logger.error("\u53d1\u9001\u5230\u6fc0\u5149AGV\u51fa\u9519!", (Throwable)e);
                }
                logger.debug("\u6267\u884c\u5b8c\u6bd5:" + wmsSlamTrip);
            }
        }
    }

    private void updateState(String body, WmsSlamTrip wmsSlamTrip) {
        Map dataRes = JSONUtil.jsonToMap((String)body);
        if (!Objects.equals(dataRes.get("code"), CODE_OK)) {
            logger.error("\u5f02\u5e38\u7801\u975e0,\u540e\u53f0\u6267\u884c\u9519\u8bef!");
            return;
        }
        Map data = (Map)dataRes.get("data");
        String state = CommonUtils.parseString((String)"state", (Map)data);
        Integer iState = Integer.parseInt(state);
        String taskDateTime = (String)data.get("taskDateTime");
        wmsSlamTrip.setTripState(iState);
        wmsSlamTrip.setCarNo((String)data.get("carNo"));
        wmsSlamTrip.setTaskDateTime(taskDateTime);
        this.wmsSlamTripRepository.saveAndFlush((Object)wmsSlamTrip);
        logger.info("\u66f4\u65b0Slam\u8c03\u5ea6\u4efb\u52a1\u6210\u529f ID:" + wmsSlamTrip.getId());
    }

    public String exportSign(Map params, String timespan) {
        logger.info("\u8f93\u5165\u53c2\u6570:" + params);
        ArrayList keys = new ArrayList();
        keys.addAll(params.keySet());
        Collections.sort(keys);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.appSecret).append(timespan);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            stringBuilder.append(key).append(CommonUtils.parseString((String)key, (Map)params));
        }
        stringBuilder.append(timespan).append(this.appSecret);
        logger.debug("\u62fc\u63a5\u540e\u7684\u5b57\u7b26\u4e32\u662f:" + stringBuilder);
        String md5Str = CommonUtils.md5((String)stringBuilder.toString());
        logger.debug("MD5\u7684\u5b57\u7b26\u4e32\u662f:" + stringBuilder);
        return md5Str;
    }

    public void agvError(String agvErrorMsg) {
        logger.info("\u66f4\u65b0Slam\u8c03\u5ea6\u4efb\u52a1:" + agvErrorMsg);
        Map data = JSONUtil.jsonToMap((String)agvErrorMsg);
        String carNo = CommonUtils.parseString((String)"carNo", (Map)data);
        WmsSlamCar wmsSlamCar = this.wmsSlamCarRepository.findCar(carNo);
        if (wmsSlamCar == null) {
            wmsSlamCar = new WmsSlamCar();
            wmsSlamCar.setId(CommonUtils.genUUID());
        }
        String errorCode = CommonUtils.parseString((String)"carNo", (Map)data);
        String errorMsg = CommonUtils.parseString((String)"errorMsg", (Map)data);
        String status = CommonUtils.parseString((String)"status", (Map)data);
        String occurTime = CommonUtils.parseString((String)"occurTime", (Map)data);
        wmsSlamCar.setCarNo(carNo);
        wmsSlamCar.setErrorCode(errorCode);
        wmsSlamCar.setErrorMsg(errorMsg);
        wmsSlamCar.setStatus(status);
        wmsSlamCar.setOccurTime(occurTime);
        this.wmsSlamCarRepository.saveAndFlush((Object)wmsSlamCar);
    }

    public void agvTaskConfirm(String taskConfirm) {
        Integer placeMark;
        HashMap<String, Object> param;
        logger.info("\u66f4\u65b0Slam\u8c03\u5ea6\u4efb\u52a1:" + taskConfirm);
        Map data = JSONUtil.jsonToMap((String)taskConfirm);
        String taskId = (String)data.get("taskId");
        WmsSlamTrip wmsSlamTrip = (WmsSlamTrip)this.wmsSlamTripRepository.getOne((Serializable)((Object)taskId));
        String state = CommonUtils.parseString((String)"state", (Map)data);
        Integer iState = Integer.parseInt(state);
        String taskDateTime = (String)data.get("taskDateTime");
        wmsSlamTrip.setTripState(iState);
        wmsSlamTrip.setCarNo((String)data.get("carNo"));
        wmsSlamTrip.setTaskDateTime(taskDateTime);
        Pod pod = this.podRepository.getPodById(wmsSlamTrip.getStorageNo());
        if (Objects.equals(iState, WmsSlamTrip.LEAVING) && Objects.equals(wmsSlamTrip.getTaskType(), WmsSlamTrip.TASKTYPE_BACK)) {
            OutboundInstruct outboundInstruct = this.outboundInstructRepository.getInstruByInstructId(wmsSlamTrip.getInstructId());
            param = new HashMap<String, Object>();
            if (outboundInstruct != null) {
                param.put("ID", outboundInstruct.getMES_ID());
                param.put("INV_ORG_ID", outboundInstruct.getINV_ORG_ID());
                param.put("BILL_TYPE", outboundInstruct.getBILL_TYPE());
                param.put("BILL_NO", outboundInstruct.getBILL_NO());
                param.put("LABEL_NO", outboundInstruct.getLABEL_NO());
                param.put("INV_CODE", outboundInstruct.getINV_CODE());
                param.put("STOCK_QTY", outboundInstruct.getQTY());
                param.put("LABEL_NO", outboundInstruct.getLABEL_NO());
                param.put("INV_CODE", outboundInstruct.getINV_CODE());
                param.put("STOCK_QTY", outboundInstruct.getQTY());
            } else {
                param.put("ID", wmsSlamTrip.getInstructId());
                param.put("INV_ORG_ID", wmsSlamTrip.getInvOrgId());
                param.put("BILL_TYPE", wmsSlamTrip.getBillType());
            }
            param.put("STORAGE_NO_L", wmsSlamTrip.getStorageNo());
            param.put("CAR_NO", data.get("carNo"));
            param.put("LOC_CODE", wmsSlamTrip.getStartTag());
            param.put("DATETIME_STOCK", taskDateTime);
            param.put("STATUS", InstructStatus.CARBACK.getStatus());
            Map res = this.restTempConfig.outBoundAck(param);
            logger.error("\u8fd4\u56de\u503c res:" + res);
        }
        if (Objects.equals(iState, WmsSlamTrip.CARRYFINISH) && Objects.equals(wmsSlamTrip.getTaskType(), WmsSlamTrip.TASKTYPE_BACK) && (placeMark = this.getAddrCodeByEndTag(wmsSlamTrip.getEndTag())) != null && placeMark != 0) {
            pod.setPlaceMark(placeMark);
            this.podRepository.saveAndFlush((Object)pod);
            param = new HashMap();
            param.put("ID", pod.getId());
            param.put("NAME", pod.getName());
            param.put("TOWARD", "0");
            param.put("SECTION_ID", pod.getSectionId());
            param.put("PLACEMARK", placeMark);
            Section section = (Section)this.sectionRepository.getOne((Serializable)((Object)pod.getSectionId()));
            this.sender.sendMessage(param, section.getName(), "WMS_WCS_POD_ADD_REMOVE");
            ArrayList<String> tripStates = new ArrayList<String>();
            tripStates.add(TripState.NEW.getName());
            tripStates.add(TripState.AVAILABLE.getName());
            List trips = this.tripRepository.getTripsByPodId(tripStates, pod.getId(), pod.getSectionId());
            if (trips == null || trips.isEmpty()) {
                Trip trip = new Trip();
                trip.setTripType(TripType.POD_RUN.getName());
                trip.setTripState(TripState.NEW.getName());
                trip.setPodId(pod.getId());
                trip.setSectionId(pod.getSectionId());
                trip.setWarehouseId(pod.getWarehouseId());
                this.tripRepository.saveAndFlush((Object)trip);
            }
        }
        if (Objects.equals(iState, WmsSlamTrip.LEAVING) && Objects.equals(wmsSlamTrip.getTaskType(), WmsSlamTrip.TASKTYPE_OUT)) {
            pod.setPlaceMark(Integer.valueOf(0));
            this.podRepository.saveAndFlush((Object)pod);
            this.rfidBusiness.inventoryReduction(pod);
        }
        wmsSlamTrip.setTripState(Integer.valueOf(state));
        this.wmsSlamTripRepository.saveAndFlush((Object)wmsSlamTrip);
        logger.info("\u66f4\u65b0Slam\u8c03\u5ea6\u4efb\u52a1\u6210\u529f ID:" + taskId);
    }

    private String postData(Map map, String mesCallBackUrl) {
        RestTemplate restTemplate = this.builder.build();
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        HttpEntity httpEntity = new HttpEntity((Object)JSONUtil.mapToJSon((Map)map), (MultiValueMap)headers);
        ResponseEntity responseEntity = restTemplate.postForEntity(mesCallBackUrl, (Object)httpEntity, String.class, new Object[0]);
        logger.info("Slam\u670d\u52a1\u5668\u8fd4\u56de\u6570\u636e\u662f:" + (String)responseEntity.getBody());
        return (String)responseEntity.getBody();
    }

    private Integer getAddrCodeByEndTag(String endTag) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("endTag", endTag);
        List nodes = this.entityManagerUtil.executeNativeQuery(SQL_FINDADDRCODEBYENDTAG, data);
        if (nodes == null || nodes.isEmpty()) {
            logger.error("endTag:" + endTag + "\u672a\u5b9a\u4e49\u4e0d\u5b58\u5728:WMS_SLAM_NODE");
            return 0;
        }
        Map map = (Map)nodes.get(0);
        return (Integer)map.get("ADDRESSCODEID");
    }

    public String agvTaskSelect(String taskId) {
        RestTemplate restTemplate = this.builder.build();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taskId", taskId);
        String timespan = System.currentTimeMillis() + "";
        String sign = this.exportSign(params, timespan);
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.add("sign", sign.toLowerCase());
            headers.add("ACCESS_TOKEN", this.getToken());
            headers.add("timespan", timespan);
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            HttpEntity httpEntity = new HttpEntity((Object)JSONUtil.mapToJSon(params), (MultiValueMap)headers);
            ResponseEntity responseEntity = restTemplate.postForEntity(this.mideaUrl_select, (Object)httpEntity, String.class, new Object[0]);
            logger.info("Slam\u670d\u52a1\u5668\u8fd4\u56de\u6570\u636e\u662f:" + (String)responseEntity.getBody());
            return (String)responseEntity.getBody();
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u6fc0\u5149AGV\u51fa\u9519!", (Throwable)e);
            return e.getMessage();
        }
    }

    public String agvTaskFinish(String tagName, String mesId) {
        OutboundInstruct instuct = this.outboundInstructRepository.getInstruById(mesId);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("tagName", tagName);
        List nodes = this.entityManagerUtil.executeNativeQuery(SQL, data);
        if (nodes == null || nodes.isEmpty()) {
            return "tagName:" + tagName + "\u672a\u5b9a\u4e49\u4e0d\u5b58\u5728:WMS_SLAM_NODE";
        }
        Map map = (Map)nodes.get(0);
        String slamNode = (String)map.get("SLAM_NODE");
        WmsSlamTrip wmsSlamTrip = this.wmsSlamTripRepository.findTripByInstructAndEndTag(instuct.getId(), slamNode);
        wmsSlamTrip.setTripState(WmsSlamTrip.FINISHTASK);
        this.wmsSlamTripRepository.saveAndFlush((Object)wmsSlamTrip);
        return wmsSlamTrip.toString();
    }

    public void buildSlamEmptyPodInTrip() {
        List wmsSlamTrip = this.wmsSlamTripRepository.findAllEmptyPod();
        List nodes = this.entityManagerUtil.executeNativeQuery(SQL_SLAM_POD_IN, new HashMap());
        if (nodes == null || nodes.isEmpty()) {
            logger.error("\u6ca1\u6709\u627e\u5230SLAM\u56de\u5e93\u914d\u7f6e\u7684\u63a5\u9a73\u4f4d!");
            return;
        }
        for (int i = 0; i < wmsSlamTrip.size() && i < nodes.size(); ++i) {
            WmsSlamTrip slamTrip = (WmsSlamTrip)wmsSlamTrip.get(i);
            Map node = (Map)nodes.get(i);
            WmsSlamTrip slamTripBack = new WmsSlamTrip();
            slamTripBack.setStorageNo(slamTrip.getStorageNo());
            slamTripBack.setStartTag(slamTrip.getEndTag());
            slamTripBack.setEndTag((String)node.get("SLAM_NODE"));
            slamTripBack.setStorageNo(slamTrip.getStorageNo());
            slamTripBack.setTripState(WmsSlamTrip.AVAILABLE);
            slamTripBack.setPriority(Integer.valueOf(99));
            slamTripBack.setInstructId(slamTrip.getInstructId());
            slamTripBack.setInvOrgId(slamTrip.getInvOrgId());
            slamTripBack.setBillType(slamTrip.getBillType());
            slamTripBack.setTaskType(WmsSlamTrip.TASKTYPE_BACK);
            slamTripBack.setWarehouseCode(slamTrip.getWarehouseCode());
            slamTripBack.setAreaCode(slamTrip.getAreaCode());
            slamTrip.setTripState(WmsSlamTrip.EMPTYPODIN);
            this.wmsSlamTripRepository.saveAndFlush((Object)slamTrip);
            this.wmsSlamTripRepository.saveAndFlush((Object)slamTripBack);
            logger.debug("slamTrip" + slamTrip);
            logger.debug("slamTripBack" + slamTripBack);
        }
    }

    public synchronized String emptyPodBack(String workcenterCode, String mesId, String billType, String invOrgId, MushinyMessage mm) {
        mm.setCode((Object)"1");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("tagName", workcenterCode);
        List nodes = this.entityManagerUtil.executeNativeQuery(SQL, data);
        if (nodes == null || nodes.isEmpty()) {
            mm.setCode((Object)"0");
            mm.setMessage("tagName:" + workcenterCode + "\u672a\u5b9a\u4e49\u4e0d\u5b58\u5728:WMS_SLAM_NODE");
            return "tagName:" + workcenterCode + "\u672a\u5b9a\u4e49\u4e0d\u5b58\u5728:WMS_SLAM_NODE";
        }
        Map map = (Map)nodes.get(0);
        String slamNode = (String)map.get("SLAM_NODE");
        List wmsSlamTrips = this.wmsSlamTripRepository.findTripByEndTag(slamNode);
        if (wmsSlamTrips == null || wmsSlamTrips.isEmpty()) {
            mm.setCode((Object)"0");
            mm.setMessage("tagName:" + workcenterCode + "\u4e0d\u5b58\u5728\u5df2\u5b8c\u6210\u642c\u8fd0 \u72b6\u6001\u4e3a5\u7684SLAM\u8c03\u5ea6\u4efb\u52a1");
            return "tagName:" + workcenterCode + "\u4e0d\u5b58\u5728\u5df2\u5b8c\u6210\u642c\u8fd0 \u72b6\u6001\u4e3a5\u7684SLAM\u8c03\u5ea6\u4efb\u52a1";
        }
        if (wmsSlamTrips.size() > 1) {
            mm.setCode((Object)"0");
            mm.setMessage("tagName:" + workcenterCode + "\u5b58\u5728\u591a\u6761\u5df2\u5b8c\u6210\u642c\u8fd0 \u72b6\u6001\u4e3a5\u7684SLAM\u8c03\u5ea6\u4efb\u52a1");
            return "tagName:" + workcenterCode + "\u5b58\u5728\u591a\u6761\u5df2\u5b8c\u6210\u642c\u8fd0 \u72b6\u6001\u4e3a5\u7684SLAM\u8c03\u5ea6\u4efb\u52a1";
        }
        WmsSlamTrip wmsSlamTrip = (WmsSlamTrip)wmsSlamTrips.get(0);
        wmsSlamTrip.setTripState(WmsSlamTrip.FINISHTASK);
        this.wmsSlamTripRepository.saveAndFlush((Object)wmsSlamTrip);
        mm.setMessage(wmsSlamTrip.toString());
        mm.setCode((Object)"1");
        return wmsSlamTrip.toString();
    }

    public String slamPodOut(String podId, String mesId) {
        Pod pod = this.podRepository.getByPodIndex(Integer.parseInt(podId), SECTIONID);
        if (pod == null || pod.getPlaceMark() == null || pod.getPlaceMark() == 0) {
            return "\u6ca1\u6709\u8fd9\u4e2a\u8d27\u67b6" + podId + " \u6216\u8005\u8d27\u67b6\u6ca1\u6709\u5730\u5740";
        }
        Integer placeMark = pod.getPlaceMark();
        MapNode mapNode = this.mapNodeRepository.getByMapIdAndAddressCodeId(MAPID, placeMark.intValue());
        if (mapNode == null) {
            return "\u8d27\u67b6\u7684\u4f4d\u7f6e\u518d\u5730\u56fe\u4e0a\u4e0d\u5b58\u5728:" + placeMark;
        }
        List mdStationnodepositions = this.mdStationnodepositionRepository.getAllSlamInterNodes();
        if (mdStationnodepositions == null) {
            return "\u6ca1\u6709\u627e\u5230\u51fa\u5e93\u914d\u7f6e\u7684\u8282\u70b9";
        }
        Boolean contains = false;
        for (int i = 0; i < mdStationnodepositions.size(); ++i) {
            MdStationnodeposition mdStationnodeposition = (MdStationnodeposition)mdStationnodepositions.get(i);
            if (!Objects.equals(mdStationnodeposition.getNode().getId(), mapNode.getId())) continue;
            contains = true;
            break;
        }
        if (!contains.booleanValue()) {
            return "\u8d27\u67b6\u4e0d\u5728SLAM\u51fa\u5e93\u4f4d\u7f6e,\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u914d\u7f6e!";
        }
        String startTag = this.node2SlamTag(mapNode.getId());
        OutboundInstruct outboundInstruct = this.outboundInstructRepository.getInstruById(mesId);
        String endTag = this.getEndTag(outboundInstruct);
        WmsSlamTrip wmsSlamTrip = new WmsSlamTrip();
        wmsSlamTrip.setId(CommonUtils.genUUID());
        wmsSlamTrip.setAreaCode("NANSHA");
        wmsSlamTrip.setWarehouseCode("NANSHA");
        wmsSlamTrip.setTaskType(WmsSlamTrip.TASKTYPE_OUT);
        wmsSlamTrip.setStartTag(startTag);
        wmsSlamTrip.setEndTag(endTag);
        wmsSlamTrip.setPriority(Integer.valueOf(99));
        wmsSlamTrip.setStorageNo(pod.getId());
        wmsSlamTrip.setTaskDateTime(DateTimeUtil.getNowFormat((String)"yyyy-MM-DD HH:mm:ss"));
        wmsSlamTrip.setTripState(WmsSlamTrip.AVAILABLE);
        wmsSlamTrip.setBillType(outboundInstruct.getBILL_TYPE());
        wmsSlamTrip.setInvOrgId(outboundInstruct.getINV_ORG_ID());
        wmsSlamTrip.setInstructId(outboundInstruct.getId());
        this.wmsSlamTripRepository.saveAndFlush((Object)wmsSlamTrip);
        logger.info("\u751f\u6210SLAM\u7684\u8c03\u5ea6\u4efb\u52a1\uff0cWMS_SLAM_TRIP:" + wmsSlamTrip.getId());
        return "wmsSlamTrip" + wmsSlamTrip;
    }

    private String node2SlamTag(String endTag) {
        if (CommonUtils.isEmpty((String)endTag)) {
            logger.error("\u5730\u5740\u7801\u662f\u7a7a" + endTag);
            return null;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("nodeId", endTag);
        List nodes = this.entityManagerUtil.executeNativeQuery2(sql2, param);
        if (nodes != null && !nodes.isEmpty()) {
            Map data = (Map)nodes.get(0);
            return (String)data.get("SLAM_NODE");
        }
        return null;
    }

    private String getEndTag(OutboundInstruct instrutId) {
        String workcenterCode = instrutId.getWORKCENTER_CODE();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("workcenterCode", workcenterCode);
        List nodes = this.entityManagerUtil.executeNativeQuery2(sql3, param);
        if (nodes != null && !nodes.isEmpty()) {
            Map data = (Map)nodes.get(0);
            return (String)data.get("SLAM_NODE");
        }
        return null;
    }

    public String slamPodIn(String podId, String mesId) {
        Pod pod = this.podRepository.getByPodIndex(Integer.parseInt(podId), SECTIONID);
        if (pod == null || pod.getPlaceMark() != null && pod.getPlaceMark() != 0) {
            return "\u6ca1\u6709\u8fd9\u4e2a\u8d27\u67b6" + podId + " \u6216\u8005\u8d27\u67b6\u8bb0\u5f55\u5728\u4ed3\u5e93\u5185\uff0c\u4e0d\u5728\u4ed3\u5e93\u5916";
        }
        OutboundInstruct outboundInstruct = this.outboundInstructRepository.getInstruById(mesId);
        WmsSlamTrip slamTrip = this.wmsSlamTripRepository.findPodNode(pod.getId(), outboundInstruct.getId());
        if (slamTrip == null) {
            return "Pod:" + podId + " mesId:" + mesId + " \u6ca1\u6709SLAM\u51fa\u5e93\u4efb\u52a1\uff0c\u65e0\u6cd5\u4e0b\u53d1\u56de\u5e93\u4efb\u52a1";
        }
        List nodes = this.entityManagerUtil.executeNativeQuery(SQL_SLAM_POD_IN, new HashMap());
        if (nodes == null || nodes.isEmpty()) {
            logger.error("\u6ca1\u6709\u627e\u5230SLAM\u56de\u5e93\u914d\u7f6e\u7684\u63a5\u9a73\u4f4d!");
            return "\u6ca1\u6709\u627e\u5230SLAM\u56de\u5e93\u914d\u7f6e\u7684\u63a5\u9a73\u4f4d!";
        }
        Map node = (Map)nodes.get(0);
        WmsSlamTrip slamTripBack = new WmsSlamTrip();
        slamTripBack.setStorageNo(slamTrip.getStorageNo());
        slamTripBack.setStartTag(slamTrip.getEndTag());
        slamTripBack.setEndTag((String)node.get("SLAM_NODE"));
        slamTripBack.setStorageNo(slamTrip.getStorageNo());
        slamTripBack.setTripState(WmsSlamTrip.AVAILABLE);
        slamTripBack.setPriority(Integer.valueOf(99));
        slamTripBack.setInstructId(slamTrip.getInstructId());
        slamTripBack.setInvOrgId(slamTrip.getInvOrgId());
        slamTripBack.setBillType(slamTrip.getBillType());
        slamTripBack.setTaskType(WmsSlamTrip.TASKTYPE_BACK);
        slamTripBack.setWarehouseCode(slamTrip.getWarehouseCode());
        slamTripBack.setAreaCode(slamTrip.getAreaCode());
        this.wmsSlamTripRepository.saveAndFlush((Object)slamTripBack);
        logger.info("\u751f\u6210SLAM\u7684\u8c03\u5ea6\u4efb\u52a1\uff0cWMS_SLAM_TRIP:" + slamTripBack.getId());
        return "wmsSlamTrip" + slamTripBack;
    }

    public void buildPodOutTrip() {
        List stationnodes = this.mdStationnodepositionRepository.getSlamNodes(Stationnode.SLAMOUT);
        if (stationnodes == null || stationnodes.isEmpty()) {
            logger.error("\u672a\u5b9a\u4e49SLAM\u51fa\u5e93\u63a5\u9a73\u4f4d!");
            return;
        }
        for (int i = 0; i < stationnodes.size(); ++i) {
            MdStationnodeposition mdStationnodeposition = (MdStationnodeposition)stationnodes.get(i);
            MapNode mapNode = mdStationnodeposition.getNode();
            com.mushiny.wms.application.domain.Map map = (com.mushiny.wms.application.domain.Map)this.mapRepository.findOne((Serializable)((Object)mapNode.getMapId()));
            Section section = (Section)this.sectionRepository.getOne((Serializable)((Object)map.getSectionId()));
            List pods = this.podRepository.getByAddressCodeId(mapNode.getAddressCodeId(), section.getId());
            if (pods == null || pods.isEmpty()) {
                logger.error("\u51fa\u5e93\u4f4d:" + mapNode.getAddressCodeId() + "\u6ca1\u6709\u8d27\u67b6");
                continue;
            }
            Pod pod = (Pod)pods.get(0);
        }
    }

    public void buildPodInTrip() {
        List stationnodes = this.mdStationnodepositionRepository.getSlamNodes(Stationnode.SLAMIN);
        if (stationnodes == null || stationnodes.isEmpty()) {
            logger.error("\u672a\u5b9a\u4e49SLAM\u5165\u5e93\u63a5\u9a73\u4f4d!");
            return;
        }
    }
}

