/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.slam;

import com.mushiny.wms.slam.SlamTripService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class SlamTripExecuteTimer {
    private static final Logger LOG = LoggerFactory.getLogger(SlamTripExecuteTimer.class);
    private final SlamTripService slamTripService;

    @Autowired
    public SlamTripExecuteTimer(SlamTripService slamTripService) {
        this.slamTripService = slamTripService;
    }

    @Scheduled(fixedDelay=3000L, initialDelay=10000L)
    public void build() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("\u5f00\u59cb\u6267\u884cSLAM\u6267\u884c\u7ebf\u7a0b!");
            }
            this.slamTripService.execute();
            if (LOG.isDebugEnabled()) {
                LOG.debug("\u6267\u884cSLAM\u7ebf\u7a0b\u7ed3\u675f!");
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Scheduled(fixedDelay=3000L, initialDelay=10000L)
    public void buildPodOutTrip() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("\u5f00\u59cb\u6267\u884c:\u8865\u6551\u7559\u5728\u51fa\u5e93\u63a5\u9a73\u4f4d\u7684\u4e00\u4e9b\u4efb\u52a1!");
            }
            this.slamTripService.buildPodOutTrip();
            if (LOG.isDebugEnabled()) {
                LOG.debug("\u6267\u884c\u7ed3\u675f:\u8865\u6551\u7559\u5728\u51fa\u5e93\u63a5\u9a73\u4f4d\u7684\u4e00\u4e9b\u4efb\u52a1!");
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Scheduled(fixedDelay=3000L, initialDelay=10000L)
    public void buildPodInTrip() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("\u5f00\u59cb\u6267\u884c:\u8865\u6551\u7559\u5728\u5165\u5e93\u63a5\u9a73\u4f4d\u7684\u4e00\u4e9b\u4efb\u52a1!");
            }
            this.slamTripService.buildPodInTrip();
            if (LOG.isDebugEnabled()) {
                LOG.debug("\u6267\u884c\u7ed3\u675f:\u8865\u6551\u7559\u5728\u5165\u5e93\u63a5\u9a73\u4f4d\u7684\u4e00\u4e9b\u4efb\u52a1!");
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }
}

