/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.slam;

import com.mushiny.wms.application.domain.MushinyMessage;
import com.mushiny.wms.common.utils.JSONUtil;
import com.mushiny.wms.slam.SlamTripService;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/slam"})
public class SlamTripController {
    private static final Logger logger = LoggerFactory.getLogger(SlamTripController.class);
    private final SlamTripService slamTripService;

    public SlamTripController(SlamTripService slamTripService) {
        this.slamTripService = slamTripService;
    }

    @PostMapping(value={"/agvError"}, produces={"application/json"})
    public ResponseEntity<MushinyMessage> agvError(@RequestBody String agvErrorMsg) {
        Integer result = 0;
        String message = "success";
        try {
            this.slamTripService.agvError(agvErrorMsg);
        }
        catch (Exception e) {
            result = 1;
            logger.error(e.getMessage(), (Throwable)e);
            message = e.getMessage();
        }
        MushinyMessage mm = new MushinyMessage();
        mm.setCode((Object)result.toString());
        mm.setMessage(message);
        return ResponseEntity.ok((Object)mm);
    }

    @PostMapping(value={"/agvTaskConfirm"}, produces={"application/json"})
    public ResponseEntity<MushinyMessage> agvTaskConfirm(@RequestBody String taskConfirm) {
        Integer result = 0;
        String message = "success";
        try {
            this.slamTripService.agvTaskConfirm(taskConfirm);
        }
        catch (Exception e) {
            result = 1;
            logger.error(e.getMessage(), (Throwable)e);
            message = e.getMessage();
        }
        MushinyMessage mm = new MushinyMessage();
        mm.setCode((Object)result.toString());
        mm.setMessage(message);
        return ResponseEntity.ok((Object)mm);
    }

    @GetMapping(path={"/agvTaskSelect"})
    public String agvTaskSelect(HttpServletRequest request, HttpServletResponse response) {
        String taskId = request.getParameter("taskId");
        return this.slamTripService.agvTaskSelect(taskId);
    }

    @PostMapping(value={"/agvTaskFinish"}, produces={"application/json"})
    public ResponseEntity<MushinyMessage> agvTaskFinish(@RequestBody String finishTask) {
        Map req = JSONUtil.jsonToMap((String)finishTask);
        String tagName = (String)req.get("tagName");
        String mesId = (String)req.get("mesId");
        Integer result = 1;
        try {
            String res = this.slamTripService.agvTaskFinish(tagName, mesId);
            logger.info("res:" + res);
        }
        catch (Exception e) {
            result = 0;
            logger.error("tagName:" + tagName + " mesId:" + mesId, (Throwable)e);
        }
        String message = "fail";
        MushinyMessage mm = new MushinyMessage();
        if (result == 1) {
            message = "success";
        }
        mm.setCode((Object)result.toString());
        mm.setMessage(message);
        return ResponseEntity.ok((Object)mm);
    }

    @PostMapping(value={"/emptyPodBack"}, produces={"application/json"})
    public ResponseEntity<MushinyMessage> emptyPodBack(@RequestBody String podBack) {
        Map req = JSONUtil.jsonToMap((String)podBack);
        String workcenterCode = (String)req.get("WORKCENTER_CODE");
        String mesId = (String)req.get("ID");
        String billType = (String)req.get("BILL_TYPE");
        String invOrgId = (String)req.get("INV_ORG_ID");
        MushinyMessage mm = new MushinyMessage();
        mm.setDescribe("1\u6210\u529f, 0\u5931\u8d25");
        try {
            String res = this.slamTripService.emptyPodBack(workcenterCode, mesId, billType, invOrgId, mm);
            logger.info("res:" + res);
            mm.setMessage(res);
        }
        catch (Exception e) {
            logger.error("tagName:" + workcenterCode + " mesId:" + mesId, (Throwable)e);
            mm.setMessage(e.getMessage());
            mm.setCode((Object)0);
        }
        return ResponseEntity.ok((Object)mm);
    }

    @GetMapping(path={"/slamPodOut"})
    public String slamPodOut(HttpServletRequest request, HttpServletResponse response) {
        String podId = request.getParameter("podId");
        String mesId = request.getParameter("mesId");
        try {
            String res = this.slamTripService.slamPodOut(podId, mesId);
            logger.info("res:" + res);
            return res;
        }
        catch (Exception e) {
            logger.error("podId:" + podId, (Throwable)e);
            return e.getMessage();
        }
    }

    @GetMapping(path={"/slamPodIn"})
    public String slamPodIn(HttpServletRequest request, HttpServletResponse response) {
        String podId = request.getParameter("podId");
        String mesId = request.getParameter("mesId");
        try {
            String res = this.slamTripService.slamPodIn(podId, mesId);
            logger.info("res:" + res);
            return res;
        }
        catch (Exception e) {
            logger.error("podId:" + podId, (Throwable)e);
            return e.getMessage();
        }
    }
}

