/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.slam;

import com.mushiny.wms.common.utils.JSONUtil;
import com.mushiny.wms.slam.CommonUtils;
import com.mushiny.wms.slam.SlamTripService;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class SlamTokenTimer
implements CommandLineRunner {
    public static final Logger logger = LoggerFactory.getLogger(SlamTokenTimer.class);
    @Value(value="${mushiny.midea.slam.url.login}")
    private String slam_login;
    @Value(value="${mushiny.midea.slam.url.login.user}")
    private String user;
    @Value(value="${mushiny.midea.slam.url.login.passwd}")
    private String passwd;
    private final SlamTripService slamTripService;
    private final RestTemplateBuilder builder;

    @Autowired
    public SlamTokenTimer(SlamTripService slamTripService, RestTemplateBuilder builder) {
        this.slamTripService = slamTripService;
        this.builder = builder;
    }

    public void run(String ... strings) throws Exception {
        this.genToken();
    }

    @Scheduled(fixedDelay=1200000L, initialDelay=10000L)
    public void genToken() {
        RestTemplate restTemplate = this.builder.build();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", this.user);
        data.put("password", CommonUtils.md5((String)this.passwd).toLowerCase());
        String timespan = System.currentTimeMillis() + "";
        String sign = this.slamTripService.exportSign(data, timespan);
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.add("sign", sign);
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            HttpEntity httpEntity = new HttpEntity((Object)JSONUtil.mapToJSon(data), (MultiValueMap)headers);
            ResponseEntity responseEntity = restTemplate.postForEntity(this.slam_login, (Object)httpEntity, String.class, new Object[0]);
            logger.info("Slam\u670d\u52a1\u5668\u8fd4\u56de\u6570\u636e\u662f:" + (String)responseEntity.getBody());
            Map res = JSONUtil.jsonToMap((String)((String)responseEntity.getBody()));
            Map resData = (Map)res.get("data");
            String token = (String)resData.get("token");
            logger.debug("\u65b0token\u662f:" + token);
            this.slamTripService.setToken(token);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u5230\u6fc0\u5149AGV\u51fa\u9519!", (Throwable)e);
        }
    }
}

