/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.slam;

import com.mushiny.wms.application.domain.MushinyMessage;
import com.mushiny.wms.application.domain.WmsSlamTrip;
import com.mushiny.wms.common.utils.JSONUtil;
import com.mushiny.wms.slam.CommonUtils;
import com.mushiny.wms.slam.SlamTestService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/slamTest"})
public class SlamTestController {
    private static final Logger logger = LoggerFactory.getLogger(SlamTestController.class);
    @Value(value="${mushiny.midea.slam.appSecret}")
    private String appSecret;
    @Value(value="${mushiny.midea.slam.url}")
    private String mideaUrl;
    private final SlamTestService slamTestService;
    private final RestTemplateBuilder builder;
    public static final String AGV_TASK_CONFIRM = "http://localhost:12003/slam/agvTaskConfirm";
    public static final String AGV_TASK_FINISH = "http://localhost:12003/slam/agvTaskFinish";

    public SlamTestController(SlamTestService slamTestService, RestTemplate restTemplate, RestTemplateBuilder builder) {
        this.slamTestService = slamTestService;
        this.builder = builder;
    }

    @PostMapping(value={"/mesCallBack"}, produces={"application/json"})
    public ResponseEntity<MushinyMessage> mesCallBack(@RequestBody String callBack) {
        Map reqData = JSONUtil.jsonToMap((String)callBack);
        logger.debug("mesCallBack: " + reqData);
        MushinyMessage res = new MushinyMessage();
        res.setCode((Object)"0");
        res.setCode((Object)"ok");
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/agvTaskAssign"}, produces={"application/json"})
    public ResponseEntity<MushinyMessage> agvTaskConfirm(@RequestBody String taskConfirm) {
        Map reqData = JSONUtil.jsonToMap((String)taskConfirm);
        logger.debug("SlamTestController_agvTaskAssign reqData:" + reqData);
        MushinyMessage res = new MushinyMessage();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("state", WmsSlamTrip.PROCESS);
        data.put("taskDateTime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        data.put("carNo", "1");
        res.setData(data);
        res.setCode((Object)"0");
        res.setCode((Object)"ok");
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(path={"/agvRespone"})
    public String response(HttpServletRequest request, HttpServletResponse response) {
        String state = request.getParameter("state");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("taskId", request.getParameter("taskId"));
        params.put("areaCode", "NANSHA");
        params.put("warehouseCode", "NANSHA");
        params.put("taskType", "0");
        params.put("startTag", "");
        params.put("endTag", "");
        params.put("storageNo", "");
        params.put("priority", 99);
        params.put("carNo", "1");
        params.put("state", Integer.parseInt(state));
        params.put("taskDateTime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        RestTemplate restTemplate = this.builder.build();
        try {
            logger.debug("params:" + params);
            HttpHeaders headers = new HttpHeaders();
            MediaType type2 = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type2);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            HttpEntity httpEntity = new HttpEntity((Object)JSONUtil.mapToJSon(params), (MultiValueMap)headers);
            String res = (String)restTemplate.postForEntity(AGV_TASK_CONFIRM, (Object)httpEntity, String.class, new Object[0]).getBody();
            return res;
        }
        catch (RestClientException e) {
            return "fail: " + e.getMessage();
        }
    }

    @GetMapping(path={"/agvFinish"})
    public String agvFinish(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tagName", request.getParameter("tagName"));
        params.put("mesId", request.getParameter("mesId"));
        RestTemplate restTemplate = this.builder.build();
        try {
            logger.debug("params:" + params);
            HttpHeaders headers = new HttpHeaders();
            MediaType type2 = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type2);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            HttpEntity httpEntity = new HttpEntity((Object)JSONUtil.mapToJSon(params), (MultiValueMap)headers);
            String res = (String)restTemplate.postForEntity(AGV_TASK_FINISH, (Object)httpEntity, String.class, new Object[0]).getBody();
            return res;
        }
        catch (RestClientException e) {
            return "fail: " + e.getMessage();
        }
    }

    @GetMapping(path={"/agvStart"})
    public String agvStart(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("taskId", CommonUtils.genUUID());
        params.put("areaCode", "NANSHA");
        params.put("warehouseCode", "NANSHA");
        params.put("taskType", 0);
        params.put("startTag", request.getParameter("startTag"));
        params.put("endTag", request.getParameter("startTag"));
        params.put("storageNo", "0066f6c6-34a5-466c-a79f-9bbbc7320829");
        params.put("priority", 99);
        params.put("taskDateTime", DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss zzz"));
        String sign = this.exportSign(params);
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.add("sign", sign);
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            HttpEntity httpEntity = new HttpEntity((Object)JSONUtil.mapToJSon(params), (MultiValueMap)headers);
            RestTemplate restTemplate = this.builder.build();
            ResponseEntity responseEntity = restTemplate.postForEntity(this.mideaUrl, (Object)httpEntity, String.class, new Object[0]);
            logger.info("Slam\u670d\u52a1\u5668\u8fd4\u56de\u6570\u636e\u662f:" + (String)responseEntity.getBody());
            return (String)responseEntity.getBody();
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u5230\u6fc0\u5149AGV\u51fa\u9519!", (Throwable)e);
            return "\u53d1\u9001\u51fa\u9519 params:" + params;
        }
    }

    private String exportSign(Map params) {
        logger.info("\u8f93\u5165\u53c2\u6570:" + params);
        ArrayList keys = new ArrayList();
        keys.addAll(params.keySet());
        Collections.sort(keys);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.appSecret);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            stringBuilder.append(key).append(CommonUtils.parseString((String)key, (Map)params));
        }
        stringBuilder.append(this.appSecret);
        logger.debug("\u62fc\u63a5\u540e\u7684\u5b57\u7b26\u4e32\u662f:" + stringBuilder);
        String md5Str = CommonUtils.md5((String)stringBuilder.toString());
        logger.debug("MD5\u7684\u5b57\u7b26\u4e32\u662f:" + stringBuilder);
        return md5Str;
    }
}

