/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.slam;

import com.mushiny.wms.application.business.common.CommonBusiness;
import com.mushiny.wms.application.domain.MapNode;
import com.mushiny.wms.application.domain.MdStationnodeposition;
import com.mushiny.wms.application.domain.OutboundInstruct;
import com.mushiny.wms.application.domain.Trip;
import com.mushiny.wms.application.domain.WCSRobot;
import com.mushiny.wms.application.domain.WmsSlamTrip;
import com.mushiny.wms.application.domain.enums.TripState;
import com.mushiny.wms.application.domain.enums.TripType;
import com.mushiny.wms.application.repository.MapNodeRepository;
import com.mushiny.wms.application.repository.MdStationnodepositionRepository;
import com.mushiny.wms.application.repository.OutboundInstructRepository;
import com.mushiny.wms.application.repository.TripRepository;
import com.mushiny.wms.application.repository.WCSRobotRepository;
import com.mushiny.wms.application.repository.WmsSlamTripRepository;
import com.mushiny.wms.common.utils.DateTimeUtil;
import com.mushiny.wms.common.utils.EntityManagerUtil;
import com.mushiny.wms.slam.CommonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class MideaSlamListener {
    private static final Logger logger = LoggerFactory.getLogger(MideaSlamListener.class);
    public static final String INSTRUCTACK = "InstructAck";
    @Value(value="${mushiny.midea.slam.url}")
    private String mideaUrl;
    @Value(value="${mushiny.midea.slam.appSecret}")
    private String appSecret;
    private final RestTemplateBuilder builder;
    private final EntityManagerUtil entityManagerUtil;
    private final MdStationnodepositionRepository mdStationnodepositionRepository;
    private final WmsSlamTripRepository wmsSlamTripRepository;
    private final TripRepository tripRepository;
    private final CommonBusiness commonBusiness;
    private final WCSRobotRepository wcsRobotRepository;
    private final MapNodeRepository mapNodeRepository;
    private final OutboundInstructRepository outboundInstructRepository;
    private static final String sql3 = "SELECT SLAM_NODE FROM WMS_SLAM_NODE WHERE SLAM_NODENAME=:workcenterCode OR SLAM_NODENAME=:lineCode";
    private static final String sql2 = "SELECT * FROM WMS_SLAM_NODE WHERE NODEID=:nodeId";
    private static final String sql = "SELECT * FROM WD_NODE WHERE ADDRESSCODEID=:addrCode AND MAP_ID = '8a55cdc8-dd5c-4a07-87e7-3979511949de'";

    @Autowired
    public MideaSlamListener(RestTemplateBuilder builder, EntityManagerUtil entityManagerUtil, MdStationnodepositionRepository mdStationnodepositionRepository, WmsSlamTripRepository wmsSlamTripRepository, TripRepository tripRepository, CommonBusiness commonBusiness, WCSRobotRepository wcsRobotRepository, MapNodeRepository mapNodeRepository, OutboundInstructRepository outboundInstructRepository) {
        this.builder = builder;
        this.entityManagerUtil = entityManagerUtil;
        this.mdStationnodepositionRepository = mdStationnodepositionRepository;
        this.wmsSlamTripRepository = wmsSlamTripRepository;
        this.tripRepository = tripRepository;
        this.commonBusiness = commonBusiness;
        this.wcsRobotRepository = wcsRobotRepository;
        this.mapNodeRepository = mapNodeRepository;
        this.outboundInstructRepository = outboundInstructRepository;
    }

    @RabbitListener(bindings={@QueueBinding(value=@Queue(value="", durable="true"), exchange=@Exchange(value="section1", ignoreDeclarationExceptions="true"), key="InstructAck")})
    public void WCS_SLAM_InstructAck(Message message) {
        byte[] body = message.getBody();
        Map data = (Map)CommonUtils.toObject((byte[])body);
        if (data == null || data.isEmpty()) {
            return;
        }
        logger.info("\u76d1\u542cRabbitMQ\u5230\u4efb\u52a1\u6267\u884c\u5b8c\u6210\u7684\u6d88\u606f:" + data);
        String status = CommonUtils.parseString((String)"instructStatus", (Map)data);
        String targetAddress = CommonUtils.parseString((String)"targetAddress", (Map)data);
        if (!Objects.equals(status, "STOCKOUT")) {
            logger.error("\u4e0d\u662f\u505c\u6b62\u70b9\uff0c\u4efb\u52a1\u672a\u5b8c\u6210" + data);
            return;
        }
        String endTag = this.addrCode2Id(CommonUtils.parseString((String)"targetAddress", (Map)data));
        if (CommonUtils.isEmpty((String)endTag)) {
            return;
        }
        logger.debug("\u4e8c\u7ef4\u7801AGV\u76ee\u6807\u5730\u5740\u7801\u662f:" + CommonUtils.parseString((String)"targetAddress", (Map)data) + " \u5730\u5740\u7801ID\u662f:" + endTag);
        List allSlamInterNodes = this.mdStationnodepositionRepository.getAllSlamInterNodes();
        boolean contains = false;
        for (int i = 0; i < allSlamInterNodes.size(); ++i) {
            MdStationnodeposition mdStationnodeposition = (MdStationnodeposition)allSlamInterNodes.get(i);
            logger.debug(i + ": \u63a5\u9a73\u70b9\u4f4d:" + mdStationnodeposition.getNode().getAddressCodeId());
            if (!Objects.equals(mdStationnodeposition.getNode().getId(), endTag)) continue;
            contains = true;
            break;
        }
        if (!contains) {
            logger.debug("\u8c03\u5ea6\u5355\u76ee\u6807\u70b9\u4f4d\u4e0d\u662f\u6fc0\u5149AGV\u51fa\u5e93\u5de5\u4f5c\u7ad9,\u65e0\u9700\u53d1\u9001\u6fc0\u5149AGV\u6307\u4ee4:" + CommonUtils.parseString((String)"targetAddress", (Map)data));
            return;
        }
        String slamTag = this.node2SlamTag(endTag);
        String id = CommonUtils.genUUID();
        String instrutId = CommonUtils.parseString((String)"INSTRUCT", (Map)data);
        String tripId = CommonUtils.parseString((String)"tripId", (Map)data);
        OutboundInstruct outboundInstruct = this.outboundInstructRepository.getInstruByTripId(tripId);
        String targetTag = this.getEndTag(outboundInstruct);
        if (CommonUtils.isEmpty((String)targetTag)) {
            logger.error("\u6267\u884c\u5230SLAM\u51fa\u5e93\u4f4d\u7684\u8d27\u67b6\uff0c\u5728\u51fa\u5e93\u6307\u4ee4\u91cc\u672a\u5b9a\u4e49SLAM\u7ad9\u70b9:" + outboundInstruct);
            return;
        }
        WmsSlamTrip wmsSlamTrip = new WmsSlamTrip();
        wmsSlamTrip.setId(id);
        wmsSlamTrip.setAreaCode("NANSHA");
        wmsSlamTrip.setWarehouseCode("NANSHA");
        wmsSlamTrip.setTaskType(WmsSlamTrip.TASKTYPE_OUT);
        wmsSlamTrip.setStartTag(slamTag);
        wmsSlamTrip.setEndTag(targetTag);
        wmsSlamTrip.setPriority(Integer.valueOf(99));
        wmsSlamTrip.setStorageNo(CommonUtils.parseString((String)"podIndex", (Map)data));
        wmsSlamTrip.setTaskDateTime(DateTimeUtil.getNowFormat((String)"yyyy-MM-DD HH:mm:ss"));
        wmsSlamTrip.setTripState(WmsSlamTrip.AVAILABLE);
        wmsSlamTrip.setBillType(outboundInstruct.getBILL_TYPE());
        wmsSlamTrip.setInvOrgId(outboundInstruct.getINV_ORG_ID());
        wmsSlamTrip.setInstructId(outboundInstruct.getId());
        this.wmsSlamTripRepository.saveAndFlush((Object)wmsSlamTrip);
        logger.info("\u751f\u6210SLAM\u7684\u8c03\u5ea6\u4efb\u52a1\uff0cWMS_SLAM_TRIP:" + id);
        this.checkIfEmptyRun(CommonUtils.parseString((String)"driverId", (Map)data), CommonUtils.parseString((String)"tripId", (Map)data));
        logger.info("\u7ed3\u675f\u76d1\u542cRabbitMQ\u5230\u4efb\u52a1\u6267\u884c\u5b8c\u6210\u7684\u6d88\u606f:" + data);
    }

    private void checkIfEmptyRun(String robotId, String tripId) {
        ArrayList<String> params = new ArrayList<String>();
        params.add("Available");
        params.add("Process");
        List trips = this.tripRepository.getAllByRobotId(robotId, params);
        boolean needEmptyRun = true;
        for (int i = 0; i < trips.size(); ++i) {
            Trip trip = (Trip)trips.get(i);
            if (Objects.equals(trip.getId(), trip)) continue;
            needEmptyRun = false;
            break;
        }
        if (!needEmptyRun) {
            logger.error("\u5c0f\u8f66" + robotId + "\u5df2\u6709\u5176\u4ed6\u4efb\u52a1 \u65e0\u9700\u521b\u5efaEmptyRun!");
            return;
        }
        String sectionId = "ec229eb7-7e2b-43a8-b1c7-91bd807e91cf";
        WCSRobot robot = this.wcsRobotRepository.getWCSRobotByRobotId(robotId, sectionId);
        try {
            Integer moveTargetAddress = this.commonBusiness.getTargetAddress(sectionId, robot.getAddressCodeId());
            Trip moveTrip = new Trip();
            moveTrip.setTripType(TripType.MOVE_DRIVE.getName());
            moveTrip.setTripState(TripState.AVAILABLE.getName());
            moveTrip.setDriveId(robotId);
            moveTrip.setEndAddress(moveTargetAddress);
            moveTrip.setSectionId(sectionId);
            moveTrip.setWarehouseId("DEFAULT");
            moveTrip = (Trip)this.tripRepository.saveAndFlush((Object)moveTrip);
            if (logger.isDebugEnabled()) {
                logger.debug("\u751f\u6210\u51fa\u5e93\u5c0f\u8f66 {} \u8c03\u8d70\u7684\u8c03\u5ea6\u5355{}\u6210\u529f \u76ee\u6807{}", new Object[]{robotId, moveTrip.getId(), moveTargetAddress});
            }
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u51fa\u5e93\u5c0f\u8f66\u8c03\u8d70\u4efb\u52a1EmptyRun\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
    }

    private String getEndTag(OutboundInstruct instrutId) {
        String workcenterCode = instrutId.getWORKCENTER_CODE();
        String lineCode = instrutId.getLINE_CODE();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("workcenterCode", workcenterCode);
        param.put("lineCode", lineCode);
        logger.error("SELECT SLAM_NODE FROM WMS_SLAM_NODE WHERE SLAM_NODENAME=:workcenterCode OR SLAM_NODENAME=:lineCode\n params:" + param);
        List nodes = this.entityManagerUtil.executeNativeQuery2(sql3, param);
        if (nodes != null && !nodes.isEmpty()) {
            Map data = (Map)nodes.get(0);
            return (String)data.get("SLAM_NODE");
        }
        return null;
    }

    private String node2SlamTag(String endTag) {
        if (CommonUtils.isEmpty((String)endTag)) {
            logger.error("\u5730\u5740\u7801\u662f\u7a7a" + endTag);
            return null;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("nodeId", endTag);
        List nodes = this.entityManagerUtil.executeNativeQuery2(sql2, param);
        if (nodes != null && !nodes.isEmpty()) {
            Map data = (Map)nodes.get(0);
            return (String)data.get("SLAM_NODE");
        }
        return null;
    }

    private String addrCode2Id(String source) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("addrCode", source);
        MapNode node = this.mapNodeRepository.getByAddressCodeId("8a55cdc8-dd5c-4a07-87e7-3979511949de", Integer.parseInt(source));
        return node == null ? null : node.getId();
    }

    private String exportSign(Map params) {
        ArrayList keys = new ArrayList();
        keys.addAll(params.keySet());
        Collections.sort(keys);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.appSecret);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            stringBuilder.append(key).append(CommonUtils.parseString((String)key, (Map)params));
        }
        stringBuilder.append(this.appSecret);
        logger.debug("\u62fc\u63a5\u540e\u7684\u5b57\u7b26\u4e32\u662f:" + stringBuilder);
        String md5Str = CommonUtils.md5((String)stringBuilder.toString());
        logger.debug("MD5\u7684\u5b57\u7b26\u4e32\u662f:" + stringBuilder);
        return md5Str;
    }
}

