/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.slam;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class CommonUtils {
    private static final Logger logger = LoggerFactory.getLogger(CommonUtils.class);
    public static int podCorrectTheta;

    @Value(value="${pod.correctTheta}")
    public void setTheta(String theta) {
        podCorrectTheta = Integer.parseInt(theta);
    }

    public static String face2WorkStation(int podFace, int wsFace) {
        int[] fourFace = new int[]{podFace, (podFace + 270) % 360, (podFace + 180) % 360, (podFace + 90) % 360};
        int index = 0;
        for (int i = 0; i < fourFace.length; ++i) {
            int face = fourFace[i];
            if (wsFace != face) continue;
            index = i;
            break;
        }
        index = (index + 2) % 4;
        return "ABCD".charAt(index) + "";
    }

    public static int aFaceToward(int podFace, int wsFace, String needFace) {
        int correct = 0;
        if ("A".equals(needFace)) {
            correct = (wsFace + 180) % 360;
        }
        if ("B".equals(needFace)) {
            correct = (wsFace + (270 + podCorrectTheta) % 360) % 360;
        }
        if ("C".equals(needFace)) {
            correct = wsFace % 360;
        }
        if ("D".equals(needFace)) {
            correct = (wsFace + (90 + podCorrectTheta) % 360) % 360;
        }
        logger.debug("\u8ba1\u7b97\u65cb\u8f6c\u89d2\u5ea6\u7ea0\u504f\u89d2\u5ea6podCorrectTheta=" + podCorrectTheta);
        return (correct + podCorrectTheta) % 360;
    }

    public static String now2String(String format) {
        LocalDateTime localDateTime = LocalDateTime.now();
        DateTimeFormatter df = DateTimeFormatter.ofPattern(format);
        return df.format(localDateTime);
    }

    public static String convert2String(Date date, String format) {
        SimpleDateFormat formater = new SimpleDateFormat(format);
        try {
            return formater.format(date);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String genUUID() {
        return UUID.randomUUID().toString();
    }

    public static void main2(String[] args) {
        Random random = new Random();
        boolean i = false;
        Long ss = Long.parseLong("0");
        System.out.println(ss == 0L);
    }

    private static String loadFromFile(String s) {
        InputStream inputStream = CommonUtils.class.getResourceAsStream("/lisi.txt");
        InputStreamReader reader = new InputStreamReader(inputStream);
        StringBuffer sb = new StringBuffer();
        try {
            int tempchar;
            while ((tempchar = ((Reader)reader).read()) != -1) {
                if ((char)tempchar == '\r') continue;
                sb.append((char)tempchar);
            }
            ((Reader)reader).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static Object map2Bean(Class tClass, Map data) {
        int i;
        Object instance = null;
        try {
            instance = tClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Field[] fields = tClass.getDeclaredFields();
        HashMap<String, Method> methodNames = new HashMap<String, Method>();
        Method[] methods = tClass.getDeclaredMethods();
        for (i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            methodNames.put(method.getName().toUpperCase(), method);
        }
        for (i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String fieldName = field.getName();
            if (methodNames.get("GET" + fieldName.toUpperCase()) == null || methodNames.get("SET" + fieldName.toUpperCase()) == null || data.get(fieldName.toUpperCase()) == null) continue;
            Method methodSet = (Method)methodNames.get("SET" + fieldName.toUpperCase());
            try {
                methodSet.invoke(instance, data.get(fieldName.toUpperCase()));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return instance;
    }

    public static byte[] toByteArray(Object obj) {
        byte[] bytes = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            bytes = bos.toByteArray();
            oos.close();
            bos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return bytes;
    }

    public static Object toObject(byte[] bytes) {
        Object obj = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            obj = ois.readObject();
            ois.close();
            bis.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return obj;
    }

    public static void genUselessInfo(Map record) {
        record.put("CREATED_DATE", new Timestamp(System.currentTimeMillis()));
        record.put("CREATED_BY", "SYSTEM");
        record.put("WAREHOUSE_ID", "DEFAULT");
        record.put("ENTITY_LOCK", 0);
        record.put("VERSION", 0);
    }

    public static void modifyUselessInfo(Map record) {
        record.put("MODIFIED_BY", "SYSTEM");
        record.put("MODIFIED_DATE", new Timestamp(System.currentTimeMillis()));
    }

    public static Long parseLong(String key, Map data) {
        Object value = data.get(key);
        if (value == null) {
            return 0L;
        }
        return Long.parseLong("" + data.get(key));
    }

    public static Integer parseInteger(String key, Map data) {
        Object value = data.get(key);
        if (value == null) {
            return 0;
        }
        return new Double(value + "").intValue();
    }

    public static String parseString(String key, Map data) {
        Object value = data.get(key);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static double parseDouble(String key, Map data) {
        Object value = data.get(key);
        if (value == null) {
            return 0.0;
        }
        return Double.parseDouble(value.toString() + "");
    }

    public static boolean parseBoolean(String key, Map map) {
        Object value = map.get(key);
        if (value == null) {
            return false;
        }
        if (value.toString().equals("1")) {
            return true;
        }
        return Boolean.parseBoolean(value.toString() + "");
    }

    public static boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }

    public static short parseShort(String key, Map data) {
        Object value = data.get(key);
        if (value == null) {
            return 0;
        }
        return new Double(value + "").shortValue();
    }

    public static Integer long2Int(Long srcAddr) {
        return new Double(srcAddr + "").intValue();
    }

    public static void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static String formatDate(Date date) {
        return CommonUtils.convert2String((Date)date, (String)"YYYY-MM-dd HH:mm:ss");
    }

    public static Object createNewInstance(String className) {
        try {
            Object instance = BeanUtils.instantiate((Class)ClassUtils.forName((String)className, (ClassLoader)ClassUtils.getDefaultClassLoader()));
            return instance;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("\u521b\u5efa\u5bf9\u8c61\u5f02\u5e38", e);
        }
    }

    public static String md5(String src) {
        try {
            MessageDigest digist = MessageDigest.getInstance("MD5");
            byte[] rs = digist.digest(src.getBytes());
            StringBuilder digestHexStr = new StringBuilder();
            for (int i = 0; i < 16; ++i) {
                digestHexStr.append(CommonUtils.byteHEX((byte)rs[i]));
            }
            return digestHexStr.toString();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String byteHEX(byte ib) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] ob = new char[]{Digit[ib >>> 4 & 0xF], Digit[ib & 0xF]};
        String s = new String(ob);
        return s;
    }
}

