/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.rfid;

import com.mushiny.wms.application.domain.OutboundInstruct;
import com.mushiny.wms.common.utils.JSONUtil;
import com.mushiny.wms.rfid.MideaRFIDController;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class RFIDWebApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(MideaRFIDController.class);
    @Value(value="${mushiny.rfid.url.podOutReq}")
    private String rfidUrl_podOut;
    @Value(value="${mushiny.rfid.url.podInConfirm}")
    private String rfidUrl_podInConfirm;
    private final RestTemplateBuilder builder;

    @Autowired
    public RFIDWebApi(RestTemplateBuilder builder) {
        this.builder = builder;
    }

    public String podOutReq2(String podId, String moInfo, String addrCode) {
        String res;
        RestTemplate restTemplate = this.builder.build();
        HashMap<String, String> retMsg = new HashMap<String, String>();
        try {
            LOGGER.debug("podId:" + podId + " moInfo:" + moInfo + " addrCode:" + addrCode);
            res = (String)restTemplate.getForObject(this.rfidUrl_podOut, String.class, new Object[]{podId, moInfo, addrCode});
        }
        catch (RestClientException e) {
            LOGGER.error("podOutReq\u5931\u8d25! \u8bf7\u6c42\u53c2\u6570\u662f:podId:" + podId + " addrCode:" + addrCode + " moInfo:" + moInfo, (Throwable)e);
            retMsg.put("code", "0");
            retMsg.put("msg", "podOutReq\u5931\u8d25");
            return JSONUtil.mapToJSon(retMsg);
        }
        LOGGER.debug("podOutReq===>\u8fd4\u56de\u6d88\u606f\u662f:" + res);
        return res;
    }

    public String podOutReq(String podId, OutboundInstruct moInfo, String addrCode) {
        ResponseEntity res;
        RestTemplate restTemplate = this.builder.build();
        HashMap<String, String> retMsg = new HashMap<String, String>();
        HashMap<String, Object> reqData = new HashMap<String, Object>();
        HashMap<String, String> mo = new HashMap<String, String>();
        mo.put("LINE_CODE", moInfo.getLINE_CODE());
        mo.put("ASS_MO_NAME", moInfo.getASS_MO_NAME());
        mo.put("MITEM_CODE", moInfo.getMITEM_CODE());
        reqData.put("podId", podId);
        reqData.put("moInfo", mo);
        reqData.put("addrCode", addrCode);
        try {
            LOGGER.debug("RFID\u51fa\u5e93\u8bf7\u6c42podOutReq:" + JSONUtil.mapToJSon(reqData));
            HttpHeaders headers = new HttpHeaders();
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            HttpEntity httpEntity = new HttpEntity((Object)JSONUtil.mapToJSon(reqData), (MultiValueMap)headers);
            res = restTemplate.postForEntity(this.rfidUrl_podOut, (Object)httpEntity, String.class, new Object[0]);
        }
        catch (RestClientException e) {
            LOGGER.error("podOutReq\u5931\u8d25! \u8bf7\u6c42\u53c2\u6570\u662f:podId:" + podId + " addrCode:" + addrCode + " moInfo:" + moInfo, (Throwable)e);
            retMsg.put("code", "0");
            retMsg.put("msg", "podOutReq\u5931\u8d25");
            return JSONUtil.mapToJSon(retMsg);
        }
        LOGGER.debug("podOutReq===>\u8fd4\u56de\u6d88\u606f\u662f:" + (String)res.getBody());
        return (String)res.getBody();
    }

    public String podInConfirm(String podId, String addrCode, String type) {
        ResponseEntity res;
        RestTemplate restTemplate = this.builder.build();
        HashMap<String, String> retMsg = new HashMap<String, String>();
        HashMap<String, String> reqData = new HashMap<String, String>();
        reqData.put("podId", podId);
        reqData.put("type", type);
        reqData.put("addrCode", addrCode);
        try {
            LOGGER.debug("podId:" + podId + " type:" + type + " addrCode:" + addrCode);
            HttpHeaders headers = new HttpHeaders();
            MediaType type2 = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type2);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            HttpEntity httpEntity = new HttpEntity((Object)JSONUtil.mapToJSon(reqData), (MultiValueMap)headers);
            res = restTemplate.postForEntity(this.rfidUrl_podInConfirm, (Object)httpEntity, String.class, new Object[0]);
        }
        catch (RestClientException e) {
            LOGGER.error("podOutReq\u5931\u8d25! \u8bf7\u6c42\u53c2\u6570\u662f:podId:" + podId + " addrCode:" + addrCode + " type:" + type, (Throwable)e);
            retMsg.put("code", "0");
            retMsg.put("msg", "podOutReq\u5931\u8d25");
            return JSONUtil.mapToJSon(retMsg);
        }
        LOGGER.debug("podOutReq===>\u8fd4\u56de\u6d88\u606f\u662f:" + (String)res.getBody());
        return (String)res.getBody();
    }

    public String podInConfirm2(String podId, String addrCode, String type) {
        String res;
        RestTemplate restTemplate = this.builder.build();
        HashMap<String, String> retMsg = new HashMap<String, String>();
        try {
            LOGGER.debug("podInConfirm ====> podId:" + podId + " addrCode:" + addrCode + " type:" + type);
            res = (String)restTemplate.getForObject(this.rfidUrl_podInConfirm, String.class, new Object[]{podId, addrCode, type});
        }
        catch (RestClientException e) {
            LOGGER.error("podInConfirm\u5931\u8d25! \u8bf7\u6c42\u53c2\u6570\u662f:podId:" + podId + " addrCode:" + addrCode + " type:" + type, (Throwable)e);
            retMsg.put("code", "0");
            retMsg.put("msg", "podInConfirm\u5931\u8d25");
            return JSONUtil.mapToJSon(retMsg);
        }
        LOGGER.debug("podInConfirm===>\u8fd4\u56de\u6d88\u606f\u662f:" + res);
        return res;
    }
}

