/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.rfid;

import com.mushiny.wms.application.domain.OutboundInstruct;
import com.mushiny.wms.application.domain.Trip;
import com.mushiny.wms.application.repository.OutboundInstructRepository;
import com.mushiny.wms.application.repository.TripRepository;
import com.mushiny.wms.rfid.RFIDWebApi;
import java.util.HashMap;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mq"})
public class MqTestController {
    @Autowired
    private RabbitTemplate template;
    @Autowired
    private TripRepository tripRepository;
    @Autowired
    private OutboundInstructRepository outboundInstructRepository;
    @Autowired
    private RFIDWebApi rfidWebApi;

    @PostMapping(value={"/sendMessage"})
    public String sendMessage() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("podIndex", "731");
        data.put("tripId", "002a8331-5ece-43d8-9c06-508ef778f353");
        data.put("targetAddress", "21");
        data.put("tripType", "tripType");
        data.put("instructStatus", "STOCKOUT");
        String tripId = (String)data.get("tripId");
        Trip trip = this.tripRepository.getTripByID(tripId);
        String instruct = trip.getInstruct();
        OutboundInstruct oi = this.outboundInstructRepository.getInstruByInstructId(instruct);
        return "";
    }

    @PostMapping(value={"/sendMessage2"})
    public String sendMessage2() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("podIndex", "731");
        data.put("tripId", "002a8331-5ece-43d8-9c06-508ef778f353");
        data.put("targetAddress", "21");
        data.put("tripType", "tripType");
        data.put("instructStatus", "STOCKOUT");
        String res = this.rfidWebApi.podInConfirm("731", "21", "ANNTOMVIN");
        System.out.println(res);
        return res;
    }

    @PostMapping(value={"/testPodInConfirm"}, produces={"application/json"})
    public ResponseEntity<Object> testPodInConfirm(@RequestBody String instruct) {
        return ResponseEntity.ok((Object)instruct);
    }

    @PostMapping(value={"/testPodOutReq"}, produces={"application/json"})
    public ResponseEntity<Object> testPodOutReq(@RequestBody String instruct) {
        return ResponseEntity.ok((Object)instruct);
    }
}

