/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.rfid;

import com.mushiny.wms.application.business.common.RfidBusiness;
import com.mushiny.wms.application.domain.MdStationnodeposition;
import com.mushiny.wms.application.domain.OutboundInstruct;
import com.mushiny.wms.application.domain.Pod;
import com.mushiny.wms.application.domain.Section;
import com.mushiny.wms.application.domain.Trip;
import com.mushiny.wms.application.domain.enums.TripState;
import com.mushiny.wms.application.domain.enums.TripType;
import com.mushiny.wms.application.rabbitMq.RabbitMessageSender;
import com.mushiny.wms.application.repository.MdStationnodepositionRepository;
import com.mushiny.wms.application.repository.OutboundInstructRepository;
import com.mushiny.wms.application.repository.PodRepository;
import com.mushiny.wms.application.repository.SectionRepository;
import com.mushiny.wms.application.repository.TripRepository;
import com.mushiny.wms.common.utils.CommonUtil;
import com.mushiny.wms.common.utils.JSONUtil;
import com.mushiny.wms.rfid.RFIDWebApi;
import com.mushiny.wms.slam.CommonUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class MideaRFIDService {
    public static final String InstructAck = "InstructAck";
    @Autowired
    private TripRepository tripRepository;
    @Autowired
    private PodRepository podRepository;
    @Autowired
    RabbitMessageSender sender;
    @Autowired
    private RfidBusiness rfidBusiness;
    @Autowired
    private OutboundInstructRepository outboundInstructRepository;
    @Autowired
    private RFIDWebApi rfidWebApi;
    private static final Logger LOGGER = LoggerFactory.getLogger(MideaRFIDService.class);
    @Autowired
    private SectionRepository sectionRepository;
    @Autowired
    private MdStationnodepositionRepository mdStationnodepositionRepository;

    @RabbitListener(bindings={@QueueBinding(value=@Queue(value="", durable="true"), exchange=@Exchange(value="${mushiny.section}", ignoreDeclarationExceptions="true"), key="InstructAck")})
    public void InstructAck(Message message) {
        byte[] body = message.getBody();
        Map data = (Map)MideaRFIDService.toObject((byte[])body);
        LOGGER.info("MideaRFIDService \u6536\u5230\u6d88\u606f :" + data);
        String podId = CommonUtils.parseString((String)"podIndex", (Map)data);
        String addrCode = CommonUtils.parseString((String)"targetAddress", (Map)data);
        String type = (String)data.get("tripType");
        String status = (String)data.get("instructStatus");
        if (Objects.equals("STOCKOUT", status) && (Objects.equals("ANNTOMVOUT", type) || Objects.equals("LMGETMATERIAL", type))) {
            LOGGER.debug("\u53d1\u8d77\u51fa\u5e93\u7533\u8bf7\u5230RFID:" + data);
            String tripId = (String)data.get("tripId");
            Trip trip = this.tripRepository.getTripByID(tripId);
            Pod pod = this.podRepository.getPodById(podId);
            OutboundInstruct oi = this.outboundInstructRepository.getInstruByTripId(tripId);
            String res = this.rfidWebApi.podOutReq(pod.getPodIndex() + "", oi, pod.getPlaceMark() + "");
            LOGGER.debug("podOutReq\u8fd4\u56de\u4fe1\u606f====>" + res);
            return;
        }
        if (Objects.equals("RUNNING", status) && Objects.equals("PodRun", type)) {
            LOGGER.debug("\u53d1\u8d77\u5165\u5e93\u786e\u8ba4\u5230RFID" + data);
            Pod pod = this.podRepository.getPodById(podId);
            List pos = this.mdStationnodepositionRepository.getStationPositionByType(Integer.valueOf(3));
            boolean contains = false;
            for (int i = 0; i < pos.size(); ++i) {
                MdStationnodeposition mdStationnodeposition = (MdStationnodeposition)pos.get(i);
                if (mdStationnodeposition.getNode().getAddressCodeId() != pod.getPlaceMark().intValue()) continue;
                contains = true;
                break;
            }
            if (!contains) {
                LOGGER.error("\u8d27\u67b6\u5730\u5740\u7801\u975e\u7a7a\u8d27\u67b6\u5165\u5e93\u5de5\u4f5c\u7ad9\u505c\u6b62\u70b9:" + pod.getPlaceMark());
                return;
            }
            String res = this.rfidWebApi.podInConfirm(pod.getPodIndex() + "", pod.getPlaceMark() + "", "ANNTOMVIN");
            LOGGER.debug("podInConfirm\u8fd4\u56de\u4fe1\u606f====>" + res);
            return;
        }
        LOGGER.info("MideaRFIDService \u6d88\u606f\u5904\u7406\u7ed3\u675f!");
    }

    public static Object toObject(byte[] bytes) {
        Object obj = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            obj = ois.readObject();
            ois.close();
            bis.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return obj;
    }

    @Transactional
    public String podOutConfirm(String podId, String addrCode) {
        LOGGER.debug("\u51fa\u5e93\u786e\u8ba4podOutConfirm podId:" + podId + " addrCode" + addrCode);
        Pod pod = this.podRepository.getByPodIndex2(Integer.parseInt(podId));
        pod.setPlaceMark(Integer.valueOf(0));
        this.podRepository.saveAndFlush((Object)pod);
        this.rfidBusiness.inventoryReduction(pod);
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("code", 0);
        res.put("msg", "\u7a7a\u6599\u8f66\u51fa\u5e93\u8bf7\u6c42\u5904\u7406\u6210\u529f!");
        LOGGER.debug("\u51fa\u5e93\u786e\u8ba4\u6267\u884c\u6210\u529fpodOutConfirm podId:" + podId + " addrCode" + addrCode);
        return JSONUtil.mapToJSon(res);
    }

    public synchronized String podInReq(String podId, String addrCode) {
        LOGGER.debug("\u5165\u5e93\u8bf7\u6c42podInReq podId:" + podId + " addrCode" + addrCode);
        if (CommonUtil.isEmpty((String)addrCode) || Integer.parseInt(addrCode) == 0) {
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("code", 1);
            res.put("msg", "\u7a7a\u6599\u8f66\u5165\u5e93\u8bf7\u6c42\u5904\u7406\u5931\u8d25! " + podId + " : " + addrCode);
            return JSONUtil.mapToJSon(res);
        }
        Pod pod = this.podRepository.getByPodIndex2(Integer.parseInt(podId));
        Integer placeMark = pod.getPlaceMark();
        if (pod.getPlaceMark() != null && (long)pod.getPlaceMark().intValue() != 0L && !Objects.equals(Integer.parseInt(addrCode), placeMark)) {
            LOGGER.error("\u65e0\u6cd5\u6267\u884cRFID\u8d27\u67b6\u5165\u573a\uff0c\u8d27\u67b6\u4fe1\u606f\u5728\u7cfb\u7edf\u4e2d\u6709\u8bb0\u5f55\u7684\u4f4d\u7f6e\uff0c\u5e76\u4e14\u4e0eRFID\u53d1\u9001\u7684\u4f4d\u7f6e\u4e0d\u4e00\u81f4! placeMark" + placeMark + " addrCode" + addrCode);
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("code", 1);
            res.put("msg", "\u8d27\u67b6\u4fe1\u606f\u5728\u7cfb\u7edf\u4e2d\u6709\u8bb0\u5f55\u7684\u4f4d\u7f6e\uff0c\u5e76\u4e14\u4e0eRFID\u53d1\u9001\u7684\u4f4d\u7f6e\u4e0d\u4e00\u81f4! placeMark" + placeMark + " addrCode" + addrCode);
            LOGGER.debug("\u5165\u5e93\u8bf7\u6c42\u6267\u884c\u5b8c\u6210podInReq podId:" + podId + " addrCode" + addrCode);
            return JSONUtil.mapToJSon(res);
        }
        pod.setPlaceMark(Integer.valueOf(Integer.parseInt(addrCode)));
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("ID", pod.getId());
        param.put("NAME", pod.getName());
        param.put("TOWARD", "0");
        param.put("SECTION_ID", pod.getSectionId());
        param.put("PLACEMARK", addrCode);
        Section section = (Section)this.sectionRepository.getOne((Serializable)((Object)pod.getSectionId()));
        this.sender.sendMessage(param, section.getName(), "WMS_WCS_POD_ADD_REMOVE");
        ArrayList<String> states = new ArrayList<String>();
        states.add(TripState.AVAILABLE.getName());
        states.add(TripState.PROCESS.getName());
        List trips = this.tripRepository.getTripsByPodId(states, pod.getId(), pod.getSectionId());
        if (!trips.isEmpty()) {
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("code", 1);
            res.put("msg", "\u7a7a\u6599\u8f66\u5165\u5e93\u5df2\u6709\u4efb\u52a1\u5b58\u5728\u6216\u6267\u884c\uff0c\u8bf7\u6c42\u5904\u7406\u5931\u8d25! " + podId + " : " + addrCode);
            return JSONUtil.mapToJSon(res);
        }
        this.rfidBusiness.inventoryReduction(pod);
        Trip trip = new Trip();
        trip.setTripType(TripType.POD_RUN.getName());
        trip.setTripState(TripState.NEW.getName());
        trip.setPodId(pod.getId());
        trip.setSectionId(pod.getSectionId());
        trip.setWarehouseId(pod.getWarehouseId());
        this.tripRepository.saveAndFlush((Object)trip);
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("code", 0);
        res.put("msg", "\u7a7a\u6599\u8f66\u5165\u5e93\u8bf7\u6c42\u5904\u7406\u6210\u529f!");
        return JSONUtil.mapToJSon(res);
    }
}

