/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.pathPlanning.utils;

import com.mushiny.wms.application.domain.MapNeighbor;
import com.mushiny.wms.application.domain.MapNode;
import com.mushiny.wms.common.utils.DateTimeUtil;
import com.mushiny.wms.pathPlanning.business.AdmissibleHeuristic;
import com.mushiny.wms.pathPlanning.business.PathCommonBusiness;
import com.mushiny.wms.pathPlanning.jgrapht.MyDefaultWeightedEdge;
import com.mushiny.wms.pathPlanning.utils.JSONUtil;
import com.mushiny.wms.pathPlanning.utils.NodeCosteValue;
import com.mushiny.wms.pathPlanning.utils.Path;
import com.mushiny.wms.pathPlanning.utils.PathPair;
import com.mushiny.wms.pathPlanning.utils.UpdateCost;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;
import org.jgrapht.alg.interfaces.AStarAdmissibleHeuristic;
import org.jgrapht.alg.shortestpath.AStarShortestPath;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.DirectedWeightedPseudograph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
@Order(value=1)
@Transactional
public class MapNodeUtils
implements CommandLineRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapNodeUtils.class);
    private static final int EMPTYDRIVEPATH = 0;
    private static final int HEAVYDRIVEPATH = 1;
    private static final String SEPAR = System.getProperty("line.separator", "/n");
    private final Object lock = new Object();
    private Map<String, List<MapNeighbor>> mapNeighborsTemp = Collections.synchronizedMap(new HashMap());
    private Map<String, List<MapNeighbor>> mapNeighbors = Collections.synchronizedMap(new HashMap());
    private Map<String, Map<Integer, MapNode>> mapNodes = new HashMap();
    private List<UpdateCost> updateNodeCost = new ArrayList();
    private List<UpdateCost> recoverNodeCost = new ArrayList();
    private final MapNode defaultMapNode = new MapNode();
    private Map<String, com.mushiny.wms.application.domain.Map> maps = new HashMap();
    @Autowired
    private PathCommonBusiness pathCommonBusiness;

    public List<NodeCosteValue> getMinCost(String sectionId, Integer start, Integer end) {
        com.mushiny.wms.application.domain.Map mapTemp = (com.mushiny.wms.application.domain.Map)this.maps.get(sectionId);
        ArrayList<NodeCosteValue> finalResult = new ArrayList<NodeCosteValue>();
        HashMap<Integer, NodeCosteValue> result = new HashMap<Integer, NodeCosteValue>();
        if (!ObjectUtils.isEmpty((Object)mapTemp)) {
            String mapId = mapTemp.getId();
            List temp = (List)this.mapNeighbors.get(mapId);
            for (MapNeighbor mn : temp) {
                Integer newCost = mn.getNewCost();
                Integer addr = mn.getInNode().getAddressCodeId();
                Integer carryCost = mn.getCarryingCost();
                Integer costValue = -1;
                if (carryCost == -1) {
                    costValue = Integer.MAX_VALUE;
                } else {
                    Integer n = costValue = ObjectUtils.isEmpty((Object)newCost) ? carryCost : newCost;
                }
                if (!result.containsKey(addr)) {
                    NodeCosteValue cv = new NodeCosteValue();
                    cv.setInNode(addr);
                    cv.setCostType(mn.getCostType());
                    cv.setOutNode(Integer.valueOf(mn.getOutNode().getAddressCodeId()));
                    cv.setCostValue(costValue);
                    result.put(addr, cv);
                    continue;
                }
                NodeCosteValue ncv = (NodeCosteValue)result.get(addr);
                if (ncv.getCostValue() <= costValue) continue;
                ncv.setCostValue(costValue);
                ncv.setOutNode(Integer.valueOf(mn.getOutNode().getAddressCodeId()));
                ncv.setCostType(mn.getCostType());
            }
            if (!CollectionUtils.isEmpty(result)) {
                if (ObjectUtils.isEmpty((Object)end)) {
                    finalResult.add((NodeCosteValue)result.get(start));
                } else {
                    for (int k = start.intValue(); k <= end; ++k) {
                        finalResult.add((NodeCosteValue)result.get(k));
                    }
                }
            }
        }
        return finalResult;
    }

    public synchronized Map<String, Object> getPathPairDetail(String sectionId, String paths, int driverType) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List pathPairResult = null;
        Integer sumCost = 0;
        com.mushiny.wms.application.domain.Map mapTemp = (com.mushiny.wms.application.domain.Map)this.maps.get(sectionId);
        if (!ObjectUtils.isEmpty((Object)mapTemp)) {
            pathPairResult = this.findPathPairs((List)this.mapNeighbors.get(mapTemp.getId()), paths, driverType);
        }
        if (!CollectionUtils.isEmpty(pathPairResult)) {
            for (PathPair temp : pathPairResult) {
                sumCost = sumCost + temp.getWeight();
            }
        }
        result.put("details", pathPairResult);
        result.put("costSum", sumCost);
        return result;
    }

    private List<PathPair> findPathPairs(List<MapNeighbor> mapNeighbors, String paths, int driverType) {
        String[] pathTemp;
        int len;
        ArrayList<PathPair> result = new ArrayList<PathPair>();
        ArrayList<PathPair> pathPairs = null;
        if (!CollectionUtils.isEmpty(mapNeighbors)) {
            pathPairs = new ArrayList<PathPair>();
            for (MapNeighbor mapNeighbor : mapNeighbors) {
                PathPair pathPair = new PathPair(Integer.valueOf(mapNeighbor.getInNode().getAddressCodeId()), Integer.valueOf(mapNeighbor.getOutNode().getAddressCodeId()), Integer.valueOf(mapNeighbor.getCarryingCost()), Integer.valueOf(mapNeighbor.getCost()), mapNeighbor.getNewCost());
                pathPair.setWeight(Integer.valueOf(driverType));
                pathPairs.add(pathPair);
            }
        }
        if (!CollectionUtils.isEmpty(pathPairs) && (len = (pathTemp = paths.split(",")).length - 2) >= 1) {
            for (int k = 0; k < pathTemp.length - 1; ++k) {
                PathPair pathPairTemp = this.findPathPair(pathPairs, pathTemp[k], pathTemp[k + 1]);
                if (ObjectUtils.isEmpty((Object)pathPairTemp)) continue;
                result.add(pathPairTemp);
            }
        }
        return result;
    }

    private PathPair findPathPair(List<PathPair> pathPairs, String start, String end) {
        PathPair result = null;
        for (PathPair temp : pathPairs) {
            if (temp.getStart() != Integer.parseInt(start) || temp.getEnd() != Integer.parseInt(end)) continue;
            result = temp;
            break;
        }
        return result;
    }

    public synchronized List<Integer> getChangedCostValue(String sectionId, Integer changeValue) {
        com.mushiny.wms.application.domain.Map mapTemp = (com.mushiny.wms.application.domain.Map)this.maps.get(sectionId);
        ArrayList<Integer> finalResult = new ArrayList<Integer>();
        HashSet<Integer> changed = new HashSet<Integer>();
        HashSet<Integer> unChanged = new HashSet<Integer>();
        Integer costValue = ObjectUtils.isEmpty((Object)changeValue) ? 1000 : changeValue;
        if (!ObjectUtils.isEmpty((Object)mapTemp)) {
            String mapId = mapTemp.getId();
            List temp = (List)this.mapNeighbors.get(mapId);
            for (MapNeighbor mn : temp) {
                if (!ObjectUtils.isEmpty((Object)mn.getNewCost())) {
                    if (!mn.getNewCost().equals(costValue)) continue;
                    changed.add(mn.getOutNode().getAddressCodeId());
                    continue;
                }
                unChanged.add(mn.getOutNode().getAddressCodeId());
            }
            for (Integer addrTemp : changed) {
                if (unChanged.contains(addrTemp)) continue;
                finalResult.add(addrTemp);
            }
        }
        return finalResult;
    }

    public List<UpdateCost> getUpdateNodeCost() {
        return this.updateNodeCost;
    }

    public void setUpdateNodeCost(List<UpdateCost> updateNodeCost) {
        this.updateNodeCost = updateNodeCost;
    }

    public List<UpdateCost> getRecoverNodeCost() {
        return this.recoverNodeCost;
    }

    public void setRecoverNodeCost(List<UpdateCost> recoverNodeCost) {
        this.recoverNodeCost = recoverNodeCost;
    }

    public MapNode findMapNode(String mapId, int addr) {
        MapNode result = (MapNode)((Map)this.mapNodes.get(mapId)).get(addr);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5185\u5b58\u4e2d\u5730\u56fe{}\u4fe1\u606f\u5982\u4e0b" + SEPAR + "{}", (Object)mapId, (Object)this.printMapNodeByMapId(mapId, null));
        }
        Assert.notNull((Object)result, (String)("\u83b7\u53d6\u5730\u56fe " + mapId + " \u8282\u70b9" + addr + " \u5931\u8d25"));
        return result;
    }

    private void initMapNodes() {
        if (!CollectionUtils.isEmpty((Map)this.maps)) {
            for (Map.Entry temp : this.maps.entrySet()) {
                this.initMapNode(((com.mushiny.wms.application.domain.Map)temp.getValue()).getId());
            }
        }
    }

    private void initMapNode(String mapId) {
        List search = this.pathCommonBusiness.getMapNodeRepository().getEmptyNode(mapId);
        HashMap<Integer, MapNode> temp = new HashMap<Integer, MapNode>();
        for (MapNode mn : search) {
            temp.put(mn.getAddressCodeId(), mn);
        }
        this.mapNodes.put(mapId, temp);
    }

    private void initMapNeighbor() {
        if (!CollectionUtils.isEmpty((Map)this.maps)) {
            for (Map.Entry temp : this.maps.entrySet()) {
                List search = this.pathCommonBusiness.getMapNeighborRepository().getByMapId(((com.mushiny.wms.application.domain.Map)temp.getValue()).getId());
                this.mapNeighbors.put(((com.mushiny.wms.application.domain.Map)temp.getValue()).getId(), search);
            }
            this.mapNeighborsTemp = (Map)JSONUtil.deepClone((Object)this.mapNeighbors);
        }
    }

    private void initMap() {
        List mapsTemp = this.pathCommonBusiness.getMapRepository().getAllActiveMap();
        if (!CollectionUtils.isEmpty((Collection)mapsTemp)) {
            for (com.mushiny.wms.application.domain.Map temp : mapsTemp) {
                this.maps.put(temp.getSectionId(), temp);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("section {} mapId {} name {}", new Object[]{temp.getSectionId(), temp.getId(), temp.getName()});
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry temp : this.maps.entrySet()) {
            com.mushiny.wms.application.domain.Map m = (com.mushiny.wms.application.domain.Map)temp.getValue();
            sb.append("mapId=" + m.getId());
            sb.append(" mapName=" + m.getName());
            sb.append(" SectionId=" + m.getSectionId());
            sb.append(" WarehouseId=" + m.getWarehouseId());
            sb.append(SEPAR);
        }
        sb.append(this.printMapNodes());
        sb.append(this.printMapNeighbors());
        return sb.toString();
    }

    public String printMapNodes() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry temp : this.mapNodes.entrySet()) {
            sb.append(this.printMapNodeByMapId((String)temp.getKey(), null));
        }
        return sb.toString();
    }

    public String printMapNodeByMapId(String mapId, Integer add) {
        StringBuilder sb = new StringBuilder();
        sb.append("\u5730\u56fe" + mapId + "\u4fe1\u606f" + "----------");
        if (!ObjectUtils.isEmpty((Object)add)) {
            MapNode temp2 = (MapNode)((Map)this.mapNodes.get(mapId)).get(add);
            if (!ObjectUtils.isEmpty((Object)temp2)) {
                sb.append(SEPAR);
                sb.append(" MapNodeId=" + temp2.getId());
                sb.append(" AddressCode=" + temp2.getAddressCodeId());
            }
        } else {
            for (Map.Entry temp : ((Map)this.mapNodes.get(mapId)).entrySet()) {
                sb.append(SEPAR);
                MapNode temp2 = (MapNode)temp.getValue();
                sb.append(" MapNodeId=" + temp2.getId());
                sb.append(" AddressCode=" + temp2.getAddressCodeId());
                sb.append(SEPAR);
            }
        }
        return sb.toString();
    }

    public String printMapNodeBySectionId(String sectionId, Integer add) {
        String result = "";
        com.mushiny.wms.application.domain.Map mapTemp = (com.mushiny.wms.application.domain.Map)this.maps.get(sectionId);
        if (!ObjectUtils.isEmpty((Object)mapTemp)) {
            result = this.printMapNodeByMapId(mapTemp.getId(), add);
        }
        return result;
    }

    public String printMapNeighborByMapId(String mapId, Integer addr) {
        StringBuilder sb = new StringBuilder();
        sb.append(mapId + "cost \u4fe1\u606f" + "###########");
        sb.append(SEPAR);
        List mn = (List)this.mapNeighbors.get(mapId);
        for (MapNeighbor temp2 : mn) {
            if (temp2.getInNode().getAddressCodeId() != addr.intValue() && temp2.getOutNode().getAddressCodeId() != addr.intValue()) continue;
            sb.append(" mapNeighborId=" + temp2.getId());
            sb.append(" inMapNode=" + temp2.getInNode().getAddressCodeId());
            sb.append(" outMapNode=" + temp2.getOutNode().getAddressCodeId());
            sb.append(" newCost=" + temp2.getNewCost());
            sb.append(" cost=" + temp2.getCost());
            sb.append(" costType=" + temp2.getCostType());
            sb.append(" carryCostType=" + temp2.getCarryingCost());
            sb.append(SEPAR);
        }
        return sb.toString();
    }

    public String printMapNeighbors() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry temp : this.mapNodes.entrySet()) {
            sb.append(this.printMapNeighborByMapId((String)temp.getKey()));
        }
        return sb.toString();
    }

    public List<Map<String, Object>> getMapNeighborByMapId(String sectionId, Integer addr) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        com.mushiny.wms.application.domain.Map mapTemp = (com.mushiny.wms.application.domain.Map)this.maps.get(sectionId);
        if (!ObjectUtils.isEmpty((Object)mapTemp)) {
            List mn = (List)this.mapNeighbors.get(mapTemp.getId());
            for (MapNeighbor temp2 : mn) {
                HashMap<String, Object> tt;
                if (ObjectUtils.isEmpty((Object)addr)) {
                    tt = new HashMap<String, Object>();
                    tt.put("mapNeighborId", temp2.getId());
                    tt.put("inMapNode", temp2.getInNode().getAddressCodeId());
                    tt.put("outMapNode", temp2.getOutNode().getAddressCodeId());
                    tt.put("newCost", temp2.getNewCost());
                    tt.put("cost", temp2.getCost());
                    tt.put("costType", temp2.getCostType());
                    tt.put("carryCostValue", temp2.getCarryingCost());
                    result.add(tt);
                    continue;
                }
                if (temp2.getInNode().getAddressCodeId() != addr.intValue() && temp2.getOutNode().getAddressCodeId() != addr.intValue()) continue;
                tt = new HashMap();
                tt.put("mapNeighborId", temp2.getId());
                tt.put("inMapNode", temp2.getInNode().getAddressCodeId());
                tt.put("outMapNode", temp2.getOutNode().getAddressCodeId());
                tt.put("newCost", temp2.getNewCost());
                tt.put("cost", temp2.getCost());
                tt.put("costType", temp2.getCostType());
                tt.put("carryCostValue", temp2.getCarryingCost());
                result.add(tt);
            }
        }
        return result;
    }

    public String printMapNeighborByMapId(String mapId) {
        StringBuilder sb = new StringBuilder();
        sb.append("\u5730\u56fe" + mapId + "cost \u4fe1\u606f" + "###########");
        sb.append(SEPAR);
        List mn = (List)this.mapNeighbors.get(mapId);
        for (MapNeighbor temp2 : mn) {
            sb.append(" mapNeighborId=" + temp2.getId());
            sb.append(" inMapNode=" + temp2.getInNode().getAddressCodeId());
            sb.append(" outMapNode=" + temp2.getOutNode().getAddressCodeId());
            sb.append(" newCost=" + temp2.getNewCost());
            sb.append(" cost=" + temp2.getCost());
            sb.append(" costType=" + temp2.getCostType());
            sb.append(" carryCostType=" + temp2.getCarryingCost());
            sb.append(SEPAR);
        }
        return sb.toString();
    }

    public String printMapNeighbor(List<MapNeighbor> mn) {
        StringBuilder sb = new StringBuilder();
        for (MapNeighbor temp2 : mn) {
            sb.append(" mapNeighborId=" + temp2.getId());
            sb.append(" inMapNode=" + temp2.getInNode().getAddressCodeId());
            sb.append(" outMapNode=" + temp2.getOutNode().getAddressCodeId());
            sb.append(" newCost=" + temp2.getNewCost());
            sb.append(" cost=" + temp2.getCost());
            sb.append(" costType=" + temp2.getCostType());
            sb.append(" carryCostType=" + temp2.getCarryingCost());
            sb.append(SEPAR);
        }
        return sb.toString();
    }

    public String printMapNeighborBySectionId(String sectionId, Integer addr) {
        String result = null;
        com.mushiny.wms.application.domain.Map mapTemp = (com.mushiny.wms.application.domain.Map)this.maps.get(sectionId);
        if (!ObjectUtils.isEmpty((Object)mapTemp)) {
            result = ObjectUtils.isEmpty((Object)addr) ? this.printMapNeighborByMapId(mapTemp.getId()) : this.printMapNeighborByMapId(mapTemp.getId(), addr);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Object object = this.lock;
        synchronized (object) {
            this.initMap();
            this.initMapNodes();
            this.initMapNeighbor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateMapNeighborByMapId(String mapId, String addressList, String costValue) {
        Object object = this.lock;
        synchronized (object) {
            int result = 1;
            ArrayList<String> mapNeighbor = new ArrayList<String>();
            List<String> addressTemp = Arrays.asList(addressList.split(","));
            ArrayList<Integer> address = new ArrayList<Integer>();
            Integer cost = StringUtils.isEmpty((Object)costValue) ? null : Integer.valueOf(Integer.parseInt(costValue));
            for (String temp : addressTemp) {
                address.add(Integer.parseInt(temp));
            }
            LOGGER.info("\u63a5\u6536\u5230{}\u4e2a ---{}\u66f4\u6539cost\u503c {} ", new Object[]{address.size(), addressList, costValue});
            for (String temp : (List)this.mapNeighbors.get(mapId)) {
                if (!address.contains(temp.getOutNode().getAddressCodeId())) continue;
                temp.setNewCost(cost);
                mapNeighbor.add(temp);
            }
            if (!CollectionUtils.isEmpty(mapNeighbor)) {
                result = mapNeighbor.size();
            } else {
                LOGGER.error("\u672a\u627e\u5230{} \u8981\u4fee\u6539\u7684cost", (Object)costValue);
                result = 0;
            }
            UpdateCost uc = new UpdateCost();
            uc.setAddressList(addressList);
            uc.setCostValue(costValue);
            uc.setTime(DateTimeUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            if (StringUtils.isEmpty((Object)costValue)) {
                this.recoverNodeCost.add(uc);
            } else {
                this.updateNodeCost.add(uc);
            }
            LOGGER.info("\u66f4\u65b0\u7ed3\u679c\u6761\u6570 result===>" + result);
            return result;
        }
    }

    private MapNeighbor findMapNeighbor(List<MapNeighbor> mapNeighbors, MapNeighbor mapNeighbor) {
        for (MapNeighbor temp : mapNeighbors) {
            if (!temp.getId().equals(mapNeighbor.getId())) continue;
            return temp;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateHeavyDriveMapNeighborByMapId(String mapId, String addressList, String costValue) {
        Object object = this.lock;
        synchronized (object) {
            int result = 1;
            ArrayList<MapNeighbor> mapNeighbor = new ArrayList<MapNeighbor>();
            List<String> addressTemp = Arrays.asList(addressList.split(","));
            ArrayList<Integer> address = new ArrayList<Integer>();
            Integer cost = StringUtils.isEmpty((Object)costValue) ? 0 : Integer.parseInt(costValue);
            for (String temp : addressTemp) {
                address.add(Integer.parseInt(temp));
            }
            LOGGER.info("\u63a5\u6536{}\u4e2a ---{}\u66f4\u6539\u91cd\u8f66cost\u503c {} ", new Object[]{address.size(), addressList, costValue});
            for (String temp : (List)this.mapNeighborsTemp.get(mapId)) {
                if (!address.contains(temp.getOutNode().getAddressCodeId())) continue;
                MapNeighbor findMapNeighbor = this.findMapNeighbor((List)this.mapNeighbors.get(mapId), (MapNeighbor)temp);
                findMapNeighbor.setCarryingCost(temp.getCarryingCost() + cost);
                mapNeighbor.add(findMapNeighbor);
            }
            if (!CollectionUtils.isEmpty(mapNeighbor)) {
                result = 1;
            } else {
                LOGGER.error("\u672a\u627e\u5230{} \u8981\u4fee\u6539\u7684cost", (Object)costValue);
                result = 0;
            }
            UpdateCost uc = new UpdateCost();
            uc.setAddressList(addressList);
            uc.setCostValue(costValue);
            uc.setTime(DateTimeUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            uc.setCostType("HeavyDrive");
            if (cost < 0) {
                this.recoverNodeCost.add(uc);
            } else {
                this.updateNodeCost.add(uc);
            }
            return result;
        }
    }

    public int updateMapNeighborBySectionId(String sectionId, String addressList, String costValue) {
        int result = 0;
        com.mushiny.wms.application.domain.Map mapTemp = (com.mushiny.wms.application.domain.Map)this.maps.get(sectionId);
        if (!ObjectUtils.isEmpty((Object)mapTemp)) {
            result = this.updateMapNeighborByMapId(mapTemp.getId(), addressList, costValue);
        }
        return result;
    }

    public int updateHeavyDriveMapNeighborBySectionId(String sectionId, String addressList, String costValue) {
        int result = 0;
        com.mushiny.wms.application.domain.Map mapTemp = (com.mushiny.wms.application.domain.Map)this.maps.get(sectionId);
        if (!ObjectUtils.isEmpty((Object)mapTemp)) {
            result = this.updateHeavyDriveMapNeighborByMapId(mapTemp.getId(), addressList, costValue);
        }
        return result;
    }

    public void run(String ... args) throws Exception {
        LOGGER.info("\u5f00\u59cb\u52a0\u8f7d\u5730\u56fe....");
        this.init();
        LOGGER.info("\u52a0\u8f7d\u5730\u56fe\u7ed3\u675f");
    }

    public List<Integer> getDrivePathBySection(String sectionId, int sourceVertex, int targetVertex, int pathType) {
        List result = null;
        com.mushiny.wms.application.domain.Map mapTemp = (com.mushiny.wms.application.domain.Map)this.maps.get(sectionId);
        if (!ObjectUtils.isEmpty((Object)mapTemp)) {
            result = this.getDrivePathByMapId(mapTemp.getId(), sourceVertex, targetVertex, pathType);
        } else {
            LOGGER.error("\u8ba1\u7b97{} \u5230 {} \u7684\u8def\u5f84 \u672a\u627e\u5230section {} \u5bf9\u5e94\u7684\u5730\u56fe----\r\n{}", new Object[]{sourceVertex, targetVertex, sectionId, JSONUtil.toJSon((Object)this.maps)});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getDrivePathByMapId(String mapId, int sourceVertex, int targetVertex, int pathType) {
        Object object = this.lock;
        synchronized (object) {
            MapNode sourceNode = this.findMapNode(mapId, sourceVertex);
            MapNode targetNode = this.findMapNode(mapId, targetVertex);
            AStarShortestPath starShortestPath = this.getAStarShortestPath(mapId, pathType);
            GraphPath pathGraph = starShortestPath.getPath((Object)sourceNode, (Object)targetNode);
            List<Integer> result = pathGraph.getVertexList().stream().map(MapNode::getAddressCodeId).collect(Collectors.toList());
            ArrayList<String> wes = new ArrayList<String>();
            List weights = pathGraph.getEdgeList();
            for (DefaultWeightedEdge de : weights) {
                wes.add(de.toString());
            }
            LOGGER.info("{} \u5230 {} \u7684\u8def\u5f84\u4e3a{}", new Object[]{sourceVertex, targetVertex, JSONUtil.toJSon(result)});
            LOGGER.info("{} \u5230 {} \u7684cost\u4e3a{}", new Object[]{sourceVertex, targetVertex, JSONUtil.toJSon(wes)});
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getDrivePathDetail(String sectionId, int sourceVertex, int targetVertex, int pathType) {
        Object object = this.lock;
        synchronized (object) {
            com.mushiny.wms.application.domain.Map mapTemp = (com.mushiny.wms.application.domain.Map)this.maps.get(sectionId);
            HashMap<String, Object> details = new HashMap<String, Object>();
            if (!ObjectUtils.isEmpty((Object)mapTemp)) {
                MapNode sourceNode = this.findMapNode(mapTemp.getId(), sourceVertex);
                MapNode targetNode = this.findMapNode(mapTemp.getId(), targetVertex);
                AStarShortestPath starShortestPath = this.getAStarShortestPath(mapTemp.getId(), pathType);
                GraphPath pathGraph = starShortestPath.getPath((Object)sourceNode, (Object)targetNode);
                List result = pathGraph.getVertexList().stream().map(MapNode::getAddressCodeId).collect(Collectors.toList());
                ArrayList<String> wes = new ArrayList<String>();
                List weights = pathGraph.getEdgeList();
                for (DefaultWeightedEdge de : weights) {
                    wes.add(de.toString());
                }
                details.put("paths:", result);
                details.put("costsDetail", wes);
                details.put("costsSum", pathGraph.getWeight());
                LOGGER.info("{} \u5230 {} \u7684\u8def\u5f84\u4e3a{}", new Object[]{sourceVertex, targetVertex, JSONUtil.toJSon(result)});
                LOGGER.info("{} \u5230 {} \u7684cost\u4e3a{}", new Object[]{sourceVertex, targetVertex, JSONUtil.toJSon(wes)});
            } else {
                LOGGER.error("\u8ba1\u7b97{} \u5230 {} \u7684\u8def\u5f84 \u672a\u627e\u5230section {} \u5bf9\u5e94\u7684\u5730\u56fe----\r\n{}", new Object[]{sourceVertex, targetVertex, sectionId, JSONUtil.toJSon((Object)this.maps)});
            }
            return details;
        }
    }

    private Path buildPath(String sectionId, int sourceVertex, int targetVertex, int pathType) {
        com.mushiny.wms.application.domain.Map mapTemp = (com.mushiny.wms.application.domain.Map)this.maps.get(sectionId);
        HashMap details = new HashMap();
        Path root = null;
        HashMap keys = new HashMap();
        if (!ObjectUtils.isEmpty((Object)mapTemp)) {
            MapNode sourceNode = this.findMapNode(mapTemp.getId(), sourceVertex);
            MapNode targetNode = this.findMapNode(mapTemp.getId(), targetVertex);
            root = new Path(sourceNode);
            DirectedWeightedPseudograph graph = new DirectedWeightedPseudograph(MyDefaultWeightedEdge.class);
            int cost = -1;
            for (Map.Entry mapNode : ((Map)this.mapNodes.get(mapTemp.getId())).entrySet()) {
                graph.addVertex(mapNode.getValue());
            }
            for (MapNeighbor mapNeighbor : (List)this.mapNeighbors.get(mapTemp.getId())) {
                Integer newCost = mapNeighbor.getNewCost();
                cost = pathType == 1 ? mapNeighbor.getCarryingCost() : mapNeighbor.getCost();
                if (newCost != null && newCost >= 0 && cost != -1) {
                    Graphs.addEdge((Graph)graph, (Object)mapNeighbor.getInNode(), (Object)mapNeighbor.getOutNode(), (double)(newCost + cost));
                    continue;
                }
                if (cost < 0) continue;
                Graphs.addEdge((Graph)graph, (Object)mapNeighbor.getInNode(), (Object)mapNeighbor.getOutNode(), (double)cost);
            }
            this.build(keys, graph.outgoingEdgesOf((Object)sourceNode), graph, root, sourceNode);
            ArrayList ll = new ArrayList();
            ArrayList resu = new ArrayList();
            this.buildPath(ll, root, resu);
        }
        return root;
    }

    private Path build(Map<Integer, Integer> paths, Set<MyDefaultWeightedEdge> mdw, DirectedWeightedPseudograph<MapNode, MyDefaultWeightedEdge> graph, Path root, MapNode sourceNode) {
        Path result = root;
        for (MyDefaultWeightedEdge me : mdw) {
            MapNode source = (MapNode)me.getSource();
            MapNode target = (MapNode)me.getTarget();
            if (paths.containsKey(target.getAddressCodeId())) continue;
            paths.put(target.getAddressCodeId(), source.getAddressCodeId());
            Path rootTemp = new Path(target);
            Set temp = graph.outgoingEdgesOf((Object)target);
            if (!CollectionUtils.isEmpty((Collection)temp)) {
                this.build(paths, temp, graph, rootTemp, target);
                continue;
            }
            result.getNext().add(rootTemp);
        }
        return result;
    }

    public void buildPath(List<MapNode> stack, Path root, List<String> pathList) {
        if (root != null) {
            stack.add(root.getCurrent());
            if (root.getNext().size() == 0) {
                this.changeToPath(stack, pathList);
            } else {
                List items = root.getNext();
                for (int i = 0; i < items.size(); ++i) {
                    this.buildPath(stack, (Path)items.get(i), pathList);
                }
            }
            stack.remove(stack.size() - 1);
        }
    }

    public void changeToPath(List<MapNode> path, List<String> pathList) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < path.size(); ++i) {
            if (path.get(i) == null) continue;
            sb.append(path.get(i).getAddressCodeId() + " ");
        }
        pathList.add(sb.toString().trim());
    }

    private AStarShortestPath<MapNode, MyDefaultWeightedEdge> getAStarShortestPath(String mapId, int pathType) {
        AStarShortestPath starShortestPath = null;
        try {
            DirectedWeightedPseudograph graph = new DirectedWeightedPseudograph(MyDefaultWeightedEdge.class);
            int cost = -1;
            for (Map.Entry mapNode : ((Map)this.mapNodes.get(mapId)).entrySet()) {
                graph.addVertex(mapNode.getValue());
            }
            for (MapNeighbor mapNeighbor : (List)this.mapNeighbors.get(mapId)) {
                Integer newCost = mapNeighbor.getNewCost();
                cost = pathType == 1 ? mapNeighbor.getCarryingCost() : mapNeighbor.getCost();
                if (newCost != null && newCost >= 0 && cost != -1) {
                    Graphs.addEdge((Graph)graph, (Object)mapNeighbor.getInNode(), (Object)mapNeighbor.getOutNode(), (double)(newCost + cost));
                    continue;
                }
                if (cost < 0) continue;
                Graphs.addEdge((Graph)graph, (Object)mapNeighbor.getInNode(), (Object)mapNeighbor.getOutNode(), (double)cost);
            }
            starShortestPath = new AStarShortestPath((Graph)graph, (AStarAdmissibleHeuristic)new AdmissibleHeuristic());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return starShortestPath;
    }

    private String getPath(String mapId) {
        String result = "";
        Integer[] it = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8};
        DefaultDirectedGraph g = new DefaultDirectedGraph(DefaultEdge.class);
        for (Integer temp : it) {
            g.addVertex((Object)temp);
        }
        Graphs.addEdgeWithVertices((Graph)g, (Object)1, (Object)2);
        Graphs.addEdgeWithVertices((Graph)g, (Object)2, (Object)3);
        Graphs.addEdgeWithVertices((Graph)g, (Object)3, (Object)4);
        Graphs.addEdgeWithVertices((Graph)g, (Object)1, (Object)5);
        Graphs.addEdgeWithVertices((Graph)g, (Object)2, (Object)6);
        Graphs.addEdgeWithVertices((Graph)g, (Object)3, (Object)7);
        Graphs.addEdgeWithVertices((Graph)g, (Object)4, (Object)8);
        Graphs.addEdgeWithVertices((Graph)g, (Object)5, (Object)6);
        Graphs.addEdgeWithVertices((Graph)g, (Object)6, (Object)7);
        Graphs.addEdgeWithVertices((Graph)g, (Object)7, (Object)8);
        result = g.toString();
        return result;
    }
}

