/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.pathPlanning.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.json.JsonParser;
import org.springframework.boot.json.JsonParserFactory;
import org.springframework.util.ObjectUtils;

public class JSONUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSONUtil.class);
    private static ObjectMapper objectMapper = new ObjectMapper();
    private static final JsonParser parser = JsonParserFactory.getJsonParser();

    public static <T> T deepClone(T src) {
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            ObjectOutputStream outObj = new ObjectOutputStream(bo);
            outObj.writeObject(src);
            ByteArrayInputStream bi = new ByteArrayInputStream(bo.toByteArray());
            ObjectInputStream outIn = new ObjectInputStream(bi);
            Object m = outIn.readObject();
            return (T)m;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String mapToJSon(Map data) {
        String result = "";
        if (data != null && !data.isEmpty()) {
            try {
                result = objectMapper.writeValueAsString((Object)data);
            }
            catch (JsonProcessingException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public static String toJSon(Object object) {
        String result = "";
        if (!ObjectUtils.isEmpty((Object)object)) {
            try {
                objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                result = objectMapper.writeValueAsString(object);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public static List jsonToList(String json) {
        return parser.parseList(json);
    }

    public static Map jsonToMap(String object) {
        return parser.parseMap(object);
    }
}

