/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.pathPlanning.service.impl;

import com.mushiny.wms.pathPlanning.business.PathPlanningBusiness;
import com.mushiny.wms.pathPlanning.business.TurnPanningBusiness;
import com.mushiny.wms.pathPlanning.service.PlanningService;
import com.mushiny.wms.pathPlanning.utils.MapNodeUtils;
import com.mushiny.wms.pathPlanning.utils.NodeCosteValue;
import com.mushiny.wms.pathPlanning.utils.UpdateCost;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PlanningServiceImpl
implements PlanningService {
    private final PathPlanningBusiness pathPlanningBusiness;
    private final TurnPanningBusiness turnPanningBusiness;
    private final MapNodeUtils mapNodeUtils;

    @Autowired
    public PlanningServiceImpl(TurnPanningBusiness turnPanningBusiness, PathPlanningBusiness pathPlanningBusiness, MapNodeUtils mapNodeUtils) {
        this.turnPanningBusiness = turnPanningBusiness;
        this.pathPlanningBusiness = pathPlanningBusiness;
        this.mapNodeUtils = mapNodeUtils;
    }

    public List<Integer> getEmptyDrivePath(String warehouseId, String sectionId, int sourceVertex, int targetVertex) {
        return this.pathPlanningBusiness.getEmptyDrivePath(warehouseId, sectionId, sourceVertex, targetVertex);
    }

    public List<Integer> getHeavyDrivePath(String warehouseId, String sectionId, int sourceVertex, int targetVertex) {
        return this.pathPlanningBusiness.getHeavyDrivePath(warehouseId, sectionId, sourceVertex, targetVertex);
    }

    public int getPodTurning(String face, int sourceToward, int targetToward) {
        return this.turnPanningBusiness.getPodTurning(face, sourceToward, targetToward);
    }

    public int updateNewCost(String warehouseId, String sectionId, String addressList, String newCost) {
        return this.mapNodeUtils.updateMapNeighborBySectionId(sectionId, addressList, newCost);
    }

    public int updateHeavyDriveCost(String warehouseId, String sectionId, String addressList, String newCost) {
        return this.mapNodeUtils.updateHeavyDriveMapNeighborBySectionId(sectionId, addressList, newCost);
    }

    public String getMapNode(String sectionId, Integer add) {
        return this.mapNodeUtils.printMapNodeBySectionId(sectionId, add);
    }

    public List<Map<String, Object>> getMapNeighbor(String sectionId, Integer add) {
        return this.mapNodeUtils.getMapNeighborByMapId(sectionId, add);
    }

    public List<UpdateCost> getUpdateNodeCost() {
        return this.mapNodeUtils.getUpdateNodeCost();
    }

    public List<UpdateCost> getRecoverNodeCost() {
        return this.mapNodeUtils.getRecoverNodeCost();
    }

    public List<NodeCosteValue> getMinCost(String sectionId, Integer start, Integer end) {
        return this.mapNodeUtils.getMinCost(sectionId, start, end);
    }

    public int updateMap() {
        this.mapNodeUtils.init();
        return 1;
    }

    public List<Integer> getChangedCostValue(String sectionId, Integer changeValue) {
        return this.mapNodeUtils.getChangedCostValue(sectionId, changeValue);
    }

    public Map<String, Object> getHeavyDrivePathDetail(String warehouseId, String sectionId, int sourceVertex, int targetVertex) {
        return this.mapNodeUtils.getDrivePathDetail(sectionId, sourceVertex, targetVertex, 1);
    }

    public Map<String, Object> getEmptyDrivePathDetail(String sectionId, String paths) {
        return this.mapNodeUtils.getPathPairDetail(sectionId, paths, 0);
    }

    public Map<String, Object> getHeavyDrivePathDetail(String sectionId, String paths) {
        return this.mapNodeUtils.getPathPairDetail(sectionId, paths, 1);
    }

    public Map<String, Object> getEmptyDrivePathDetail(String warehouseId, String sectionId, int sourceVertex, int targetVertex) {
        return this.mapNodeUtils.getDrivePathDetail(sectionId, sourceVertex, targetVertex, 0);
    }
}

