/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.pathPlanning.business;

import com.mushiny.wms.application.domain.Map;
import com.mushiny.wms.application.domain.MapNeighbor;
import com.mushiny.wms.application.domain.MapNode;
import com.mushiny.wms.application.repository.MapNeighborRepository;
import com.mushiny.wms.application.repository.MapNodeRepository;
import com.mushiny.wms.application.repository.MapRepository;
import com.mushiny.wms.common.exception.ApiException;
import com.mushiny.wms.common.exception.ExceptionEnum;
import com.mushiny.wms.pathPlanning.business.AdmissibleHeuristic;
import com.mushiny.wms.pathPlanning.utils.MapNodeUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;
import org.jgrapht.alg.interfaces.AStarAdmissibleHeuristic;
import org.jgrapht.alg.shortestpath.AStarShortestPath;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.DirectedWeightedPseudograph;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PathPlanningBusiness {
    private final MapRepository mapRepository;
    private final MapNodeRepository mapNodeRepository;
    private final MapNeighborRepository mapNeighborRepository;
    @Autowired
    public MapNodeUtils mapNodeUtils;

    @Autowired
    public PathPlanningBusiness(MapNeighborRepository mapNeighborRepository, MapRepository mapRepository, MapNodeRepository mapNodeRepository) {
        this.mapNeighborRepository = mapNeighborRepository;
        this.mapRepository = mapRepository;
        this.mapNodeRepository = mapNodeRepository;
    }

    public List<Integer> getEmptyDrivePath(String warehouseId, String sectionId, int sourceVertex, int targetVertex) {
        return this.mapNodeUtils.getDrivePathBySection(sectionId, sourceVertex, targetVertex, 0);
    }

    public List<Integer> getHeavyDrivePath(String warehouseId, String sectionId, int sourceVertex, int targetVertex) {
        return this.mapNodeUtils.getDrivePathBySection(sectionId, sourceVertex, targetVertex, 1);
    }

    public List<Integer> getEmptyDrivePath2(String warehouseId, String sectionId, int sourceVertex, int targetVertex) {
        MapNode targetNode;
        Map map = this.mapRepository.getBySectionIdAndWarehouseId(sectionId, warehouseId);
        if (map == null) {
            throw new ApiException(ExceptionEnum.EX_SERVER_ERROR.toString());
        }
        List mapNodes = this.mapNodeRepository.getEmptyNode(map.getId());
        List mapNeighbors = this.mapNeighborRepository.getByMapId(map.getId());
        if (mapNodes.isEmpty() || mapNeighbors.isEmpty()) {
            throw new ApiException(ExceptionEnum.EX_SERVER_ERROR.toString());
        }
        DirectedWeightedPseudograph graph = new DirectedWeightedPseudograph(DefaultWeightedEdge.class);
        for (MapNode mapNode : mapNodes) {
            graph.addVertex((Object)mapNode);
        }
        for (MapNeighbor mapNeighbor : mapNeighbors) {
            Integer newCost = mapNeighbor.getNewCost();
            int cost = mapNeighbor.getCost();
            if (newCost != null && newCost >= 0 && cost != -1) {
                Graphs.addEdge((Graph)graph, (Object)mapNeighbor.getInNode(), (Object)mapNeighbor.getOutNode(), (double)newCost.intValue());
                continue;
            }
            cost = mapNeighbor.getCost();
            if (cost < 0) continue;
            Graphs.addEdge((Graph)graph, (Object)mapNeighbor.getInNode(), (Object)mapNeighbor.getOutNode(), (double)cost);
        }
        AStarShortestPath starShortestPath = new AStarShortestPath((Graph)graph, (AStarAdmissibleHeuristic)new AdmissibleHeuristic());
        MapNode sourceNode = this.mapNodeRepository.getByMapIdAndAddressCodeId(map.getId(), sourceVertex);
        GraphPath pathGraph = starShortestPath.getPath((Object)sourceNode, (Object)(targetNode = this.mapNodeRepository.getByMapIdAndAddressCodeId(map.getId(), targetVertex)));
        if (pathGraph == null) {
            throw new ApiException(ExceptionEnum.EX_SERVER_ERROR.toString());
        }
        return pathGraph.getVertexList().stream().map(MapNode::getAddressCodeId).collect(Collectors.toList());
    }

    public List<Integer> getHeavyDrivePath2(String warehouseId, String sectionId, int sourceVertex, int targetVertex) {
        MapNode targetNode;
        Map map = this.mapRepository.getBySectionIdAndWarehouseId(sectionId, warehouseId);
        if (map == null) {
            throw new ApiException(ExceptionEnum.EX_SERVER_ERROR.toString());
        }
        List mapNodes = this.mapNodeRepository.getHeavyNode(map.getId());
        List mapNeighbors = this.mapNeighborRepository.getByMapId(map.getId());
        if (mapNodes.isEmpty() || mapNeighbors.isEmpty()) {
            throw new ApiException(ExceptionEnum.EX_SERVER_ERROR.toString());
        }
        DirectedWeightedPseudograph graph = new DirectedWeightedPseudograph(DefaultWeightedEdge.class);
        for (MapNode mapNode : mapNodes) {
            graph.addVertex((Object)mapNode);
        }
        for (MapNeighbor mapNeighbor : mapNeighbors) {
            int cost = mapNeighbor.getCarryingCost();
            Integer newCost = mapNeighbor.getNewCost();
            if (newCost != null && newCost >= 0 && cost != -1) {
                Graphs.addEdge((Graph)graph, (Object)mapNeighbor.getInNode(), (Object)mapNeighbor.getOutNode(), (double)newCost.intValue());
                continue;
            }
            cost = mapNeighbor.getCarryingCost();
            if (cost < 0) continue;
            Graphs.addEdge((Graph)graph, (Object)mapNeighbor.getInNode(), (Object)mapNeighbor.getOutNode(), (double)cost);
        }
        AStarShortestPath starShortestPath = new AStarShortestPath((Graph)graph, (AStarAdmissibleHeuristic)new AdmissibleHeuristic());
        MapNode sourceNode = this.mapNodeRepository.getByMapIdAndAddressCodeId(map.getId(), sourceVertex);
        GraphPath pathGraph = starShortestPath.getPath((Object)sourceNode, (Object)(targetNode = this.mapNodeRepository.getByMapIdAndAddressCodeId(map.getId(), targetVertex)));
        if (pathGraph == null) {
            throw new ApiException(ExceptionEnum.EX_SERVER_ERROR.toString());
        }
        return pathGraph.getVertexList().stream().map(MapNode::getAddressCodeId).collect(Collectors.toList());
    }
}

