/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.common.utils;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.hibernate.SQLQuery;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class EntityManagerUtil {
    @PersistenceContext
    private EntityManager entityManager;

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public List executeQuery(String sql, Map<String, Object> params, Class type) {
        TypedQuery query = this.entityManager.createQuery(sql, type);
        this.setParams((Query)query, params);
        List temp = query.getResultList();
        return temp;
    }

    public int executeUpdate(String sql, Map<String, Object> params) {
        Query query = this.entityManager.createQuery(sql);
        this.setParams(query, params);
        int result = query.executeUpdate();
        return result;
    }

    public void executeUpdate(Object bean) {
        this.entityManager.merge(bean);
    }

    public <T> T executeMerge(T bean) {
        Object result = this.entityManager.merge(bean);
        return (T)result;
    }

    public List executeNativeQuery(String sql, Map<String, Object> params) {
        Query query = this.entityManager.createNativeQuery(sql);
        this.setParams(query, params);
        ((SQLQuery)query.unwrap(SQLQuery.class)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        List temp = query.getResultList();
        return temp;
    }

    public void persist(Object param) {
        this.entityManager.persist(param);
    }

    public <T> T merge(T param) {
        return (T)this.entityManager.merge(param);
    }

    public List executeCondotionNativeQuery(String sql, Map<String, Object> params, Class type) {
        Query query = this.entityManager.createNativeQuery(sql);
        this.setParams(query, params);
        ((SQLQuery)query.unwrap(SQLQuery.class)).setResultTransformer(Transformers.aliasToBean((Class)type));
        List temp = query.getResultList();
        return temp;
    }

    public List<Map> executeNativeQuery2(String sql, Map<String, Object> params) {
        Query query = this.entityManager.createNativeQuery(sql);
        this.setParams(query, params);
        ((SQLQuery)query.unwrap(SQLQuery.class)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        List temp = query.getResultList();
        return temp;
    }

    public int executeCondotionNativeUpdate(String sql, Map<String, Object> params) {
        int result = -1;
        Query query = this.entityManager.createNativeQuery(sql);
        this.setParams(query, params);
        result = query.executeUpdate();
        return result;
    }

    private void setParams(Query query, Map<String, Object> params) {
        if (!CollectionUtils.isEmpty(params)) {
            Set<Map.Entry<String, Object>> paramsTemp = params.entrySet();
            for (Map.Entry<String, Object> temp : paramsTemp) {
                if (ObjectUtils.isEmpty((Object)temp.getValue())) continue;
                query.setParameter(temp.getKey(), temp.getValue());
            }
        }
    }
}

