/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.common.utils;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateTimeUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateTimeUtil.class);
    private static String defaultFormat = "yyyy-MM-dd HH:mm:ss";
    private static String defaultFormat2 = "yyyy/MM/dd HH:mm:ss";

    public static String getTimeString(LocalDateTime time1, LocalDateTime time2) {
        Duration duration = Duration.between(time1, time2);
        long longSeconds = Math.abs(duration.getSeconds());
        int hours = (int)longSeconds / 3600;
        int remainder = (int)longSeconds - hours * 3600;
        int minutes = remainder / 60;
        int seconds = remainder - minutes * 60;
        return String.format("%02d", hours) + ":" + String.format("%02d", minutes) + ":" + String.format("%02d", seconds);
    }

    public static ZonedDateTime getNowDateTime() {
        return ZonedDateTime.now();
    }

    public static LocalDate getNowDate() {
        return LocalDate.now();
    }

    public static String getNowFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(DateTimeUtil.getNowDateTime());
    }

    public static String getNowFormat(String format) {
        return new SimpleDateFormat(format).format(new Date());
    }

    public static String getDateFormat(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static Date strToDateLong(String strDate) {
        SimpleDateFormat formatter = new SimpleDateFormat(defaultFormat);
        Date strtodate = null;
        try {
            strtodate = formatter.parse(strDate);
        }
        catch (ParseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            formatter = new SimpleDateFormat(defaultFormat2);
            try {
                strtodate = formatter.parse(strDate);
            }
            catch (ParseException e1) {
                LOGGER.error(e1.getMessage(), (Throwable)e);
            }
        }
        return strtodate;
    }

    public static Date strToDateLong(String strDate, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        Date strtodate = null;
        try {
            strtodate = formatter.parse(strDate);
        }
        catch (ParseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return strtodate;
    }

    public static Timestamp strToTimeStamp(String strDate) {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        try {
            ts = Timestamp.valueOf(strDate);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return ts;
    }

    public static LocalDateTime getLocalDatetime(String date) {
        date = date.replaceAll("[a-zA-Z]", " ");
        Date d = null;
        LocalDateTime localDateTime = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!date.isEmpty()) {
            try {
                d = simpleDateFormat.parse(date.trim().toString());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            Instant instant = d.toInstant();
            localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        return localDateTime;
    }
}

