/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.bigData.service.impl;

import com.mushiny.wms.application.domain.Map;
import com.mushiny.wms.application.domain.WmsWarehousePosition;
import com.mushiny.wms.application.repository.WmsWarehousePositionRepository;
import com.mushiny.wms.application.service.BatchService;
import com.mushiny.wms.bigData.service.WareHousePositionService;
import com.mushiny.wms.common.utils.EntityManagerUtil;
import com.mushiny.wms.pathPlanning.business.PathCommonBusiness;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
@Transactional
public class WareHousePositionServiceImpl
implements WareHousePositionService {
    private final EntityManagerUtil entityManagerUtil;
    @Autowired
    private PathCommonBusiness pathCommonBusiness;
    @Autowired
    private BatchService batchService;
    @Autowired
    private WmsWarehousePositionRepository wmsWarehousePositionRepository;

    @Autowired
    public WareHousePositionServiceImpl(EntityManagerUtil entityManagerUtil) {
        this.entityManagerUtil = entityManagerUtil;
    }

    private void initMap() {
        List mapsTemp = this.pathCommonBusiness.getMapRepository().getAllActiveMap();
        if (!CollectionUtils.isEmpty((Collection)mapsTemp)) {
            for (Map temp : mapsTemp) {
                this.doExecute(temp);
            }
        }
    }

    private void doExecute(Map mapId) {
        String sql = "SELECT  CONCAT(WD_NODE.ADDRESSCODEID,'')  as addresscodeid , CONCAT(MD_POD.POD_INDEX,'') as podIndex,MD_POD.STATE as podStatu, WCS_ROBOT.ROBOT_ID as robotId, WMS_INBOUND_INSTRUCT.MO_NAME as orderCode,WMS_INBOUND_INSTRUCT.MITEM_CODE as mitemCode, CONCAT(WMS_INBOUND_INSTRUCT.STOCK_QTY,'') as amount FROM WD_NODE\nINNER JOIN WD_MAP ON WD_MAP.ID=WD_NODE.MAP_ID AND  WD_MAP.ACTIVE=1 AND WD_NODE.WAREHOUSE_ID=WD_MAP.WAREHOUSE_ID\nLEFT JOIN MD_POD ON WD_NODE.ADDRESSCODEID=MD_POD.PLACEMARK  \n LEFT JOIN WMS_INV_UNITLOAD ON WMS_INV_UNITLOAD.POD_INDEX=MD_POD.POD_INDEX and WMS_INV_UNITLOAD.ENTITY_LOCK=0  \nLEFT JOIN WMS_INBOUND_INSTRUCT ON WMS_INV_UNITLOAD.INBOUND_INSTRUCT_ID=WMS_INBOUND_INSTRUCT.ID\nLEFT JOIN WCS_ROBOT ON WD_NODE.ADDRESSCODEID=WCS_ROBOT.ADDRESSCODEID\nWHERE WD_MAP.SECTION_ID=:sectionId AND WD_MAP.WAREHOUSE_ID=:wareHouseId ";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("sectionId", mapId.getSectionId());
        param.put("wareHouseId", mapId.getWarehouseId());
        List positions = this.entityManagerUtil.executeCondotionNativeQuery(sql, param, WmsWarehousePosition.class);
        List dataBase = this.wmsWarehousePositionRepository.findAll();
        ArrayList<WmsWarehousePosition> update = new ArrayList<WmsWarehousePosition>();
        ArrayList<WmsWarehousePosition> save = new ArrayList<WmsWarehousePosition>();
        for (WmsWarehousePosition wwp : positions) {
            if (ObjectUtils.isEmpty((Object)wwp.getPodIndex())) {
                wwp.setNodeState("Empty");
            } else if ("Reserved".equalsIgnoreCase(wwp.getPodStatu())) {
                wwp.setNodeState("Reserved");
            } else if ("Available".equalsIgnoreCase(wwp.getPodStatu())) {
                wwp.setNodeState("Available");
            } else if (!ObjectUtils.isEmpty((Object)wwp.getRobotId())) {
                wwp.setNodeState("Occupied");
            }
            boolean find = false;
            WmsWarehousePosition findPo = null;
            for (WmsWarehousePosition db : dataBase) {
                if (!db.getAddresscodeid().equals(wwp.getAddresscodeid())) continue;
                find = true;
                findPo = db;
                break;
            }
            if (find) {
                if (ObjectUtils.nullSafeEquals(findPo, (Object)wwp)) continue;
                BeanUtils.copyProperties((Object)wwp, (Object)findPo, (String[])new String[]{"id", "createdDate", "createdBy", "modifiedDate", "modifiedBy", "additionalContent", "entityLock", "version"});
                update.add(findPo);
                continue;
            }
            if (ObjectUtils.isEmpty((Object)wwp)) continue;
            save.add(wwp);
        }
        this.batchService.batchInsert(save);
        this.batchService.batchUpdate(update);
    }

    public void execute() {
        this.initMap();
    }
}

