/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.web;

import com.mushiny.wms.application.domain.MushinyMessage;
import com.mushiny.wms.application.domain.OutboundInstruct;
import com.mushiny.wms.application.domain.WmsInstructOutPosition;
import com.mushiny.wms.application.service.OutboundInstructService;
import java.net.URLDecoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class OutboundInstructController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutboundInstructController.class);
    private final OutboundInstructService outboundInstructService;

    @Autowired
    public OutboundInstructController(OutboundInstructService outboundInstructService) {
        this.outboundInstructService = outboundInstructService;
    }

    @PostMapping(value={"/outboundInstruct"}, produces={"application/json"})
    public ResponseEntity<MushinyMessage> save(@RequestBody String inboundInstruct) {
        Integer result = 1;
        try {
            this.outboundInstructService.saveOnboundInstruct(inboundInstruct);
        }
        catch (Exception e) {
            result = 0;
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        String message = "fail";
        MushinyMessage mm = new MushinyMessage();
        if (result == 1) {
            message = "success";
        }
        mm.setCode((Object)result.toString());
        mm.setMessage(message);
        return ResponseEntity.ok((Object)mm);
    }

    @PostMapping(value={"/outboundInstructJob"}, produces={"application/json"})
    public ResponseEntity<MushinyMessage> saveJob(@RequestBody String inboundInstruct) {
        return this.save(URLDecoder.decode(inboundInstruct));
    }

    @RequestMapping(value={"instructOut"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<Page<OutboundInstruct>> getInboundInstruct(@RequestParam String startTime, @RequestParam String endTime, @RequestParam String labelNo, Pageable pageable) {
        return ResponseEntity.ok((Object)this.outboundInstructService.getByOutboundLabelNo(startTime, endTime, labelNo, pageable));
    }

    @RequestMapping(value={"instructOut/position"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<List<WmsInstructOutPosition>> getInboundInstructPosition(@RequestParam String labelNo) {
        return ResponseEntity.ok((Object)this.outboundInstructService.getOutboundByLabelNo(labelNo));
    }
}

