/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.web;

import com.mushiny.wms.application.business.common.InvMitemLabelBusiness;
import com.mushiny.wms.application.business.common.SfcMitemBusiness;
import com.mushiny.wms.application.domain.MushinyMessage;
import com.mushiny.wms.application.rabbitMq.RabbitMqReceiver;
import com.mushiny.wms.application.service.InstructService;
import com.mushiny.wms.common.utils.JSONUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class InstructController {
    private final InstructService instructService;
    private final InvMitemLabelBusiness invMitemLabelBusiness;
    private final SfcMitemBusiness sfcMitemBusiness;
    private final RabbitMqReceiver rabbitMqReceiver;

    @Autowired
    public InstructController(InstructService instructService, InvMitemLabelBusiness invMitemLabelBusiness, SfcMitemBusiness sfcMitemBusiness, RabbitMqReceiver rabbitMqReceiver) {
        this.instructService = instructService;
        this.invMitemLabelBusiness = invMitemLabelBusiness;
        this.sfcMitemBusiness = sfcMitemBusiness;
        this.rabbitMqReceiver = rabbitMqReceiver;
    }

    @PostMapping(value={"/instruct/cancel"}, produces={"application/json"})
    public ResponseEntity<MushinyMessage> cancel(@RequestBody String inboundInstruct) {
        boolean result = this.instructService.cancelInstruct(inboundInstruct);
        String message = "fail";
        MushinyMessage mm = new MushinyMessage();
        int code = 0;
        if (result) {
            message = "success";
            code = 1;
        } else {
            mm.setDescribe("\u6307\u4ee4\u5df2\u7ecf\u6267\u884c,\u65e0\u6cd5\u53d6\u6d88");
        }
        mm.setCode((Object)code);
        mm.setMessage(message);
        return ResponseEntity.ok((Object)mm);
    }

    @PostMapping(value={"/instruct/getInstruct"}, produces={"application/json"})
    public ResponseEntity<Object> getInstruct(@RequestBody String instruct) {
        String message = "fail";
        MushinyMessage mm = new MushinyMessage();
        Object result = this.instructService.getInstruct(instruct);
        int code = 0;
        if (!ObjectUtils.isEmpty((Object)result)) {
            message = "success";
            code = 1;
        }
        mm.setCode((Object)code);
        mm.setMessage(message);
        mm.setData(result);
        return ResponseEntity.ok((Object)result);
    }

    @PostMapping(value={"/sfcMitemSyn"}, produces={"application/json"})
    public ResponseEntity<Object> sfcMitemSyn(@RequestBody String instruct) {
        List result = this.sfcMitemBusiness.receive(instruct);
        return ResponseEntity.ok((Object)result);
    }

    @PostMapping(value={"/invMitemLabelSyn"}, produces={"application/json"})
    public ResponseEntity<Object> invMitemLabelSyn(@RequestBody String instruct) {
        List result = this.invMitemLabelBusiness.receive(instruct);
        return ResponseEntity.ok((Object)result);
    }

    @PostMapping(value={"/instruct/updateInstruct"}, produces={"application/json"})
    public ResponseEntity<Object> updateInstruct(@RequestBody String instruct) {
        String message = "fail";
        MushinyMessage mm = new MushinyMessage();
        Integer result = this.instructService.updateInstruct(instruct);
        if (result == 1) {
            message = "success";
        }
        mm.setCode((Object)result);
        mm.setMessage(message);
        return ResponseEntity.ok((Object)mm);
    }

    @PostMapping(value={"/iinstructiCallBack"}, produces={"application/json"})
    public ResponseEntity<Object> instructiCallBack(@RequestBody String instruct) {
        String message = "success";
        MushinyMessage mm = new MushinyMessage();
        this.rabbitMqReceiver.test(JSONUtil.jsonToMap((String)instruct));
        mm.setCode((Object)1);
        mm.setMessage(message);
        return ResponseEntity.ok((Object)mm);
    }
}

