/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.web;

import com.mushiny.wms.application.domain.InboundInstruct;
import com.mushiny.wms.application.domain.MushinyMessage;
import com.mushiny.wms.application.domain.WmsInstructInPosition;
import com.mushiny.wms.application.service.InboundInstructService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class InboundInstructController {
    private static final Logger LOGGER = LoggerFactory.getLogger(InboundInstructController.class);
    private final InboundInstructService inboundInstructService;

    @Autowired
    public InboundInstructController(InboundInstructService inboundInstructService) {
        this.inboundInstructService = inboundInstructService;
    }

    @PostMapping(value={"/inboundInstruct"}, produces={"application/json"})
    public ResponseEntity<MushinyMessage> save(@RequestBody String inboundInstruct) {
        Integer result = 1;
        try {
            this.inboundInstructService.saveInboundInstruct(inboundInstruct);
        }
        catch (Exception e) {
            result = 0;
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        String message = "fail";
        MushinyMessage mm = new MushinyMessage();
        if (result == 1) {
            message = "success";
        }
        mm.setCode((Object)result.toString());
        mm.setMessage(message);
        return ResponseEntity.ok((Object)mm);
    }

    @RequestMapping(value={"instructIn"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<Page<InboundInstruct>> getInboundInstruct(@RequestParam String startTime, @RequestParam String endTime, @RequestParam String labelNo, Pageable pageable) {
        return ResponseEntity.ok((Object)this.inboundInstructService.getByInboundLabelNo(startTime, endTime, labelNo, pageable));
    }

    @RequestMapping(value={"instructIn/position"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<List<WmsInstructInPosition>> getInboundInstructPosition(@RequestParam String labelNo) {
        return ResponseEntity.ok((Object)this.inboundInstructService.getInboundByLabelNo(labelNo));
    }
}

