/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.service.impl;

import com.mushiny.wms.application.business.common.RfidBusiness;
import com.mushiny.wms.application.service.RfidService;
import com.mushiny.wms.common.Constant;
import com.mushiny.wms.common.utils.JSONUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.NumberUtils;

@Service
@Transactional
public class RfidServiceImpl
implements RfidService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RfidServiceImpl.class);
    private final RfidBusiness rfidBusiness;

    @Autowired
    public RfidServiceImpl(RfidBusiness rfidBusiness) {
        this.rfidBusiness = rfidBusiness;
    }

    public Integer saveRfidInfo(String pods) {
        Integer result = 0;
        Map pod = JSONUtil.jsonToMap((String)pods);
        if (!CollectionUtils.isEmpty((Map)pod)) {
            result = this.rfidBusiness.saveRfidInfo(pod);
        }
        return result;
    }

    public Integer saveRfidInfoByStationName(String stationNameJson) {
        Map stationName = JSONUtil.jsonToMap((String)stationNameJson);
        if (!CollectionUtils.isEmpty((Map)stationName)) {
            this.rfidBusiness.workStationCall((String)stationName.get("stationName"), (Integer)NumberUtils.parseNumber((String)((String)stationName.get("isCall")), Integer.class));
        }
        return Constant.SUCCESS_FLAG;
    }
}

