/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.service.impl;

import com.mushiny.wms.application.business.common.BuildEntityBusiness;
import com.mushiny.wms.application.business.common.PodReserveUtil;
import com.mushiny.wms.application.domain.Constance;
import com.mushiny.wms.application.domain.Pod;
import com.mushiny.wms.application.domain.Section;
import com.mushiny.wms.application.domain.WmsInvUnitload;
import com.mushiny.wms.application.domain.enums.StationType;
import com.mushiny.wms.application.domain.enums.TripType;
import com.mushiny.wms.application.repository.PodRepository;
import com.mushiny.wms.application.repository.SectionRepository;
import com.mushiny.wms.application.repository.WmsInvUnitLoadRepository;
import com.mushiny.wms.application.service.impl.PutBackService;
import com.mushiny.wms.common.utils.JSONUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PutBackServiceImpl
implements PutBackService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PutBackServiceImpl.class);
    private final PodRepository podRepository;
    private final SectionRepository sectionRepository;
    private final PodReserveUtil podReserveUtil;
    private final BuildEntityBusiness buildEntityBusiness;
    private final WmsInvUnitLoadRepository wmsInvUnitLoadRepository;

    @Autowired
    public PutBackServiceImpl(PodRepository podRepository, SectionRepository sectionRepository, PodReserveUtil podReserveUtil, BuildEntityBusiness buildEntityBusiness, WmsInvUnitLoadRepository wmsInvUnitLoadRepository) {
        this.podRepository = podRepository;
        this.sectionRepository = sectionRepository;
        this.podReserveUtil = podReserveUtil;
        this.buildEntityBusiness = buildEntityBusiness;
        this.wmsInvUnitLoadRepository = wmsInvUnitLoadRepository;
    }

    public void execute() {
        List sections = this.sectionRepository.getAll();
        for (Section section : sections) {
            this.doExecute(section, StationType.PODCARRY, false);
        }
    }

    public void test() {
        List sections = this.sectionRepository.getAll();
        for (Section section : sections) {
            this.doExecute(section, StationType.INBOUND, false);
        }
    }

    public void testAll() {
        List sections = this.sectionRepository.getAll();
        for (Section section : sections) {
            this.doExecute(section, StationType.INBOUND, true);
        }
    }

    private synchronized void doExecute(Section section, Integer stationType, boolean buildUn) {
        List pods = this.podRepository.getPutBackPod(section.getId(), stationType);
        LOGGER.info("sction {} pod \u653e\u56de\u533a\u7c7b\u578b{} \u67e5\u5230\u8d27\u67b6\n{}", new Object[]{section.getName(), stationType, JSONUtil.toJSon((Object)pods)});
        for (Pod pod : pods) {
            this.podReserveUtil.reservePod(pod);
            this.buildEntityBusiness.buildTrip(pod, null, null, TripType.POD_RUN);
            if (!buildUn) continue;
            WmsInvUnitload invLoad = new WmsInvUnitload();
            invLoad.setPodIndex(pod.getPodIndex());
            invLoad.setInboundInstructId("");
            invLoad.setStationName("system");
            invLoad.setEntityLock(Constance.avable);
            invLoad.setWarehouseId(pod.getWarehouseId());
            invLoad = (WmsInvUnitload)this.wmsInvUnitLoadRepository.saveAndFlush((Object)invLoad);
        }
    }
}

