/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.service.impl;

import com.mushiny.wms.application.business.common.BuildEntityBusiness;
import com.mushiny.wms.application.business.common.CommonBusiness;
import com.mushiny.wms.application.business.common.PodReserveUtil;
import com.mushiny.wms.application.business.common.SystemPropertyBusiness;
import com.mushiny.wms.application.business.score.StationPodScore;
import com.mushiny.wms.application.config.RestTempConfig;
import com.mushiny.wms.application.domain.MapNode;
import com.mushiny.wms.application.domain.MdStationnodeposition;
import com.mushiny.wms.application.domain.OutboundInstruct;
import com.mushiny.wms.application.domain.Pod;
import com.mushiny.wms.application.domain.Stationnode;
import com.mushiny.wms.application.domain.Trip;
import com.mushiny.wms.application.domain.WmsInstructOutPosition;
import com.mushiny.wms.application.domain.WmsSlamTrip;
import com.mushiny.wms.application.domain.enums.InstructStatus;
import com.mushiny.wms.application.domain.enums.TripState;
import com.mushiny.wms.application.domain.enums.TripType;
import com.mushiny.wms.application.rabbitMq.RabbitMqReceiver;
import com.mushiny.wms.application.redis.RedisUtil;
import com.mushiny.wms.application.repository.MdStationnodepositionRepository;
import com.mushiny.wms.application.repository.OutboundInstructRepository;
import com.mushiny.wms.application.repository.PodRepository;
import com.mushiny.wms.application.repository.SectionRepository;
import com.mushiny.wms.application.repository.StationnodeRepository;
import com.mushiny.wms.application.repository.TripRepository;
import com.mushiny.wms.application.repository.WmsInstructOutPositionRepository;
import com.mushiny.wms.application.repository.WmsSlamTripRepository;
import com.mushiny.wms.application.repository.WorkStationRepository;
import com.mushiny.wms.application.service.OutboundTripService;
import com.mushiny.wms.application.test.AckSimulate;
import com.mushiny.wms.common.utils.DateTimeUtil;
import com.mushiny.wms.common.utils.EntityManagerUtil;
import com.mushiny.wms.common.utils.JSONUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class OutboundTripServiceImpl
implements OutboundTripService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutboundTripServiceImpl.class);
    @Value(value="${mushiny.test}")
    private boolean test;
    @Autowired
    private AckSimulate ackSimulate;
    @Autowired
    private RabbitMqReceiver rabbitMqReceiver;
    private final SectionRepository sectionRepository;
    private final WorkStationRepository workStationRepository;
    private final OutboundInstructRepository outboundInstructRepository;
    private final SystemPropertyBusiness systemPropertyBusiness;
    private final TripRepository tripRepository;
    private final PodRepository podRepository;
    private final BuildEntityBusiness buildEntityBusiness;
    private PodReserveUtil podReserveUtil;
    private final EntityManagerUtil entityManagerUtil;
    private final MdStationnodepositionRepository mdStationnodepositionRepository;
    private Map value = null;
    private StationnodeRepository stationnodeRepository;
    @Autowired
    private RestTempConfig restTempConfig;
    @Autowired
    private CommonBusiness commonBusiness;
    @Autowired
    private WmsInstructOutPositionRepository wmsInstructOutPositionRepository;
    private final Object lock = new Object();
    private final RedisUtil redisUtil;
    private transient Map hasGenTrip = new HashMap();
    private transient Map cancelInstrue = new ConcurrentHashMap();
    private final WmsSlamTripRepository wmsSlamTripRepository;
    public static final String SQL_ALLSLAMNODE = "SELECT WMS_SLAM_NODE.SLAM_NODENAME FROM WMS_SLAM_NODE,MD_STATIONNODE WHERE MD_STATIONNODE.ID=WMS_SLAM_NODE.STATIONID AND MD_STATIONNODE.TYPE=4";

    @Autowired
    public OutboundTripServiceImpl(SectionRepository sectionRepository, WorkStationRepository workStationRepository, OutboundInstructRepository outboundInstructRepository, SystemPropertyBusiness systemPropertyBusiness, TripRepository tripRepository, PodRepository podRepository, EntityManagerUtil entityManagerUtil, PodReserveUtil podReserveUtil, BuildEntityBusiness buildEntityBusiness, MdStationnodepositionRepository mdStationnodepositionRepository, RedisUtil redisUtil, StationnodeRepository stationnodeRepository, WmsSlamTripRepository wmsSlamTripRepository) {
        this.sectionRepository = sectionRepository;
        this.workStationRepository = workStationRepository;
        this.outboundInstructRepository = outboundInstructRepository;
        this.systemPropertyBusiness = systemPropertyBusiness;
        this.tripRepository = tripRepository;
        this.podRepository = podRepository;
        this.podReserveUtil = podReserveUtil;
        this.buildEntityBusiness = buildEntityBusiness;
        this.entityManagerUtil = entityManagerUtil;
        this.mdStationnodepositionRepository = mdStationnodepositionRepository;
        this.redisUtil = redisUtil;
        this.stationnodeRepository = stationnodeRepository;
        this.wmsSlamTripRepository = wmsSlamTripRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    private void execute(OutboundInstruct outboundInstruct) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5f00\u59cb\u5904\u7406\u51fa\u5e93\u6307\u4ee4{}", (Object)JSONUtil.toJSon((Object)outboundInstruct));
        }
        if (this.test) {
            Map param = this.ackSimulate.ceateParam(outboundInstruct.getId(), outboundInstruct.getBILL_TYPE(), InstructStatus.ACCEPT.getStatus(), null);
            try {
                this.rabbitMqReceiver.receiveMapMessage2(param);
                TimeUnit.SECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            param = this.ackSimulate.ceateParam(outboundInstruct.getId(), outboundInstruct.getBILL_TYPE(), InstructStatus.RUNNING.getStatus(), null);
            try {
                TimeUnit.SECONDS.sleep(10L);
                this.rabbitMqReceiver.receiveMapMessage2(param);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            param = this.ackSimulate.ceateParam(outboundInstruct.getId(), outboundInstruct.getBILL_TYPE(), InstructStatus.STOCKIN.getStatus(), null);
            try {
                TimeUnit.SECONDS.sleep(10L);
                this.rabbitMqReceiver.receiveMapMessage2(param);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return;
        }
        String lineCode = "";
        lineCode = "ANNTOMVOUT".equalsIgnoreCase(outboundInstruct.getBILL_TYPE()) ? outboundInstruct.getWORKCENTER_CODE() : outboundInstruct.getLINE_CODE();
        List stations = this.mdStationnodepositionRepository.getIdleStationPosition(Arrays.asList(TripState.FINISHED.getName()), lineCode);
        if (!CollectionUtils.isEmpty((Collection)stations)) {
            List nodes = this.mdStationnodepositionRepository.getNode(Arrays.asList(TripState.FINISHED.getName()), Arrays.asList(TripType.ANNTOMVOUT.getName(), TripType.LMGETMATERIAL.getName()));
            LOGGER.debug("\u5df2\u7ecf\u5728\u51fa\u5e93\u7684\u6240\u6709\u70b9{}", (Object)JSONUtil.toJSon((Object)nodes));
            ArrayList<MdStationnodeposition> delete = new ArrayList<MdStationnodeposition>();
            block9: for (MdStationnodeposition stationnodeposition : stations) {
                for (MapNode node : nodes) {
                    if (!stationnodeposition.getNode().getId().equals(node.getId())) continue;
                    delete.add(stationnodeposition);
                    continue block9;
                }
            }
            LOGGER.debug("\u9700\u8981\u51fa\u5e93\u88ab\u79fb\u9664\u7684\u70b9{}", (Object)JSONUtil.toJSon(delete));
            stations.removeAll(delete);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u67e5\u8be2\u5230\u4ea7\u7ebf{}\u7a7a\u95f2\u7684\u505c\u6b62\u70b9{}", (Object)lineCode, (Object)JSONUtil.toJSon((Object)stations));
        }
        if (CollectionUtils.isEmpty((Collection)stations)) {
            LOGGER.error("\u672a\u51fa\u5e93\u6307\u4ee4\u4ea7\u7ebfLINE_CODE{}\u5bf9\u5e94\u7684\u5de5\u4f5c\u7ad9 {} {}", (Object)lineCode, (Object)JSONUtil.toJSon((Object)outboundInstruct));
        } else {
            ArrayList<String> tripState = new ArrayList<String>();
            tripState.add(TripState.FINISHED.getName());
            String sql = "SELECT MD_POD.ID FROM WMS_INBOUND_INSTRUCT \nINNER JOIN WMS_OUTBOUND_INSTRUCT ON WMS_INBOUND_INSTRUCT.LABEL_NO=WMS_OUTBOUND_INSTRUCT.LABEL_NO  INNER JOIN WMS_INV_UNITLOAD ON WMS_INV_UNITLOAD.INBOUND_INSTRUCT_ID=WMS_INBOUND_INSTRUCT.ID\nINNER JOIN MD_POD ON MD_POD.POD_INDEX=WMS_INV_UNITLOAD.POD_INDEX where WMS_INBOUND_INSTRUCT.LABEL_NO=:labelNo   and WMS_INBOUND_INSTRUCT.MO_NAME=:moName  and WMS_OUTBOUND_INSTRUCT.ID not in  (SELECT DISTINCT coalesce(WMS_INSTRUCT_OUT_POSITION.INSTRUCT_ID,'') from  WMS_INSTRUCT_OUT_POSITION  )  and WMS_INV_UNITLOAD.ENTITY_LOCK=0";
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("moName", outboundInstruct.getMO_NAME());
            param.put("labelNo", outboundInstruct.getLABEL_NO());
            List pods = this.entityManagerUtil.executeNativeQuery2(sql, param);
            if (CollectionUtils.isEmpty((Collection)pods)) {
                LOGGER.error("\u51fa\u5e93\u6307\u4ee4{} \u5de5\u5355\u53f7{} \u6ca1\u6709\u5e93\u5b58\u7eaa\u5f55", (Object)outboundInstruct.getId(), (Object)outboundInstruct.getMO_NAME());
            } else if (pods.size() > 1) {
                LOGGER.error("\u51fa\u5e93\u6307\u4ee4{} \u914d\u9001\u5361\u53f7{}\u5de5\u5355\u53f7{} \u67e5\u627e\u5230\u4e86\u591a\u4e2a\u5e93\u5b58\u7eaa\u5f55\n{}", new Object[]{outboundInstruct.getId(), outboundInstruct.getLABEL_NO(), outboundInstruct.getMO_NAME(), JSONUtil.toJSon((Object)pods)});
            } else {
                LOGGER.debug("\u51fa\u5e93\u6307\u4ee4{} \u914d\u9001\u5361\u53f7{}\u6ee1\u8db3\u51fa\u5e93\u6761\u4ef6", (Object)outboundInstruct.getId(), (Object)outboundInstruct.getLABEL_NO());
                Pod savePod = (Pod)this.podRepository.findOne((Serializable)((Object)((String)((Map)pods.get(0)).get("ID"))));
                List stationScore = this.commonBusiness.getStationPodScore(stations, savePod);
                Object object = this.lock;
                synchronized (object) {
                    String datetimeStock = DateTimeUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
                    WmsInstructOutPosition iop = new WmsInstructOutPosition();
                    iop.setCAR_NO("");
                    iop.setDATETIME_STOCK((Date)DateTimeUtil.strToTimeStamp((String)datetimeStock));
                    iop.setOutboundInstruct(outboundInstruct);
                    iop.setSTOCK_QTY(outboundInstruct.getQTY().toString());
                    StationPodScore sps = (StationPodScore)stationScore.get(0);
                    Stationnode sn = sps.getStationnodeposition().getStationnode();
                    String sectionId = sn.getSectionId();
                    String wareHouseId = sn.getWarehouseId();
                    List trips = this.tripRepository.getWorkStationNotFinishTrip(tripState, sectionId, sps.getStationnodeposition().getId(), wareHouseId);
                    Pod pod = this.podRepository.getWorkStationTrip(Integer.valueOf(sps.getStationnodeposition().getNode().getAddressCodeId()), sectionId);
                    if (!CollectionUtils.isEmpty((Collection)trips) || !ObjectUtils.isEmpty((Object)pod)) {
                        LOGGER.error("Stationnode id{} \u51fa\u5e93\u5de5\u4f5c\u7ad9{} \u5730\u5740{} pod {} \u6709\u672a\u5b8c\u6210\u7684\u8c03\u5ea6\u5355 \n{},\n\u672a\u5206\u914d\u6307\u4ee4{} ", new Object[]{sn.getId(), sn.getName(), sps.getStationnodeposition().getNode().getAddressCodeId(), JSONUtil.toJSon((Object)pod), JSONUtil.toJSon((Object)trips), JSONUtil.toJSon((Object)pod)});
                    } else {
                        boolean cancel;
                        List iis = this.outboundInstructRepository.getInstru(Arrays.asList(InstructStatus.CANCEL.getStatus()), outboundInstruct.getId());
                        boolean bl = cancel = !CollectionUtils.isEmpty((Collection)iis);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("\u51fa\u5e93\u6307\u4ee4\u662f\u5426\u53d6\u6d88{} {}", (Object)cancel, (Object)JSONUtil.toJSon((Object)iis));
                        }
                        if (!cancel) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("\u5f00\u59cb\u751f\u6210\u51fa\u5e93\u6307\u4ee4id{}\u7684\u8bb0\u5f55", (Object)outboundInstruct.getId());
                            }
                            this.podReserveUtil.reservePod(savePod);
                            Trip trip = this.buildEntityBusiness.buildTrip(savePod, sps.getStationnodeposition(), (Object)outboundInstruct, TripType.parserTripType((String)outboundInstruct.getBILL_TYPE()));
                            HashMap<String, Object> param2 = new HashMap<String, Object>();
                            param2.put("ID", outboundInstruct.getMES_ID());
                            param2.put("INV_ORG_ID", outboundInstruct.getINV_ORG_ID());
                            param2.put("BILL_TYPE", outboundInstruct.getBILL_TYPE());
                            param2.put("BILL_NO", outboundInstruct.getBILL_NO());
                            param2.put("LABEL_NO", outboundInstruct.getLABEL_NO());
                            param2.put("INV_CODE", outboundInstruct.getINV_CODE());
                            param2.put("STOCK_QTY", outboundInstruct.getQTY());
                            param2.put("DATETIME_STOCK", datetimeStock);
                            param2.put("LOC_CODE", "");
                            param2.put("STORAGE_NO_L", "");
                            param2.put("CAR_NO", "");
                            param2.put("STATUS", InstructStatus.ACCEPT.getStatus());
                            Map ack = this.restTempConfig.outBoundAck(param2);
                            this.hasGenTrip.put(outboundInstruct.getId(), trip.getId());
                            iop.setSTATUS(InstructStatus.ACCEPT.getStatus());
                            iop = (WmsInstructOutPosition)this.wmsInstructOutPositionRepository.saveAndFlush((Object)iop);
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("\u63a5\u6536\u5230\u51fa\u5e93\u6307\u4ee4,\u4fee\u6539\u72b6\u6001\u4e3aACCEPT\n \u6307\u4ee4{},\n\u53d6\u6d88\u540e\u4fe1\u606f{}", (Object)outboundInstruct.getId(), (Object)JSONUtil.toJSon((Object)iop));
                            }
                        } else {
                            LOGGER.debug("\u51fa\u5e93\u6307\u4ee4\u5df2\u7ecf\u53d6\u6d88");
                        }
                    }
                }
            }
        }
    }

    public void buildTrip() {
        List stationnodes = this.stationnodeRepository.getAllOutStation();
        LOGGER.debug("\u603b\u51fa\u5e93\u5de5\u4f5c\u7ad9" + stationnodes.size() + "\u4e2a");
        for (Stationnode stationnode : stationnodes) {
            LOGGER.debug("\u5f53\u524d\u64cd\u4f5c\u7684\u51fa\u5e93\u5de5\u4f5c\u7ad9\u662f----->" + stationnode.getName());
            List iis = this.outboundInstructRepository.getAllNotCreateTripInstru(Arrays.asList(InstructStatus.ACCEPT.getStatus(), InstructStatus.RUNNING.getStatus(), InstructStatus.CANCEL.getStatus(), InstructStatus.STOCKOUT.getStatus()), stationnode.getName());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u67e5\u8be2\u5230\u9700\u8981\u8c03\u5ea6\u7684\u51fa\u5e93\u6307\u4ee4\n{}", (Object)JSONUtil.toJSon((Object)iis));
            }
            this.value = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)iis)) {
                int len = iis.size();
                List executeInstruct = null;
                executeInstruct = len > 4 ? iis.subList(0, 3) : iis.subList(0, len);
                for (OutboundInstruct ii : executeInstruct) {
                    try {
                        this.execute(ii);
                    }
                    catch (Exception e) {
                        LOGGER.error("\u5904\u7406\u51fa\u5e93\u6307\u4ee4\u51fa\u9519{}", (Object)JSONUtil.toJSon((Object)ii));
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
                continue;
            }
            LOGGER.debug("\u6ca1\u6709\u9700\u8981\u8c03\u5ea6\u7684\u51fa\u5e93\u6307\u4ee4");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelInstruct(OutboundInstruct instruct, String status) {
        Boolean result = false;
        Object object = this.lock;
        synchronized (object) {
            String datetimeStock = DateTimeUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
            WmsInstructOutPosition iop = new WmsInstructOutPosition();
            iop.setCAR_NO("");
            iop.setDATETIME_STOCK((Date)DateTimeUtil.strToTimeStamp((String)datetimeStock));
            iop.setOutboundInstruct(instruct);
            iop.setSTATUS(InstructStatus.CANCEL.getStatus());
            List iis = this.outboundInstructRepository.getInstru(Arrays.asList(InstructStatus.ACCEPT.getStatus(), InstructStatus.STOCKIN.getStatus(), InstructStatus.RUNNING.getStatus()), instruct.getId());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u5165\u5e93\u6307\u4ee4id{} \u5df2\u7ecf\u751f\u6210{}", (Object)instruct.getId(), (Object)JSONUtil.toJSon((Object)iis));
            }
            if (CollectionUtils.isEmpty((Collection)iis)) {
                iop = (WmsInstructOutPosition)this.wmsInstructOutPositionRepository.saveAndFlush((Object)iop);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("\u751f\u6210\u51fa\u5e93\u6307\u4ee4id{} \u53d6\u6d88\u660e\u7ec6{}", (Object)instruct.getId(), (Object)JSONUtil.toJSon((Object)iop));
                }
                result = true;
            }
        }
        return result;
    }

    public void buildSlamOutTrip() {
        List stationnodes = this.stationnodeRepository.getAllSlamOutStation();
        List allNodes = this.entityManagerUtil.executeNativeQuery2(SQL_ALLSLAMNODE, new HashMap());
        LOGGER.debug("Slam\u603b\u51fa\u5e93\u5de5\u4f5c\u7ad9" + allNodes.size() + "\u4e2a");
        for (Map node : allNodes) {
            LOGGER.debug("\u5f53\u524d\u64cd\u4f5c\u7684SLAM\u51fa\u5e93\u64cd\u4f5c\u4f4d\u662f----->" + node.get("SLAM_NODENAME"));
            String nodeName = (String)node.get("SLAM_NODENAME");
            List sobNoTrip = this.outboundInstructRepository.getAllNotCreateTripSlamInstruct(Arrays.asList(InstructStatus.ACCEPT.getStatus(), InstructStatus.RUNNING.getStatus(), InstructStatus.CANCEL.getStatus(), InstructStatus.STOCKOUT.getStatus()), nodeName);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u67e5\u8be2\u5230\u9700\u8981\u8c03\u5ea6\u7684\u51fa\u5e93\u6307\u4ee4\n{}", (Object)JSONUtil.toJSon((Object)sobNoTrip));
            }
            this.value = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)sobNoTrip)) {
                int len = sobNoTrip.size();
                List executeInstruct = null;
                executeInstruct = len > 4 ? sobNoTrip.subList(0, 3) : sobNoTrip.subList(0, len);
                for (OutboundInstruct ii : executeInstruct) {
                    try {
                        this.executeSlam(ii);
                    }
                    catch (Exception e) {
                        LOGGER.error("\u5904\u7406\u51fa\u5e93\u6307\u4ee4\u51fa\u9519{}", (Object)JSONUtil.toJSon((Object)ii));
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
                continue;
            }
            LOGGER.debug("\u6ca1\u6709\u9700\u8981\u8c03\u5ea6\u7684\u51fa\u5e93\u6307\u4ee4");
        }
    }

    private boolean checkPodOnSlamNode(String nodeName) {
        LOGGER.error("\u68c0\u67e5\u662f\u5426\u6709POD\u5728\u76ee\u6807\u4f4d:" + nodeName);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("tagName", nodeName);
        List nodes = this.entityManagerUtil.executeNativeQuery("SELECT SLAM_NODE FROM WMS_SLAM_NODE WHERE SLAM_NODENAME=:tagName", data);
        if (nodes == null || nodes.isEmpty()) {
            LOGGER.error("tagName:" + nodeName + "\u672a\u5b9a\u4e49\u4e0d\u5b58\u5728:WMS_SLAM_NODE");
            return false;
        }
        Map map = (Map)nodes.get(0);
        String slamNode = (String)map.get("SLAM_NODE");
        WmsSlamTrip wmsSlamTrip = this.wmsSlamTripRepository.findTripBySlamNodeAndState(slamNode);
        if (wmsSlamTrip == null) {
            LOGGER.error("tagName:" + nodeName + "\u6ca1\u6709\u6b63\u5728\u64cd\u4f5c\u7684\u8d27\u67b6");
            return true;
        }
        List nodePodIns = this.entityManagerUtil.executeNativeQuery("SELECT WMS_SLAM_NODE.NODEID,WMS_SLAM_NODE.SLAM_NODE FROM MD_STATIONNODEPOSITION, MD_STATIONNODE ,WD_NODE,WMS_SLAM_NODE\nWHERE MD_STATIONNODE.ID=MD_STATIONNODEPOSITION.STATIONNODE_ID AND MD_STATIONNODE.TYPE=6 AND WMS_SLAM_NODE.NODEID=MD_STATIONNODEPOSITION.NODE_ID\nAND WD_NODE.ID=MD_STATIONNODEPOSITION.NODE_ID AND WD_NODE.ADDRESSCODEID \nNOT IN(SELECT PLACEMARK FROM MD_POD WHERE MD_POD.SECTION_ID='ec229eb7-7e2b-43a8-b1c7-91bd807e91cf')", new HashMap());
        if (nodePodIns == null || nodePodIns.isEmpty()) {
            LOGGER.error("\u6ca1\u6709\u627e\u5230SLAM\u56de\u5e93\u914d\u7f6e\u7684\u63a5\u9a73\u4f4d!");
            return false;
        }
        WmsSlamTrip wmsSlamTripBack = new WmsSlamTrip();
        wmsSlamTrip.setTripState(WmsSlamTrip.FINISHTASK);
        WmsSlamTrip slamTripBack = new WmsSlamTrip();
        slamTripBack.setStorageNo(wmsSlamTrip.getStorageNo());
        slamTripBack.setStartTag(wmsSlamTrip.getEndTag());
        slamTripBack.setEndTag((String)((Map)nodePodIns.get(0)).get("SLAM_NODE"));
        slamTripBack.setStorageNo(wmsSlamTrip.getStorageNo());
        slamTripBack.setTripState(WmsSlamTrip.AVAILABLE);
        slamTripBack.setPriority(Integer.valueOf(99));
        slamTripBack.setInstructId(wmsSlamTrip.getInstructId());
        slamTripBack.setInvOrgId(wmsSlamTrip.getInvOrgId());
        slamTripBack.setBillType(wmsSlamTrip.getBillType());
        slamTripBack.setTaskType(WmsSlamTrip.TASKTYPE_BACK);
        this.wmsSlamTripRepository.saveAndFlush((Object)wmsSlamTrip);
        this.wmsSlamTripRepository.saveAndFlush((Object)wmsSlamTripBack);
        LOGGER.error("\u4e3a\u76ee\u6807SLAM\u5de5\u4f5c\u7ad9\u751f\u6210\u56de\u5e93\u4efb\u52a1:" + wmsSlamTripBack);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void executeSlam(OutboundInstruct outboundInstruct) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5f00\u59cb\u5904\u7406\u51fa\u5e93\u6307\u4ee4{}", (Object)JSONUtil.toJSon((Object)outboundInstruct));
        }
        String lineCode = "";
        lineCode = "ANNTOMVOUT".equalsIgnoreCase(outboundInstruct.getBILL_TYPE()) ? outboundInstruct.getWORKCENTER_CODE() : outboundInstruct.getLINE_CODE();
        List stations = this.mdStationnodepositionRepository.getIdleSlamTempStationPosition(Arrays.asList(TripState.FINISHED.getName()));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u67e5\u8be2\u5230\u4ea7\u7ebf{}\u7a7a\u95f2\u7684\u505c\u6b62\u70b9{}", (Object)lineCode, (Object)JSONUtil.toJSon((Object)stations));
        }
        if (CollectionUtils.isEmpty((Collection)stations)) {
            LOGGER.error("\u672a\u51fa\u5e93\u6307\u4ee4\u4ea7\u7ebfLINE_CODE{}\u5bf9\u5e94\u7684\u5de5\u4f5c\u7ad9 {} {}", (Object)lineCode, (Object)JSONUtil.toJSon((Object)outboundInstruct));
        } else {
            if (!this.checkPodOnSlamNode(lineCode)) {
                LOGGER.error("\u76ee\u7684\u5730\u4e0d\u5b58\u5728\u6216\u8005\u8d27\u67b6\u65e0\u6cd5\u751f\u6210\u56de\u5e93\u4efb\u52a1!" + lineCode);
                return;
            }
            LOGGER.error("\u4e3a" + lineCode + "\u751f\u6210\u51fa\u5e93\u4efb\u52a1! MESID:" + outboundInstruct.getMES_ID());
            ArrayList<String> tripState = new ArrayList<String>();
            tripState.add(TripState.FINISHED.getName());
            String sql = "SELECT MD_POD.ID FROM WMS_INBOUND_INSTRUCT \nINNER JOIN WMS_OUTBOUND_INSTRUCT ON WMS_INBOUND_INSTRUCT.LABEL_NO=WMS_OUTBOUND_INSTRUCT.LABEL_NO  INNER JOIN WMS_INV_UNITLOAD ON WMS_INV_UNITLOAD.INBOUND_INSTRUCT_ID=WMS_INBOUND_INSTRUCT.ID\nINNER JOIN MD_POD ON MD_POD.POD_INDEX=WMS_INV_UNITLOAD.POD_INDEX where WMS_INBOUND_INSTRUCT.LABEL_NO=:labelNo   and WMS_INBOUND_INSTRUCT.MO_NAME=:moName  and WMS_OUTBOUND_INSTRUCT.ID not in  (SELECT DISTINCT coalesce(WMS_INSTRUCT_OUT_POSITION.INSTRUCT_ID,'') from  WMS_INSTRUCT_OUT_POSITION  )  and WMS_INV_UNITLOAD.ENTITY_LOCK=0";
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("moName", outboundInstruct.getMO_NAME());
            param.put("labelNo", outboundInstruct.getLABEL_NO());
            List pods = this.entityManagerUtil.executeNativeQuery2(sql, param);
            if (CollectionUtils.isEmpty((Collection)pods)) {
                LOGGER.error("\u51fa\u5e93\u6307\u4ee4{} \u5de5\u5355\u53f7{} \u6ca1\u6709\u5e93\u5b58\u7eaa\u5f55", (Object)outboundInstruct.getId(), (Object)outboundInstruct.getMO_NAME());
            } else if (pods.size() > 1) {
                LOGGER.error("\u51fa\u5e93\u6307\u4ee4{} \u914d\u9001\u5361\u53f7{}\u5de5\u5355\u53f7{} \u67e5\u627e\u5230\u4e86\u591a\u4e2a\u5e93\u5b58\u7eaa\u5f55\n{}", new Object[]{outboundInstruct.getId(), outboundInstruct.getLABEL_NO(), outboundInstruct.getMO_NAME(), JSONUtil.toJSon((Object)pods)});
            } else {
                LOGGER.debug("\u51fa\u5e93\u6307\u4ee4{} \u914d\u9001\u5361\u53f7{}\u6ee1\u8db3\u51fa\u5e93\u6761\u4ef6", (Object)outboundInstruct.getId(), (Object)outboundInstruct.getLABEL_NO());
                Pod savePod = (Pod)this.podRepository.findOne((Serializable)((Object)((String)((Map)pods.get(0)).get("ID"))));
                List stationScore = this.commonBusiness.getStationPodScore(stations, savePod);
                Object object = this.lock;
                synchronized (object) {
                    String datetimeStock = DateTimeUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
                    WmsInstructOutPosition iop = new WmsInstructOutPosition();
                    iop.setCAR_NO("");
                    iop.setDATETIME_STOCK((Date)DateTimeUtil.strToTimeStamp((String)datetimeStock));
                    iop.setOutboundInstruct(outboundInstruct);
                    iop.setSTOCK_QTY(outboundInstruct.getQTY().toString());
                    StationPodScore sps = (StationPodScore)stationScore.get(0);
                    Stationnode sn = sps.getStationnodeposition().getStationnode();
                    String sectionId = sn.getSectionId();
                    String wareHouseId = sn.getWarehouseId();
                    List trips = this.tripRepository.getWorkStationNotFinishTrip(tripState, sectionId, sps.getStationnodeposition().getId(), wareHouseId);
                    Pod pod = this.podRepository.getWorkStationTrip(Integer.valueOf(sps.getStationnodeposition().getNode().getAddressCodeId()), sectionId);
                    if (!CollectionUtils.isEmpty((Collection)trips) || !ObjectUtils.isEmpty((Object)pod)) {
                        LOGGER.error("Stationnode id{} \u51fa\u5e93\u5de5\u4f5c\u7ad9{} \u5730\u5740{} pod {} \u6709\u672a\u5b8c\u6210\u7684\u8c03\u5ea6\u5355 \n{},\n\u672a\u5206\u914d\u6307\u4ee4{} ", new Object[]{sn.getId(), sn.getName(), sps.getStationnodeposition().getNode().getAddressCodeId(), JSONUtil.toJSon((Object)pod), JSONUtil.toJSon((Object)trips), JSONUtil.toJSon((Object)pod)});
                    } else {
                        boolean cancel;
                        List iis = this.outboundInstructRepository.getInstru(Arrays.asList(InstructStatus.CANCEL.getStatus()), outboundInstruct.getId());
                        boolean bl = cancel = !CollectionUtils.isEmpty((Collection)iis);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("\u51fa\u5e93\u6307\u4ee4\u662f\u5426\u53d6\u6d88{} {}", (Object)cancel, (Object)JSONUtil.toJSon((Object)iis));
                        }
                        if (!cancel) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("\u5f00\u59cb\u751f\u6210\u51fa\u5e93\u6307\u4ee4id{}\u7684\u8bb0\u5f55", (Object)outboundInstruct.getId());
                            }
                            this.podReserveUtil.reservePod(savePod);
                            Trip trip = this.buildEntityBusiness.buildTrip(savePod, sps.getStationnodeposition(), (Object)outboundInstruct, TripType.parserTripType((String)outboundInstruct.getBILL_TYPE()));
                            HashMap<String, Object> param2 = new HashMap<String, Object>();
                            param2.put("ID", outboundInstruct.getMES_ID());
                            param2.put("INV_ORG_ID", outboundInstruct.getINV_ORG_ID());
                            param2.put("BILL_TYPE", outboundInstruct.getBILL_TYPE());
                            param2.put("BILL_NO", outboundInstruct.getBILL_NO());
                            param2.put("LABEL_NO", outboundInstruct.getLABEL_NO());
                            param2.put("INV_CODE", outboundInstruct.getINV_CODE());
                            param2.put("STOCK_QTY", outboundInstruct.getQTY());
                            param2.put("DATETIME_STOCK", datetimeStock);
                            param2.put("LOC_CODE", "");
                            param2.put("STORAGE_NO_L", "");
                            param2.put("CAR_NO", "");
                            param2.put("STATUS", InstructStatus.ACCEPT.getStatus());
                            Map ack = this.restTempConfig.outBoundAck(param2);
                            LOGGER.debug("param2:" + param2);
                            LOGGER.debug("ack:" + ack);
                            this.hasGenTrip.put(outboundInstruct.getId(), trip.getId());
                            iop.setSTATUS(InstructStatus.ACCEPT.getStatus());
                            iop = (WmsInstructOutPosition)this.wmsInstructOutPositionRepository.saveAndFlush((Object)iop);
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("\u63a5\u6536\u5230\u51fa\u5e93\u6307\u4ee4,\u4fee\u6539\u72b6\u6001\u4e3aACCEPT\n \u6307\u4ee4{},\n\u53d6\u6d88\u540e\u4fe1\u606f{}", (Object)outboundInstruct.getId(), (Object)JSONUtil.toJSon((Object)iop));
                            }
                        } else {
                            LOGGER.debug("\u51fa\u5e93\u6307\u4ee4\u5df2\u7ecf\u53d6\u6d88");
                        }
                    }
                }
            }
        }
    }
}

