/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.service.impl;

import com.mushiny.wms.application.business.common.OutboundInstructBusiness;
import com.mushiny.wms.application.domain.OutboundInstruct;
import com.mushiny.wms.application.domain.WmsInstructOutPosition;
import com.mushiny.wms.application.service.OutboundInstructService;
import com.mushiny.wms.common.utils.DateTimeUtil;
import com.mushiny.wms.common.utils.JSONUtil;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional
public class OutboundInstructServiceImpl
implements OutboundInstructService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutboundInstructServiceImpl.class);
    private final OutboundInstructBusiness outboundInstructBusiness;
    @Autowired
    private EntityManager entityManager;

    @Autowired
    public OutboundInstructServiceImpl(OutboundInstructBusiness outboundInstructBusiness) {
        this.outboundInstructBusiness = outboundInstructBusiness;
    }

    public Integer saveOnboundInstruct(String outboundInstruct) {
        int result = 0;
        List param = JSONUtil.jsonToList((String)outboundInstruct);
        if (!CollectionUtils.isEmpty((Collection)param)) {
            for (Map temp : param) {
                OutboundInstruct oi = (OutboundInstruct)JSONUtil.mapToBean((Map)temp, (Object)new OutboundInstruct(), (String)"ID", (String)"MES_ID");
                result = this.outboundInstructBusiness.saveOutboundInstruct2(oi);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("\u5904\u7406\u5165\u5e93\u6307\u4ee4\u8fd4\u56de{} --{} ", (Object)result, (Object)JSONUtil.toJSon((Object)oi));
            }
        }
        return result;
    }

    public Page<OutboundInstruct> getByOutboundLabelNo(String startTime, String endTime, String labelNo, Pageable pageable) {
        String hql = "SELECT i FROM " + OutboundInstruct.class.getSimpleName() + " i WHERE 1=1";
        if (startTime != null && !ObjectUtils.equals((Object)"", (Object)startTime)) {
            hql = hql + " AND i.createdDate>:startDate";
        }
        if (endTime != null && !ObjectUtils.equals((Object)"", (Object)endTime)) {
            hql = hql + " AND i.modifiedDate<:endDate";
        }
        if (labelNo != null && !ObjectUtils.equals((Object)"", (Object)labelNo)) {
            hql = hql + " AND i.LABEL_NO = :labelNo";
        }
        TypedQuery query = this.entityManager.createQuery(hql, OutboundInstruct.class);
        TypedQuery query2 = this.entityManager.createQuery(hql, OutboundInstruct.class);
        if (startTime != null && !ObjectUtils.equals((Object)"", (Object)startTime)) {
            LocalDateTime start = DateTimeUtil.getLocalDatetime((String)(startTime + " 00:00:00"));
            query.setParameter("startDate", (Object)start);
            query2.setParameter("startDate", (Object)start);
        }
        if (endTime != null && !ObjectUtils.equals((Object)"", (Object)endTime)) {
            LocalDateTime end = DateTimeUtil.getLocalDatetime((String)(endTime + " 23:59:59"));
            query.setParameter("endDate", (Object)end);
            query2.setParameter("endDate", (Object)end);
        }
        if (labelNo != null && !ObjectUtils.equals((Object)"", (Object)labelNo)) {
            query.setParameter("labelNo", (Object)labelNo);
            query2.setParameter("labelNo", (Object)labelNo);
        }
        query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
        query.setMaxResults(pageable.getPageSize());
        List list = query.getResultList();
        List list2 = query2.getResultList();
        long count = list2.size();
        return new PageImpl(list, pageable, count);
    }

    public List<WmsInstructOutPosition> getOutboundByLabelNo(String labelNo) {
        String hql = "SELECT i FROM " + WmsInstructOutPosition.class.getSimpleName() + " i WHERE i.outboundInstruct.LABEL_NO=:labelNo";
        TypedQuery query = this.entityManager.createQuery(hql, WmsInstructOutPosition.class);
        query.setParameter("labelNo", (Object)labelNo);
        List list = query.getResultList();
        return list;
    }
}

