/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.service.impl;

import com.mushiny.wms.application.domain.InboundInstruct;
import com.mushiny.wms.application.domain.OutboundInstruct;
import com.mushiny.wms.application.domain.enums.InstructStatus;
import com.mushiny.wms.application.repository.InboundInstructRepository;
import com.mushiny.wms.application.repository.OutboundInstructRepository;
import com.mushiny.wms.application.repository.WmsInstructInPositionRepository;
import com.mushiny.wms.application.repository.WmsInstructOutPositionRepository;
import com.mushiny.wms.application.service.InboundTripService;
import com.mushiny.wms.application.service.InstructService;
import com.mushiny.wms.application.service.OutboundTripService;
import com.mushiny.wms.common.utils.JSONUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
@Transactional
public class InstructServiceImpl
implements InstructService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstructServiceImpl.class);
    private OutboundTripService outboundTripService;
    private InboundTripService inboundTripService;
    private OutboundInstructRepository outboundInstructRepository;
    private InboundInstructRepository inboundInstructRepository;
    private WmsInstructInPositionRepository wmsInstructInPositionRepository;
    private WmsInstructOutPositionRepository wmsInstructOutPositionRepository;

    @Autowired
    public InstructServiceImpl(OutboundTripService outboundTripService, InboundTripService inboundTripService, OutboundInstructRepository outboundInstructRepository, InboundInstructRepository inboundInstructRepository, WmsInstructInPositionRepository wmsInstructInPositionRepository, WmsInstructOutPositionRepository wmsInstructOutPositionRepository) {
        this.outboundTripService = outboundTripService;
        this.inboundTripService = inboundTripService;
        this.outboundInstructRepository = outboundInstructRepository;
        this.inboundInstructRepository = inboundInstructRepository;
        this.wmsInstructInPositionRepository = wmsInstructInPositionRepository;
        this.wmsInstructOutPositionRepository = wmsInstructOutPositionRepository;
    }

    public boolean cancelInstruct(String cancelRequest) {
        boolean result = false;
        List params = JSONUtil.jsonToList((String)cancelRequest);
        if (!CollectionUtils.isEmpty((Collection)params)) {
            Map param = (Map)params.get(0);
            String id = "" + param.get("ID");
            String InOrOut = "" + param.get("InOrOut");
            String INV_ORG_ID = "" + param.get("INV_ORG_ID");
            String BILL_TYPE = "" + param.get("BILL_TYPE");
            String BILL_NO = "" + param.get("BILL_NO");
            String LABEL_NO = "" + param.get("LABEL_NO");
            String INV_CODE = "" + param.get("INV_CODE");
            String MO_NAME = "" + param.get("MO_NAME");
            if ("In".equalsIgnoreCase(InOrOut)) {
                InboundInstruct inboundInstruct = this.inboundInstructRepository.getInstruByMesId(id);
                if (!ObjectUtils.isEmpty((Object)inboundInstruct)) {
                    result = this.inboundTripService.cancelInstruct(inboundInstruct, InstructStatus.CANCEL.getStatus());
                } else {
                    LOGGER.error("\u672a\u627e\u5230\u5165\u5e93\u6307\u4ee4,\u53c2\u6570{}", (Object)JSONUtil.toJSon((Object)param));
                }
            } else {
                OutboundInstruct outboundInstruct = this.outboundInstructRepository.getInstruById(id);
                if (!ObjectUtils.isEmpty((Object)outboundInstruct)) {
                    result = this.outboundTripService.cancelInstruct(outboundInstruct, InstructStatus.CANCEL.getStatus());
                } else {
                    LOGGER.error("\u672a\u627e\u5230\u51fa\u5e93\u6307\u4ee4,\u53c2\u6570{}", (Object)JSONUtil.toJSon((Object)param));
                }
            }
        } else {
            LOGGER.error("\u8f6c\u6362\u6307\u4ee4{}\u51fa\u9519", (Object)cancelRequest);
        }
        return result;
    }

    public Object getInstruct(String param) {
        List outboundInstruct;
        List inboundInstruct;
        List result = null;
        Map param2 = JSONUtil.jsonToMap((String)param);
        String ID = (String)param2.get("ID");
        String InOrOut = (String)param2.get("InOrOut");
        String INV_ORG_ID = (String)param2.get("INV_ORG_ID");
        String BILL_TYPE = (String)param2.get("BILL_TYPE");
        String BILL_NO = (String)param2.get("BILL_NO");
        String INV_CODE = (String)param2.get("INV_CODE");
        String MO_NAME = (String)param2.get("MO_NAME");
        result = "In".equalsIgnoreCase(InOrOut) ? (inboundInstruct = this.wmsInstructInPositionRepository.getWmsInstructInPosition(INV_ORG_ID, BILL_TYPE, ID)) : (outboundInstruct = this.wmsInstructOutPositionRepository.getInstructOutPosition(INV_ORG_ID, BILL_TYPE, ID));
        return result;
    }

    public Integer updateInstruct(String param) {
        Integer result = 1;
        Map param2 = JSONUtil.jsonToMap((String)param);
        String InOrOut = (String)param2.get("InOrOut");
        String INV_ORG_ID = (String)param2.get("INV_ORG_ID");
        String BILL_TYPE = (String)param2.get("BILL_TYPE");
        String BILL_NO = (String)param2.get("BILL_NO");
        String INV_CODE = (String)param2.get("INV_CODE");
        String MO_NAME = (String)param2.get("MO_NAME");
        if ("In".equalsIgnoreCase(InOrOut)) {
            InboundInstruct inboundInstruct = this.inboundInstructRepository.getInstruByCondition(INV_ORG_ID, BILL_TYPE, BILL_NO, INV_CODE, MO_NAME);
            if (ObjectUtils.isEmpty((Object)inboundInstruct)) {
                result = 0;
            }
        } else {
            OutboundInstruct outboundInstruct = this.outboundInstructRepository.getInstruByCondition(INV_ORG_ID, BILL_TYPE, BILL_NO, INV_CODE, MO_NAME);
            if (!ObjectUtils.isEmpty((Object)outboundInstruct)) {
                outboundInstruct.setWORKCENTER_CODE((String)param2.get("WORKCENTER_CODE"));
                this.outboundInstructRepository.save((Object)outboundInstruct);
            } else {
                result = 0;
            }
        }
        return result;
    }
}

