/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.service.impl;

import com.mushiny.wms.application.business.common.BuildEntityBusiness;
import com.mushiny.wms.application.business.common.PodReserveUtil;
import com.mushiny.wms.application.business.common.StationNodeBusiness;
import com.mushiny.wms.application.business.common.SystemPropertyBusiness;
import com.mushiny.wms.application.config.RestTempConfig;
import com.mushiny.wms.application.domain.Constance;
import com.mushiny.wms.application.domain.InboundInstruct;
import com.mushiny.wms.application.domain.Pod;
import com.mushiny.wms.application.domain.SfcMitem;
import com.mushiny.wms.application.domain.Trip;
import com.mushiny.wms.application.domain.WmsInstructInPosition;
import com.mushiny.wms.application.domain.WmsInvStockunit;
import com.mushiny.wms.application.domain.WmsInvUnitload;
import com.mushiny.wms.application.domain.enums.InstructStatus;
import com.mushiny.wms.application.domain.enums.StationType;
import com.mushiny.wms.application.domain.enums.TripType;
import com.mushiny.wms.application.rabbitMq.RabbitMqReceiver;
import com.mushiny.wms.application.redis.RedisUtil;
import com.mushiny.wms.application.repository.InboundInstructRepository;
import com.mushiny.wms.application.repository.MdStationnodepositionRepository;
import com.mushiny.wms.application.repository.PodRepository;
import com.mushiny.wms.application.repository.SectionRepository;
import com.mushiny.wms.application.repository.SfcMitemRepository;
import com.mushiny.wms.application.repository.TripRepository;
import com.mushiny.wms.application.repository.WmsInstructInPositionRepository;
import com.mushiny.wms.application.repository.WmsInvStockunitRepository;
import com.mushiny.wms.application.repository.WmsInvUnitLoadRepository;
import com.mushiny.wms.application.repository.WorkStationRepository;
import com.mushiny.wms.application.service.InboundTripService;
import com.mushiny.wms.application.test.AckSimulate;
import com.mushiny.wms.common.utils.DateTimeUtil;
import com.mushiny.wms.common.utils.JSONUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class InboundTripServiceImpl
implements InboundTripService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InboundTripServiceImpl.class);
    @Value(value="${mushiny.test}")
    private boolean test = false;
    @Autowired
    private AckSimulate ackSimulate;
    @Autowired
    private RabbitMqReceiver rabbitMqReceiver;
    private final SectionRepository sectionRepository;
    private final WorkStationRepository workStationRepository;
    private final InboundInstructRepository inboundInstructRepository;
    private final SystemPropertyBusiness systemPropertyBusiness;
    private final TripRepository tripRepository;
    private final PodRepository podRepository;
    private final BuildEntityBusiness buildEntityBusiness;
    private PodReserveUtil podReserveUtil;
    private final WmsInvUnitLoadRepository wmsInvUnitLoadRepository;
    private final SfcMitemRepository sfcMitemRepository;
    private final WmsInvStockunitRepository wmsInvStockunitRepository;
    private final MdStationnodepositionRepository mdStationnodepositionRepository;
    private final RedisUtil redisUtil;
    private final Object lock = new Object();
    @Autowired
    private StationNodeBusiness stationNodeBusiness;
    @Autowired
    private WmsInstructInPositionRepository wmsInstructInPositionRepository;
    private Map value = null;
    @Autowired
    private RestTempConfig restTempConfig;

    @Autowired
    public InboundTripServiceImpl(SectionRepository sectionRepository, WorkStationRepository workStationRepository, InboundInstructRepository inboundInstructRepository, SystemPropertyBusiness systemPropertyBusiness, TripRepository tripRepository, PodRepository podRepository, PodReserveUtil podReserveUtil, BuildEntityBusiness buildEntityBusiness, WmsInvUnitLoadRepository wmsInvUnitLoadRepository, SfcMitemRepository sfcMitemRepository, WmsInvStockunitRepository wmsInvStockunitRepository, MdStationnodepositionRepository mdStationnodepositionRepository, RedisUtil redisUtil) {
        this.sectionRepository = sectionRepository;
        this.workStationRepository = workStationRepository;
        this.inboundInstructRepository = inboundInstructRepository;
        this.systemPropertyBusiness = systemPropertyBusiness;
        this.tripRepository = tripRepository;
        this.podRepository = podRepository;
        this.podReserveUtil = podReserveUtil;
        this.buildEntityBusiness = buildEntityBusiness;
        this.wmsInvUnitLoadRepository = wmsInvUnitLoadRepository;
        this.sfcMitemRepository = sfcMitemRepository;
        this.wmsInvStockunitRepository = wmsInvStockunitRepository;
        this.mdStationnodepositionRepository = mdStationnodepositionRepository;
        this.redisUtil = redisUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    private void execute(InboundInstruct is) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5f00\u59cb\u6267\u884c\u5165\u5e93\u6307\u4ee4\n{}", (Object)JSONUtil.toJSon((Object)is));
        }
        String podName = "";
        if (!StringUtils.isEmpty((Object)is.getSTORAGE_NO_L()) && StringUtils.isEmpty((Object)is.getSTORAGE_NO_R())) {
            podName = is.getSTORAGE_NO_L();
        } else if (!StringUtils.isEmpty((Object)is.getSTORAGE_NO_R()) && StringUtils.isEmpty((Object)is.getSTORAGE_NO_L())) {
            podName = is.getSTORAGE_NO_R();
        } else {
            LOGGER.error("\u63a5\u53d7\u5230\u5165\u5e93\u6307\u4ee4STORAGE_NO_L STORAGE_NO_R \u8d27\u67b6\u4e3a\u7a7a,\u505c\u6b62\u8c03\u5ea6{}", (Object)JSONUtil.toJSon((Object)is));
            return;
        }
        if (this.test) {
            Map param = this.ackSimulate.ceateParam(is.getId(), is.getBILL_TYPE(), InstructStatus.ACCEPT.getStatus(), podName);
            this.rabbitMqReceiver.receiveMapMessage2(param);
            try {
                TimeUnit.SECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            param = this.ackSimulate.ceateParam(is.getId(), is.getBILL_TYPE(), InstructStatus.RUNNING.getStatus(), podName);
            try {
                TimeUnit.SECONDS.sleep(10L);
                this.rabbitMqReceiver.receiveMapMessage2(param);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            param = this.ackSimulate.ceateParam(is.getId(), is.getBILL_TYPE(), InstructStatus.STOCKIN.getStatus(), podName);
            try {
                TimeUnit.SECONDS.sleep(10L);
                this.rabbitMqReceiver.receiveMapMessage2(param);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return;
        }
        Pod pod = this.podRepository.getByPodName(podName);
        if (ObjectUtils.isEmpty((Object)pod)) {
            LOGGER.error("\u65e0\u8d27\u67b6{}", (Object)podName);
            return;
        }
        String stationName = is.getWORKCENTER_CODE();
        List stations = this.mdStationnodepositionRepository.getStationPosition(StationType.INBOUND, pod.getPlaceMark(), stationName);
        if (CollectionUtils.isEmpty((Collection)stations)) {
            LOGGER.error("\u5904\u7406\u5165\u5e93\u6307\u4ee4 {}\u51fa\u9519, \u8d27\u67b6{} \u5730\u5740{} \u4e0d\u5728\u5de5\u4f5c\u7ad9{}\u4f4d\u7f6e", new Object[]{is.getId(), pod.getPodIndex(), pod.getPlaceMark(), stationName});
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            boolean cancel;
            String datetimeStock = DateTimeUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
            WmsInstructInPosition iip = new WmsInstructInPosition();
            iip.setInboundInstruct(is);
            iip.setCAR_NO("");
            iip.setDATETIME_STOCK((Date)DateTimeUtil.strToTimeStamp((String)datetimeStock));
            iip.setLOC_CODE(pod.getPodIndex() + "");
            iip.setSTATUS(InstructStatus.ACCEPT.getStatus());
            List iis = this.inboundInstructRepository.getInstru(Arrays.asList(InstructStatus.CANCEL.getStatus()), is.getId());
            boolean bl = cancel = !CollectionUtils.isEmpty((Collection)iis);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u6307\u4ee4\u662f\u5426\u53d6\u6d88{} {}", (Object)cancel, (Object)JSONUtil.toJSon((Object)iis));
            }
            if (!cancel) {
                WmsInvUnitload invLoad;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("\u5f00\u59cb\u751f\u6210\u5165\u5e93\u6307\u4ee4id{}\u7684\u8bb0\u5f55", (Object)is.getId());
                }
                if (!ObjectUtils.isEmpty((Object)(invLoad = this.wmsInvUnitLoadRepository.getUnitLoadByPodIndex(pod.getPodIndex(), Constance.avable)))) {
                    LOGGER.error("\u4fdd\u5b58\u5165\u5e93\u6307\u4ee4 {} \u5e93\u5b58\u5931\u8d25,\u5df2\u7ecf\u5b58\u5728\u5bf9\u5e94\u7684\u5e93\u5b58unitLoad{}", (Object)is.getId(), (Object)invLoad.getId());
                    return;
                }
                invLoad = new WmsInvUnitload();
                invLoad.setPodIndex(pod.getPodIndex());
                invLoad.setInboundInstructId(is.getId());
                invLoad.setStationName(stationName);
                invLoad.setEntityLock(Constance.avable);
                invLoad.setWarehouseId(pod.getWarehouseId());
                invLoad = (WmsInvUnitload)this.wmsInvUnitLoadRepository.saveAndFlush((Object)invLoad);
                List sfcMitems = this.sfcMitemRepository.getSfcMitemByName(is.getMITEM_CODE());
                WmsInvStockunit skunit = new WmsInvStockunit();
                skunit.setClientId("SYSTEM");
                skunit.setWarehouseId(pod.getWarehouseId());
                skunit.setAmount(is.getQTY());
                skunit.setState("Inventory");
                skunit.setEntityLock(Constance.stockInUnit);
                skunit.setUnitloadId(invLoad.getId());
                skunit.setItemdataId(ObjectUtils.isEmpty((Object)sfcMitems) ? "" : ((SfcMitem)sfcMitems.get(0)).getId());
                this.wmsInvStockunitRepository.saveAndFlush((Object)skunit);
                this.podReserveUtil.reservePod(pod);
                Trip trip = this.buildEntityBusiness.buildTrip(pod, null, (Object)is, TripType.parserTripType((String)is.getBILL_TYPE()));
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("ID", is.getMES_ID());
                param.put("INV_ORG_ID", is.getINV_ORG_ID());
                param.put("BILL_TYPE", is.getBILL_TYPE());
                param.put("BILL_NO", is.getBILL_NO());
                param.put("LABEL_NO", is.getLABEL_NO());
                param.put("INV_CODE", is.getINV_CODE());
                param.put("CAR_NO", "");
                param.put("LOC_CODE", pod.getPodIndex());
                param.put("STATUS", InstructStatus.ACCEPT.getStatus());
                param.put("DATETIME_STOCK", datetimeStock);
                Map ack = this.restTempConfig.inBoundAck(param);
                iip.setSTATUS(InstructStatus.ACCEPT.getStatus());
                iip = (WmsInstructInPosition)this.wmsInstructInPositionRepository.saveAndFlush((Object)iip);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("\u4fdd\u5b58\u5165\u5e93\u6307\u4ee4CREATE\u72b6\u6001\u6210\u529f\n{}", (Object)JSONUtil.toJSon((Object)iip));
                }
            } else {
                LOGGER.debug(" \u6307\u4ee4id " + is.getId() + "\u88ab\u53d6\u6d88");
            }
        }
    }

    public void buildTrip() {
        this.value = new HashMap();
        List iis = this.inboundInstructRepository.getAllNotCreateTripInstru(Arrays.asList(InstructStatus.ACCEPT.getStatus(), InstructStatus.CANCEL.getStatus(), InstructStatus.RUNNING.getStatus(), InstructStatus.STOCKIN.getStatus()));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u67e5\u8be2\u5230\u9700\u8981\u8c03\u5ea6\u7684\u5165\u5e93\u6307\u4ee4\n{}", (Object)JSONUtil.toJSon((Object)iis));
        }
        if (!CollectionUtils.isEmpty((Collection)iis)) {
            int len = iis.size();
            List executeInstruct = null;
            executeInstruct = len > 5 ? iis.subList(0, 4) : iis.subList(0, len);
            for (InboundInstruct ii : executeInstruct) {
                try {
                    this.execute(ii);
                }
                catch (Exception e) {
                    LOGGER.error("\u5904\u7406\u5165\u5e93\u6307\u4ee4\u51fa\u9519{}", (Object)JSONUtil.toJSon((Object)ii));
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        } else {
            LOGGER.debug("\u6ca1\u6709\u9700\u8981\u8c03\u5ea6\u7684\u5165\u5e93\u6307\u4ee4");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelInstruct(InboundInstruct instruct, String status) {
        Boolean result = false;
        Object object = this.lock;
        synchronized (object) {
            List iis = this.inboundInstructRepository.getInstru(Arrays.asList(InstructStatus.ACCEPT.getStatus(), InstructStatus.STOCKIN.getStatus(), InstructStatus.RUNNING.getStatus()), instruct.getId());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u5165\u5e93\u6307\u4ee4id{} \u5df2\u7ecf\u751f\u6210{}", (Object)instruct.getId(), (Object)JSONUtil.toJSon((Object)iis));
            }
            if (CollectionUtils.isEmpty((Collection)iis)) {
                String datetimeStock = DateTimeUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
                WmsInstructInPosition iip = new WmsInstructInPosition();
                iip.setInboundInstruct(instruct);
                iip.setCAR_NO("");
                iip.setDATETIME_STOCK((Date)DateTimeUtil.strToTimeStamp((String)datetimeStock));
                iip.setSTATUS(InstructStatus.CANCEL.getStatus());
                iip = (WmsInstructInPosition)this.wmsInstructInPositionRepository.saveAndFlush((Object)iip);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("\u751f\u6210\u5165\u5e93\u6307\u4ee4id{} \u53d6\u6d88\u660e\u7ec6{}", (Object)instruct.getId(), (Object)JSONUtil.toJSon((Object)iip));
                }
                result = true;
            }
        }
        return result;
    }
}

