/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.service.impl;

import com.mushiny.wms.application.business.common.InboundInstructBusiness;
import com.mushiny.wms.application.domain.InboundInstruct;
import com.mushiny.wms.application.domain.WmsInstructInPosition;
import com.mushiny.wms.application.service.InboundInstructService;
import com.mushiny.wms.common.utils.DateTimeUtil;
import com.mushiny.wms.common.utils.JSONUtil;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class InboundInstructServiceImpl
implements InboundInstructService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InboundInstructServiceImpl.class);
    private final InboundInstructBusiness inboundInstructBusiness;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public InboundInstructServiceImpl(InboundInstructBusiness inboundInstructBusiness) {
        this.inboundInstructBusiness = inboundInstructBusiness;
    }

    public Integer saveInboundInstruct(String inboundInstruct) {
        int result = 0;
        List param = JSONUtil.jsonToList((String)inboundInstruct);
        for (Map temp : param) {
            InboundInstruct iis = (InboundInstruct)JSONUtil.mapToBean((Map)temp, (Object)new InboundInstruct(), (String)"ID", (String)"MES_ID");
            result = this.inboundInstructBusiness.saveInboundInstruct2(iis);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("\u5904\u7406\u5165\u5e93\u6307\u4ee4\u8fd4\u56de{} --{} ", (Object)result, (Object)JSONUtil.toJSon((Object)iis));
        }
        return result;
    }

    public Page<InboundInstruct> getByInboundLabelNo(String startTime, String endTime, String labelNo, Pageable pageable) {
        String hql = "SELECT i FROM " + InboundInstruct.class.getSimpleName() + " i WHERE 1=1";
        if (startTime != null && !ObjectUtils.equals((Object)"", (Object)startTime)) {
            hql = hql + " AND i.createdDate>:startDate";
        }
        if (endTime != null && !ObjectUtils.equals((Object)"", (Object)endTime)) {
            hql = hql + " AND i.modifiedDate<:endDate";
        }
        if (labelNo != null && !ObjectUtils.equals((Object)"", (Object)labelNo)) {
            hql = hql + " AND i.LABEL_NO = :labelNo";
        }
        TypedQuery query = this.entityManager.createQuery(hql, InboundInstruct.class);
        TypedQuery query2 = this.entityManager.createQuery(hql, InboundInstruct.class);
        if (startTime != null && !ObjectUtils.equals((Object)"", (Object)startTime)) {
            LocalDateTime start = DateTimeUtil.getLocalDatetime((String)(startTime + " 00:00:00"));
            query.setParameter("startDate", (Object)start);
            query2.setParameter("startDate", (Object)start);
        }
        if (endTime != null && !ObjectUtils.equals((Object)"", (Object)endTime)) {
            LocalDateTime end = DateTimeUtil.getLocalDatetime((String)(endTime + " 23:59:59"));
            query.setParameter("endDate", (Object)end);
            query2.setParameter("endDate", (Object)end);
        }
        if (labelNo != null && !ObjectUtils.equals((Object)"", (Object)labelNo)) {
            query.setParameter("labelNo", (Object)labelNo);
            query2.setParameter("labelNo", (Object)labelNo);
        }
        query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
        query.setMaxResults(pageable.getPageSize());
        List list = query.getResultList();
        List list2 = query2.getResultList();
        long count = list2.size();
        return new PageImpl(list, pageable, count);
    }

    public List<WmsInstructInPosition> getInboundByLabelNo(String labelNo) {
        String hql = "SELECT i FROM " + WmsInstructInPosition.class.getSimpleName() + " i WHERE i.inboundInstruct.LABEL_NO=:labelNo";
        TypedQuery query = this.entityManager.createQuery(hql, WmsInstructInPosition.class);
        query.setParameter("labelNo", (Object)labelNo);
        List list = query.getResultList();
        return list;
    }
}

