/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.service.impl;

import com.mushiny.wms.application.business.common.BuildEntityBusiness;
import com.mushiny.wms.application.business.common.CommonBusiness;
import com.mushiny.wms.application.business.common.PodReserveUtil;
import com.mushiny.wms.application.business.common.StationNodeBusiness;
import com.mushiny.wms.application.business.common.SystemPropertyBusiness;
import com.mushiny.wms.application.business.score.StationPodScore;
import com.mushiny.wms.application.config.RestTempConfig;
import com.mushiny.wms.application.domain.MdStationnodeposition;
import com.mushiny.wms.application.domain.enums.StationType;
import com.mushiny.wms.application.domain.enums.TripState;
import com.mushiny.wms.application.domain.enums.TripType;
import com.mushiny.wms.application.repository.MdStationnodepositionRepository;
import com.mushiny.wms.application.repository.PodRepository;
import com.mushiny.wms.application.repository.SectionRepository;
import com.mushiny.wms.application.repository.StationnodeRepository;
import com.mushiny.wms.application.repository.TripRepository;
import com.mushiny.wms.application.repository.WorkStationRepository;
import com.mushiny.wms.application.service.EmptyPodCarryService;
import com.mushiny.wms.common.utils.EntityManagerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional
public class EmptyPodCarryServiceImpl
implements EmptyPodCarryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmptyPodCarryService.class);
    private final SectionRepository sectionRepository;
    private final WorkStationRepository workStationRepository;
    private final TripRepository tripRepository;
    private final SystemPropertyBusiness systemPropertyBusiness;
    private final PodRepository podRepository;
    private final EntityManagerUtil entityManagerUtil;
    private final BuildEntityBusiness buildEntityBusiness;
    private final MdStationnodepositionRepository mdStationnodepositionRepository;
    @Autowired
    private CommonBusiness commonBusiness;
    @Autowired
    private StationnodeRepository stationnodeRepository;
    private PodReserveUtil podReserveUtil;
    @Autowired
    private StationNodeBusiness stationNodeBusiness;
    @Autowired
    private RestTempConfig restTempConfig;

    @Autowired
    public EmptyPodCarryServiceImpl(SectionRepository sectionRepository, WorkStationRepository workStationRepository, TripRepository tripRepository, SystemPropertyBusiness systemPropertyBusiness, PodRepository podRepository, EntityManagerUtil entityManagerUtil, PodReserveUtil podReserveUtil, BuildEntityBusiness buildEntityBusiness, MdStationnodepositionRepository mdStationnodepositionRepository) {
        this.sectionRepository = sectionRepository;
        this.workStationRepository = workStationRepository;
        this.tripRepository = tripRepository;
        this.systemPropertyBusiness = systemPropertyBusiness;
        this.podRepository = podRepository;
        this.entityManagerUtil = entityManagerUtil;
        this.podReserveUtil = podReserveUtil;
        this.buildEntityBusiness = buildEntityBusiness;
        this.mdStationnodepositionRepository = mdStationnodepositionRepository;
    }

    public void runEmptyPodCarry() {
        List stations = this.mdStationnodepositionRepository.getCallPodStationPosition(StationType.INBOUND, Arrays.asList(TripState.FINISHED.getName()));
        if (CollectionUtils.isEmpty((Collection)stations)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u672a\u627e\u5230\u5165\u5e93\u5de5\u4f5c\u7ad9");
            }
            return;
        }
        for (MdStationnodeposition msp : stations) {
            this.execute(msp);
        }
    }

    private synchronized void execute(MdStationnodeposition stationPosition) {
        String sectionId = stationPosition.getStationnode().getSectionId();
        String warehouseId = stationPosition.getStationnode().getWarehouseId();
        String sql = "SELECT MD_POD.ID   FROM MD_POD INNER JOIN WD_NODE ON WD_NODE.ADDRESSCODEID=MD_POD.PLACEMARK AND WD_NODE.TYPE=1 INNER JOIN WD_MAP on WD_NODE.MAP_ID=WD_MAP.ID and WD_MAP.ACTIVE=1  WHERE MD_POD.STATE='Available' AND MD_POD.PLACEMARK<>0 AND MD_POD.SECTION_ID=:sectionId AND MD_POD.ID NOT IN (SELECT coalesce(RCS_TRIP.POD_ID,'')  FROM RCS_TRIP WHERE RCS_TRIP.TRIP_STATE<>'Finish') and MD_POD.POD_INDEX not in ( SELECT DISTINCT WMS_INV_UNITLOAD.POD_INDEX FROM WMS_INV_UNITLOAD  where WMS_INV_UNITLOAD.WAREHOUSE_ID=:wareHouseId  and WMS_INV_UNITLOAD.ENTITY_LOCK=0)";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("sectionId", sectionId);
        param.put("wareHouseId", warehouseId);
        List pods = this.entityManagerUtil.executeNativeQuery2(sql, param);
        ArrayList<String> tt = new ArrayList<String>();
        for (Map t : pods) {
            tt.add("" + t.get("ID"));
        }
        if (CollectionUtils.isEmpty((Collection)pods)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u4ed3\u5e93{} section {} \u50a8\u4f4d\u6ca1\u6709\u53ef\u7528\u7684\u7a7apod", (Object)warehouseId, (Object)sectionId);
            }
            return;
        }
        List pod2 = this.podRepository.getPodById(tt);
        List podScore = this.commonBusiness.getPodScore(pod2, stationPosition);
        this.podReserveUtil.reservePod(((StationPodScore)podScore.get(0)).getPod());
        this.buildEntityBusiness.buildTrip(((StationPodScore)podScore.get(0)).getPod(), ((StationPodScore)podScore.get(0)).getStationnodeposition(), null, TripType.CARRY_POD);
    }
}

