/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.service.impl;

import com.mushiny.wms.application.business.ChargerAllocationBusiness;
import com.mushiny.wms.application.business.common.CommonBusiness;
import com.mushiny.wms.application.business.trip.ApplicationTripHandlerFactory;
import com.mushiny.wms.application.business.trip.TripHandler;
import com.mushiny.wms.application.domain.Section;
import com.mushiny.wms.application.domain.Trip;
import com.mushiny.wms.application.domain.WCSRobot;
import com.mushiny.wms.application.domain.enums.TripState;
import com.mushiny.wms.application.domain.enums.TripType;
import com.mushiny.wms.application.repository.SectionRepository;
import com.mushiny.wms.application.repository.TripRepository;
import com.mushiny.wms.application.service.DriveAllocationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional
public class DriveAllocationServiceImpl
implements DriveAllocationService {
    private final SectionRepository sectionRepository;
    private final ChargerAllocationBusiness chargerAllocationBusiness;
    private static final Logger LOGGER = LoggerFactory.getLogger(DriveAllocationServiceImpl.class);
    private final CommonBusiness commonBusiness;
    private final TripRepository tripRepository;

    @Autowired
    public DriveAllocationServiceImpl(SectionRepository sectionRepository, ChargerAllocationBusiness chargerAllocationBusiness, CommonBusiness commonBusiness, TripRepository tripRepository) {
        this.sectionRepository = sectionRepository;
        this.chargerAllocationBusiness = chargerAllocationBusiness;
        this.commonBusiness = commonBusiness;
        this.tripRepository = tripRepository;
    }

    public void runDriveAllocation() {
        List sections = new ArrayList();
        sections = this.sectionRepository.getAll();
        for (Section section : sections) {
            this.doAllocation(section);
        }
    }

    private void doAllocation(Section section) {
        try {
            this.chargerAllocationBusiness.runChargerAllocation(section);
        }
        catch (Exception e) {
            LOGGER.error("\u751f\u6210\u5145\u7535\u4efb\u52a1\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        TripHandler tripHandler = ApplicationTripHandlerFactory.getInstance();
        List trips = tripHandler.commonBusiness.getAllNewTrip(section.getId());
        TripHandler.allocated.clear();
        if (!CollectionUtils.isEmpty((Collection)trips)) {
            tripHandler.execute(trips, section);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("section {} {} \u65e0\u8c03\u5ea6\u5355\u53ef\u5206\u914d\u8f66", (Object)section.getName(), (Object)section.getId());
        }
        this.agvDriver(section.getId());
    }

    private void agvDriver(String sectionId) {
        List robots = this.commonBusiness.getAvailableDrives2(sectionId);
        for (WCSRobot wr : robots) {
            try {
                Integer moveTargetAddress = this.commonBusiness.getMoveDriveTargetAddress3(sectionId, wr.getAddressCodeId());
                Trip moveTrip = new Trip();
                moveTrip.setTripType(TripType.MOVE_DRIVE.getName());
                moveTrip.setTripState(TripState.AVAILABLE.getName());
                moveTrip.setDriveId(wr.getRobotId());
                moveTrip.setEndAddress(moveTargetAddress);
                moveTrip.setSectionId(sectionId);
                moveTrip.setWarehouseId(wr.getWarehouseId());
                moveTrip = (Trip)this.tripRepository.saveAndFlush((Object)moveTrip);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("\u751f\u6210\u51fa\u5e93\u5c0f\u8f66 {} \u8c03\u8d70\u7684\u8c03\u5ea6\u5355{}\u6210\u529f", (Object)wr.getRobotId(), (Object)moveTrip.getId());
            }
            catch (Exception e) {
                LOGGER.error("\u751f\u6210\u51fa\u5e93\u5c0f\u8f66\u5931\u8d25" + e.getMessage(), (Throwable)e);
            }
        }
    }
}

