/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.repository;

import com.mushiny.wms.application.domain.WCSRobot;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface WCSRobotRepository
extends JpaRepository<WCSRobot, String> {
    @Query(value=" select r from WCSRobot r  where r.sectionId = :sectionId and r.robotId=:robotId")
    public WCSRobot getWCSRobotByRobotId(@Param(value="robotId") String var1, @Param(value="sectionId") String var2);

    @Query(value=" select r from WCSRobot r  where r.sectionId = :sectionId and r.addressCodeId in (select c.placeMark from Charger c where c.entityLock = 0 and  c.chargerType=1 and c.sectionId = :sectionId  )")
    public List<WCSRobot> getWCSRobotByCharger(@Param(value="sectionId") String var1);

    @Query(value=" select r from WCSRobot r  where r.available = true and r.status in (1,2,3)  and r.sectionId = :sectionId  and r.addressCodeId <>0 and r.robotId not in (   select coalesce(t.driveId,'') from Trip t   where t.tripState in :tripStates and t.sectionId = :sectionId) ")
    public List<WCSRobot> getAvailableDrives(@Param(value="tripStates") List<String> var1, @Param(value="sectionId") String var2);

    @Query(value=" select r from WCSRobot r  where r.available = true and r.status in (1,2,3)  and r.sectionId = :sectionId  and r.addressCodeId <>0 and r.robotId not in (   select coalesce(t.driveId,'') from Trip t   where t.tripState in :tripStates and t.sectionId = :sectionId) and r.addressCodeId in(select distinct coalesce(n.node.addressCodeId,'') from MdStationnodeposition n left join n.stationnode sn   left join n.node nod where sn.type in :stationType and nod.type=8 and n.nodeType=1)")
    public List<WCSRobot> getDrives(@Param(value="tripStates") List<String> var1, @Param(value="sectionId") String var2, @Param(value="stationType") List<Integer> var3);

    @Query(value=" select r from WCSRobot r  where r.available = true and r.status in (1,2,3)  and r.sectionId = :sectionId and r.robotId=:robotId  and r.addressCodeId <>0 and r.robotId not in (   select coalesce(t.driveId,'') from Trip t    where t.tripState <>'Finish')")
    public List<WCSRobot> driverCanUse(@Param(value="robotId") String var1, @Param(value="sectionId") String var2);

    @Query(value=" select r from WCSRobot r  where r.available = true and r.status in (1,2,3)  and r.robotId = :robotId and r.robotId not in (   select coalesce(t.driveId,'') from Trip t   where t.tripState in :tripStates and t.driveId = :robotId) ")
    public WCSRobot getAvailableDrive(@Param(value="tripStates") List<String> var1, @Param(value="robotId") String var2);

    @Query(value="select r from WCSRobot r where r.addressCodeId = :addressCodeId and r.sectionId = :sectionId")
    public WCSRobot getByAddressCodeId(@Param(value="addressCodeId") int var1, @Param(value="sectionId") String var2);

    @Query(value="select r from WCSRobot r where (r.addressCodeId = :addressCodeId or r.targetAddrCodeId=:addressCodeId) and r.sectionId = :sectionId")
    public List<WCSRobot> getSleepAddrRobots(@Param(value="addressCodeId") int var1, @Param(value="sectionId") String var2);

    @Query(value=" select r from WCSRobot r  where r.laveBattery < :maxLaveBattery  and r.laveBattery > :minLaveBattery and r.sectionId=:sectionId  and r.status in (1,2,3)  and r.addressCodeId not in (select c.placeMark from Charger c where c.sectionId = :sectionId) and r.robotId not in (   select coalesce(t.driveId,'') from Trip t   where t.tripType = :tripType and t.tripState in :tripStates and t.sectionId = :sectionId)  order by r.laveBattery")
    public List<WCSRobot> getRobotsCanCharged(@Param(value="tripType") String var1, @Param(value="tripStates") List<String> var2, @Param(value="sectionId") String var3, @Param(value="minLaveBattery") int var4, @Param(value="maxLaveBattery") int var5);

    @Query(value=" select r from WCSRobot r  where (r.laveBattery <= :laveBattery or r.voltage <= :voltage) and r.sectionId=:sectionId  and r.status in (1,2,3)  and r.addressCodeId not in (select c.placeMark from Charger c where c.sectionId = :sectionId) and r.robotId not in (   select coalesce(t.driveId,'') from Trip t   where t.tripType = :tripType and t.tripState in :tripStates and t.sectionId = :sectionId)  order by r.laveBattery")
    public List<WCSRobot> getRobotsMustCharged(@Param(value="tripType") String var1, @Param(value="tripStates") List<String> var2, @Param(value="sectionId") String var3, @Param(value="voltage") int var4, @Param(value="laveBattery") int var5);

    @Query(value=" select r from WCSRobot r  where r.voltage <= :voltage and r.sectionId=:sectionId  and r.status in (1,2,3)  and r.addressCodeId not in (select c.placeMark from Charger c where c.sectionId = :sectionId) and r.robotId not in (   select coalesce(t.driveId,'') from Trip t   where t.tripType = :tripType and t.tripState in :tripStates and t.sectionId = :sectionId)  order by r.voltage")
    public List<WCSRobot> getRobotsVoltageMinValue(@Param(value="tripType") String var1, @Param(value="tripStates") List<String> var2, @Param(value="sectionId") String var3, @Param(value="voltage") int var4);
}

