/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.repository;

import com.mushiny.wms.application.domain.Trip;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface TripRepository
extends JpaRepository<Trip, String> {
    @Query(value="select r from Trip r where r.id=:tripId")
    public Trip getTripByID(@Param(value="tripId") String var1);

    @Query(value="select r from Trip r where r.tripType='EmptyRun' and r.tripState<> 'Finish' and r.sectionId = :sectionId and  r.endAddress=:addressCodeId  ")
    public List<Trip> getSleepAddrRobots(@Param(value="addressCodeId") int var1, @Param(value="sectionId") String var2);

    @Query(value=" select r from Trip r  where r.id =:tripId  and r.podId  in (   select r2.podId from Trip r2   where r2.tripState in :tripStates )")
    public Trip getAvailableTrip(@Param(value="tripStates") List<String> var1, @Param(value="tripId") String var2);

    @Query(value=" select r from Trip r  where r.sectionId=:sectionId and r.warehouseId=:warehouseId and r.tripType=:tripType and r.tripState in :tripStates")
    public List<Trip> getWorkStationTrip(@Param(value="tripStates") List<String> var1, @Param(value="sectionId") String var2, @Param(value="tripType") String var3, @Param(value="warehouseId") String var4);

    @Query(value=" select r from Trip r  where r.sectionId=:sectionId and r.warehouseId=:warehouseId and r.mdNodePosition=:mdNodePosition  and r.tripState not in :tripStates")
    public List<Trip> getWorkStationNotFinishTrip(@Param(value="tripStates") List<String> var1, @Param(value="sectionId") String var2, @Param(value="mdNodePosition") String var3, @Param(value="warehouseId") String var4);

    @Query(value=" select t from Trip t  where t.entityLock = 0  and t.tripType in :tripTypes  and t.tripState = :tripState  and t.sectionId = :sectionId order by t.createdDate ")
    public List<Trip> getAllNewTrips(@Param(value="tripTypes") List<String> var1, @Param(value="tripState") String var2, @Param(value="sectionId") String var3);

    @Query(value=" select t from Trip t  where t.entityLock = 0  and t.tripType not in :tripTypes  and t.tripState <>:tripState  and t.sectionId = :sectionId and t.driveId=:driveId")
    public List<Trip> getAllNotChargeTrips(@Param(value="tripTypes") List<String> var1, @Param(value="tripState") String var2, @Param(value="sectionId") String var3, @Param(value="driveId") String var4);

    @Query(value=" select t from Trip t  where t.entityLock = 0  and t.tripType not in :tripTypes  and t.tripState = :tripState  and t.sectionId = :sectionId")
    public List<Trip> getAllNotChargenNewTrips(@Param(value="tripTypes") List<String> var1, @Param(value="tripState") String var2, @Param(value="sectionId") String var3);

    @Query(value=" select t from Trip t  where t.entityLock = 0  and t.tripType ='EmptyRun' and t.driveId=:driveId  and t.tripState in :tripState  and t.sectionId = :sectionId order by t.createdDate ")
    public List<Trip> getAllEmptyRunTrips(@Param(value="driveId") String var1, @Param(value="tripState") List<String> var2, @Param(value="sectionId") String var3);

    @Query(value=" select t from Trip t  where t.entityLock = 0  and t.tripState in :tripState and t.podId=:podId and t.sectionId = :sectionId")
    public List<Trip> getTripsByPodId(@Param(value="tripState") List<String> var1, @Param(value="podId") String var2, @Param(value="sectionId") String var3);

    @Query(value=" select t from Trip t where t.podId  in  (select p.id from  Pod p where p.tarAddrcodeId=:addrcodeId and p.sectionId=:sectionId  ) and t.entityLock = 0  and t.tripState = :tripState   and t.sectionId = :sectionId ")
    public List<Trip> getTripsAddrcodeId(@Param(value="tripState") List<String> var1, @Param(value="addrcodeId") String var2, @Param(value="sectionId") String var3);

    @Query(value=" select t from Trip t  where t.chargerId = :chargerId and t.tripState in :tripStates")
    public Trip getByChargerId(@Param(value="chargerId") String var1, @Param(value="tripStates") List<String> var2);

    @Query(value=" select t from Trip t  where t.driveId = :driveId and  t.tripState in :tripStates")
    public Trip getByRobotId(@Param(value="driveId") String var1, @Param(value="tripStates") List<String> var2);

    @Query(value=" select t from Trip t  where t.sectionId = :sectionId and t.driveId is not null and t.tripState in :tripStates")
    public List<Trip> getAllocatedTrip(@Param(value="sectionId") String var1, @Param(value="tripStates") List<String> var2);

    @Query(value=" select t from Trip t  where t.sectionId = :sectionId and t.driveId=:driveId and t.tripState in :tripStates and t.tripType='ChargerDrive'")
    public List<Trip> getRobotChargeTrip(@Param(value="sectionId") String var1, @Param(value="driveId") String var2, @Param(value="tripStates") List<String> var3);

    @Query(value=" select t from Trip t  where t.driveId = :driveId and  t.tripState in :tripStates")
    public List<Trip> getAllByRobotId(@Param(value="driveId") String var1, @Param(value="tripStates") List<String> var2);

    @Query(value=" select t from Trip t  where t.podId = :podId  AND t.tripState<>'Finish'")
    public Trip getByPodIndex(@Param(value="podId") String var1);

    @Query(value="SELECT t from Trip t where t.driveId=:driveId and t.tripState<>'Finish'and t.tripType<>'ChargerDrive'and t.tripType<>'EmptyRun'")
    public Trip getByDriveId(@Param(value="driveId") String var1);
}

