/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.repository;

import com.mushiny.wms.application.domain.Pod;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface PodRepository
extends JpaRepository<Pod, String> {
    @Query(value=" select n from Pod n  where n.id in :podId ")
    public List<Pod> getPodById(@Param(value="podId") List<String> var1);

    @Query(value=" select n from Pod n  where n.id =:podId ")
    public Pod getPodById(@Param(value="podId") String var1);

    @Query(value=" select n from Pod n  where n.podIndex = :podIndex  and n.sectionId=:sectionId")
    public Pod getByPodIndex(@Param(value="podIndex") int var1, @Param(value="sectionId") String var2);

    @Query(value=" select n from Pod n  where n.podIndex = :podIndex ")
    public Pod getByPodIndex2(@Param(value="podIndex") int var1);

    @Query(value=" select n from Pod n  where n.name = :podName")
    public Pod getByPodName(@Param(value="podName") String var1);

    @Query(value=" select n from Pod n  where n.placeMark = :placeMark  and (n.state='Available' or n.state='Reserved') and n.sectionId=:sectionId")
    public List<Pod> getByAddressCodeId(@Param(value="placeMark") int var1, @Param(value="sectionId") String var2);

    @Query(value=" select n from Pod n  where n.placeMark=:placeMark and n.id in (select t.podId from Trip t where t.id=:tripId)")
    public List<Pod> getByTripId(@Param(value="tripId") String var1, @Param(value="placeMark") int var2);

    @Query(value=" select n from Pod n  where   n.tarAddrcodeId=:placeMark and n.sectionId=:sectionId and n.id in (select t.podId from Trip t where t.tripState in :tripState )")
    public List<Pod> getByTripTarAddrId(@Param(value="tripState") List<String> var1, @Param(value="placeMark") String var2, @Param(value="sectionId") String var3);

    @Query(value=" select n from Pod n  where   n.placeMark=:placeMark and n.sectionId=:sectionId and n.state='Available' and n.id not in (select t.podId from Trip t where t.tripState <>'Finish' )")
    public Pod getWorkStationTrip(@Param(value="placeMark") Integer var1, @Param(value="sectionId") String var2);

    @Query(value="SELECT MAX(p.POD_INDEX) FROM MD_POD p", nativeQuery=true)
    public Integer getMaxIndexOfPod();

    @Query(value=" select n from Pod n  where n.sectionId=:sectionId and n.state='Available' and n.id not in (select coalesce(t.podId,'')  from Trip t where t.tripState <>'Finish' ) and n.placeMark in (select distinct nod.addressCodeId from MdStationnodeposition n  left join n.stationnode sn  left join n.node nod  where sn.type =:stationType  ) ")
    public List<Pod> getPutBackPod(@Param(value="sectionId") String var1, @Param(value="stationType") Integer var2);

    @Query(value=" select n from Pod n  where n.sectionId=:sectionId and n.state='Available' and n.id not in (select coalesce(t.podId,'')  from Trip t where t.tripState <>'Finish' ) and n.placeMark in (select distinct nod.addressCodeId from MdStationnodeposition n  left join n.stationnode sn  left join n.node nod  where sn.type in :stationType  ) ")
    public List<Pod> getStationPod(@Param(value="sectionId") String var1, @Param(value="stationType") List<Integer> var2);
}

