/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.repository;

import com.mushiny.wms.application.domain.OutboundInstruct;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface OutboundInstructRepository
extends JpaRepository<OutboundInstruct, String> {
    @Query(value="SELECT \n  COUNT(t.ID) \nFROM\n  WMS_OUTBOUND_INSTRUCT t \nWHERE t.INV_ORG_ID = :INV_ORG_ID \n  AND t.BILL_NO = :BILL_NO \n  AND t.LABEL_NO = :LABEL_NO \n  AND t.MO_NAME = :MO_NAME \n  AND t.INV_CODE = :INV_CODE \n", nativeQuery=true)
    public Integer countOutboundInstruct(@Param(value="INV_ORG_ID") String var1, @Param(value="BILL_NO") String var2, @Param(value="LABEL_NO") String var3, @Param(value="INV_CODE") String var4, @Param(value="MO_NAME") String var5);

    default public Integer countOutboundInstruct(OutboundInstruct inboundInstruct) {
        if (inboundInstruct == null) {
            return 0;
        }
        return this.countOutboundInstruct(inboundInstruct.getINV_ORG_ID(), inboundInstruct.getBILL_NO(), inboundInstruct.getLABEL_NO(), inboundInstruct.getINV_CODE(), inboundInstruct.getMO_NAME());
    }

    @Query(value="select ii from  OutboundInstruct ii where ii.id=:instrsuctId and  ii.id in (select distinct ip.outboundInstruct.id from WmsInstructOutPosition ip where ip.STATUS   in :instrsuctStatus )")
    public List<OutboundInstruct> getInstru(@Param(value="instrsuctStatus") List<String> var1, @Param(value="instrsuctId") String var2);

    @Query(value="select ii from  OutboundInstruct ii where  ii.id not in (select distinct  rr.outboundInstruct.id from WmsInstructOutPosition rr where rr.STATUS  in :instrsuctStatus  ) and ii.id not in (select  coalesce(t.instruct,'')   from Trip t where t.tripState<>'Finish') and (ii.LINE_CODE=:station or ii.WORKCENTER_CODE=:station) order by  ii.DATE_REQ ASC ")
    public List<OutboundInstruct> getAllNotCreateTripInstru(@Param(value="instrsuctStatus") List<String> var1, @Param(value="station") String var2);

    @Query(value="select ii from  OutboundInstruct ii where ii.id  in (select  t.instruct  from Trip t where t.id=:tripId) ")
    public OutboundInstruct getInstruByTripId(@Param(value="tripId") String var1);

    @Query(value="select ii from  OutboundInstruct ii where ii.id=:instructId")
    public OutboundInstruct getInstruByInstructId(@Param(value="instructId") String var1);

    @Query(value="select ii from  OutboundInstruct ii where ii.INV_ORG_ID=:INV_ORG_ID and ii.BILL_TYPE=:BILL_TYPE and  ii.BILL_NO=:BILL_NO and ii.INV_CODE=:INV_CODE and ii.MO_NAME=:MO_NAME")
    public OutboundInstruct getInstruByCondition(@Param(value="INV_ORG_ID") String var1, @Param(value="BILL_TYPE") String var2, @Param(value="BILL_NO") String var3, @Param(value="INV_CODE") String var4, @Param(value="MO_NAME") String var5);

    @Query(value="select ii from  OutboundInstruct ii where ii.MES_ID=:MES_ID")
    public OutboundInstruct getInstruById(@Param(value="MES_ID") String var1);

    @Query(value="select ii from  OutboundInstruct ii where  ii.id not in (select distinct  rr.outboundInstruct.id from WmsInstructOutPosition rr where rr.STATUS  in :instrsuctStatus  ) and ii.id not in (select  coalesce(t.instruct,'')   from Trip t where t.tripState<>'Finish') and (ii.WORKCENTER_CODE=:station or ii.LINE_CODE=:station) order by  ii.DATE_REQ ASC ")
    public List<OutboundInstruct> getAllNotCreateTripSlamInstruct(@Param(value="instrsuctStatus") List<String> var1, @Param(value="station") String var2);
}

