/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.repository;

import com.mushiny.wms.application.domain.MapNode;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface MapNodeRepository
extends JpaRepository<MapNode, String> {
    @Query(value=" select n from MapNode n  where n.mapId = :mapId  and n.addressCodeId = :addressCodeId")
    public MapNode getByAddressCodeId(@Param(value="mapId") String var1, @Param(value="addressCodeId") int var2);

    @Query(value=" select n1 from MapNode n1 where n1.mapId=:mapId and n1.classGroup=:classGroupId  and n1.classValue=2 and n1.id <>:mapNodeId")
    public List<MapNode> getOutMapNodeByMapId(@Param(value="mapId") String var1, @Param(value="classGroupId") String var2, @Param(value="mapNodeId") String var3);

    @Query(value=" select n1 from MapNode n1 where n1.mapId=:mapId and n1.classGroup=:classGroupId and n1.classValue=1 and n1.id <>:mapNodeId")
    public List<MapNode> getInMapNodeByMapId(@Param(value="mapId") String var1, @Param(value="classGroupId") String var2, @Param(value="mapNodeId") String var3);

    @Query(value=" select n from MapNode n  where n.blocked = false  and n.mapId = :mapId  and n.type = 7 and n.addressCodeId not in (select r.addressCodeId from  WCSRobot r)")
    public List<MapNode> getByMapId(@Param(value="mapId") String var1);

    @Query(value=" select n from MapNode n  where n.blocked = false  and n.mapId = :mapId order by n.addressCodeId")
    public List<MapNode> getEmptyNode(@Param(value="mapId") String var1);

    @Query(value=" select n from MapNode n  where n.blocked = false  and n.mapId = :mapId order by n.addressCodeId")
    public List<MapNode> getHeavyNode(@Param(value="mapId") String var1);

    @Query(value=" select n from MapNode n  where n.mapId = :mapId  and n.addressCodeId = :addressCodeId")
    public MapNode getByMapIdAndAddressCodeId(@Param(value="mapId") String var1, @Param(value="addressCodeId") int var2);
}

