/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.repository;

import com.mushiny.wms.application.domain.InboundInstruct;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface InboundInstructRepository
extends JpaRepository<InboundInstruct, String> {
    @Query(value="SELECT \n  COUNT(t.ID) \nFROM\n  WMS_INBOUND_INSTRUCT t \nWHERE t.INV_ORG_ID = :INV_ORG_ID \n  AND t.BILL_NO = :BILL_NO \n  AND t.LABEL_NO = :LABEL_NO \n  AND t.MO_NAME = :MO_NAME \n  AND t.INV_CODE = :INV_CODE \n", nativeQuery=true)
    public Integer countInboundInstruct(@Param(value="INV_ORG_ID") String var1, @Param(value="BILL_NO") String var2, @Param(value="LABEL_NO") String var3, @Param(value="INV_CODE") String var4, @Param(value="MO_NAME") String var5);

    default public Integer countInboundInstruct(InboundInstruct inboundInstruct) {
        if (inboundInstruct == null) {
            return 0;
        }
        return this.countInboundInstruct(inboundInstruct.getINV_ORG_ID(), inboundInstruct.getBILL_NO(), inboundInstruct.getLABEL_NO(), inboundInstruct.getINV_CODE(), inboundInstruct.getMO_NAME());
    }

    @Query(value="select ii from  InboundInstruct ii where ii.id not in (select distinct ip.inboundInstruct.id from WmsInstructInPosition ip where ip.STATUS   in :instrsuctStatus ) and ii.id not in (select  coalesce(t.instruct,'')   from Trip t  where t.tripState<>'Finish') order by  ii.DATE_REQ ASC ")
    public List<InboundInstruct> getAllNotCreateTripInstru(@Param(value="instrsuctStatus") List<String> var1);

    @Query(value="select ii from  InboundInstruct ii where ii.id=:instrsuctId and  ii.id in (select distinct ip.inboundInstruct.id from WmsInstructInPosition ip where ip.STATUS   in :instrsuctStatus )")
    public List<InboundInstruct> getInstru(@Param(value="instrsuctStatus") List<String> var1, @Param(value="instrsuctId") String var2);

    @Query(value="select ii from  InboundInstruct ii where ii.id  in (select  t.instruct from Trip t where t.id=:tripId) ")
    public InboundInstruct getInstruByTripId(@Param(value="tripId") String var1);

    @Query(value="select ii from  InboundInstruct ii where ii.id=:instructId")
    public InboundInstruct getInstruById(@Param(value="instructId") String var1);

    @Query(value="select ii from  InboundInstruct ii where ii.INV_ORG_ID=:INV_ORG_ID and ii.BILL_TYPE=:BILL_TYPE and  ii.BILL_NO=:BILL_NO and ii.LABEL_NO=:LABEL_NO and ii.INV_CODE=:INV_CODE and ii.MO_NAME=:MO_NAME")
    public InboundInstruct getInstruByCondition(@Param(value="INV_ORG_ID") String var1, @Param(value="BILL_TYPE") String var2, @Param(value="BILL_NO") String var3, @Param(value="LABEL_NO") String var4, @Param(value="INV_CODE") String var5, @Param(value="MO_NAME") String var6);

    @Query(value="select ii from  InboundInstruct ii where ii.MES_ID=:MES_ID")
    public InboundInstruct getInstruByMesId(@Param(value="MES_ID") String var1);

    @Query(value="select ii from  InboundInstruct ii where ii.INV_ORG_ID=:INV_ORG_ID and ii.BILL_TYPE=:BILL_TYPE and  ii.BILL_NO=:BILL_NO and ii.INV_CODE=:INV_CODE and ii.MO_NAME=:MO_NAME")
    public InboundInstruct getInstruByCondition(@Param(value="INV_ORG_ID") String var1, @Param(value="BILL_TYPE") String var2, @Param(value="BILL_NO") String var3, @Param(value="INV_CODE") String var4, @Param(value="MO_NAME") String var5);

    @Query(value="update  WMS_INBOUND_INSTRUCT oi set oi.WORKCENTER_CODE=:WORKCENTER_CODE ,oi.CAR_NO=:CAR_NO, oi.LOCATION_NO=:LOCATION_NO,oi.DATETIME_STOCK=:DATETIME_STOCK,oi.STATUS=:STATUS where oi.INV_ORG_ID=:INV_ORG_ID and oi.BILL_TYPE=:BILL_TYPE and  oi.BILL_NO=:BILL_NO and oi.LABEL_NO=:LABEL_NO and oi.INV_CODE=:INV_CODE and oi.MO_NAME=:MO_NAME", nativeQuery=true)
    public Integer updateInstruByCondition(@Param(value="INV_ORG_ID") String var1, @Param(value="BILL_TYPE") String var2, @Param(value="BILL_NO") String var3, @Param(value="LABEL_NO") String var4, @Param(value="INV_CODE") String var5, @Param(value="MO_NAME") String var6);
}

