/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.rabbitMq;

import com.mushiny.wms.application.config.RestTempConfig;
import com.mushiny.wms.application.domain.InboundInstruct;
import com.mushiny.wms.application.domain.MdStationnodeposition;
import com.mushiny.wms.application.domain.OutboundInstruct;
import com.mushiny.wms.application.domain.Pod;
import com.mushiny.wms.application.domain.Trip;
import com.mushiny.wms.application.domain.WmsInstructInPosition;
import com.mushiny.wms.application.domain.WmsInstructOutPosition;
import com.mushiny.wms.application.domain.enums.TripType;
import com.mushiny.wms.application.repository.InboundInstructRepository;
import com.mushiny.wms.application.repository.MdStationnodepositionRepository;
import com.mushiny.wms.application.repository.OutboundInstructRepository;
import com.mushiny.wms.application.repository.PodRepository;
import com.mushiny.wms.application.repository.TripRepository;
import com.mushiny.wms.application.repository.WmsInstructInPositionRepository;
import com.mushiny.wms.application.repository.WmsInstructOutPositionRepository;
import com.mushiny.wms.common.utils.DateTimeUtil;
import com.mushiny.wms.common.utils.JSONUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class RabbitMqReceiver {
    private static Logger LOGGER = LoggerFactory.getLogger(RabbitMqReceiver.class);
    @Autowired
    private RestTempConfig restTempConfig;
    @Autowired
    private TripRepository tripRepository;
    @Autowired
    private MdStationnodepositionRepository mdStationnodepositionRepository;
    @Autowired
    private InboundInstructRepository inboundInstructRepository;
    @Autowired
    private OutboundInstructRepository outboundInstructRepository;
    @Autowired
    private WmsInstructInPositionRepository wmsInstructInPositionRepository;
    @Autowired
    private WmsInstructOutPositionRepository wmsInstructOutPositionRepository;
    @Autowired
    private PodRepository podRepository;

    public void test(Map param) {
        HashMap<String, String> message = new HashMap<String, String>();
        String tripType = "" + param.get("tripType");
        String tripId = "" + param.get("tripId");
        message.put("tripType", tripType);
        message.put("tripId", tripId);
        if (TripType.ANNTO_MVIN.getName().equalsIgnoreCase(tripType) || TripType.FINISHESWAREHOUSING.getName().equalsIgnoreCase(tripType)) {
            message.put("driverId", "" + param.get("driverId"));
            message.put("instructStatus", "" + param.get("instructStatus"));
            message.put("targetAddress", "" + param.get("targetAddress"));
        } else if (TripType.ANNTOMVOUT.getName().equalsIgnoreCase(tripType) || TripType.LMGETMATERIAL.getName().equalsIgnoreCase(tripType)) {
            message.put("driverId", "" + param.get("driverId"));
            message.put("instructStatus", "" + param.get("instructStatus"));
            message.put("sourceAddress", "" + param.get("sourceAddress"));
            message.put("podIndex", "" + param.get("podIndex"));
        } else if (TripType.CARRY_POD.getName().equalsIgnoreCase(tripType)) {
            message.put("driverId", "" + param.get("driverId"));
            message.put("podIndex", "" + param.get("podIndex"));
        }
        this.receiveMapMessage(message);
    }

    public Map createInstructCallBackParam(String tripType, Object instruct, Map addParam) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (TripType.ANNTO_MVIN.getName().equalsIgnoreCase(tripType) || TripType.FINISHESWAREHOUSING.getName().equalsIgnoreCase(tripType)) {
            InboundInstruct inboundInstruct = (InboundInstruct)instruct;
            param.put("ID", inboundInstruct.getMES_ID());
            param.put("INV_ORG_ID", inboundInstruct.getINV_ORG_ID());
            param.put("BILL_TYPE", inboundInstruct.getBILL_TYPE());
            param.put("BILL_NO", inboundInstruct.getBILL_NO());
            param.put("LABEL_NO", inboundInstruct.getLABEL_NO());
            param.put("INV_CODE", inboundInstruct.getINV_CODE());
            param.put("LOC_CODE", addParam.get("targetAddress"));
            param.put("CAR_NO", addParam.get("driverId"));
            param.put("DATETIME_STOCK", addParam.get("datetimeStock"));
            param.put("STATUS", addParam.get("instructStatus"));
        } else if (TripType.ANNTOMVOUT.getName().equalsIgnoreCase(tripType) || TripType.LMGETMATERIAL.getName().equalsIgnoreCase(tripType)) {
            OutboundInstruct outboundInstruct = (OutboundInstruct)instruct;
            param.put("ID", outboundInstruct.getMES_ID());
            param.put("INV_ORG_ID", outboundInstruct.getINV_ORG_ID());
            param.put("BILL_TYPE", outboundInstruct.getBILL_TYPE());
            param.put("BILL_NO", outboundInstruct.getBILL_NO());
            param.put("LABEL_NO", outboundInstruct.getLABEL_NO());
            param.put("INV_CODE", outboundInstruct.getINV_CODE());
            param.put("STOCK_QTY", outboundInstruct.getQTY());
            param.put("STORAGE_NO_L", addParam.get("podName"));
            param.put("CAR_NO", addParam.get("driverId"));
            param.put("LOC_CODE", addParam.get("sourceAddress"));
            param.put("DATETIME_STOCK", addParam.get("datetimeStock"));
            param.put("STATUS", addParam.get("instructStatus"));
        }
        return param;
    }

    @RabbitListener(queues={"InstructAck"})
    public void receiveMapMessage(Map message) {
        try {
            LOGGER.info("\u5de5\u4f5c\u7ad9\u63a8\u9001\u8fc7\u6765\u662f\u6d88\u606f:" + JSONUtil.toJSon((Object)message));
            String tripId = message.get("tripId") + "";
            String tripType = message.get("tripType") + "";
            Trip trip = this.tripRepository.getTripByID(tripId);
            MdStationnodeposition position = this.mdStationnodepositionRepository.getMdStationnodepositionById(trip.getMdNodePosition());
            TripType tt = TripType.parserTripType((String)tripType);
            if (tt == TripType.ANNTO_MVIN || tt == TripType.FINISHESWAREHOUSING) {
                String instructStatus = message.get("instructStatus") + "";
                String driverId = message.get("driverId") + "";
                String targetAddress = message.get("targetAddress") + "";
                InboundInstruct inboundInstruct = this.inboundInstructRepository.getInstruByTripId(tripId);
                if (!ObjectUtils.isEmpty((Object)inboundInstruct)) {
                    HashMap<String, String> param = new HashMap<String, String>();
                    param.put("targetAddress", targetAddress);
                    param.put("driverId", driverId);
                    param.put("instructStatus", instructStatus);
                    String datetimeStock = DateTimeUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
                    param.put("datetimeStock", datetimeStock);
                    Map callParam = this.createInstructCallBackParam(tripType, (Object)inboundInstruct, param);
                    this.restTempConfig.inBoundAck(callParam);
                    WmsInstructInPosition iip = new WmsInstructInPosition();
                    iip.setInboundInstruct(inboundInstruct);
                    iip.setCAR_NO(driverId);
                    iip.setDATETIME_STOCK((Date)DateTimeUtil.strToTimeStamp((String)datetimeStock));
                    iip.setLOC_CODE(targetAddress);
                    iip.setSTATUS(instructStatus);
                    iip = (WmsInstructInPosition)this.wmsInstructInPositionRepository.saveAndFlush((Object)iip);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("\u4fdd\u5b58\u5165\u5e93\u6307\u4ee4\u72b6\u6001\u6210\u529f\n{}", (Object)JSONUtil.toJSon((Object)iip));
                    }
                } else {
                    LOGGER.error("\u672a\u627e\u5230trip {} \u5bf9\u5e94\u7684\u6307\u4ee4", (Object)tripId);
                }
            } else if (tt == TripType.ANNTOMVOUT || tt == TripType.LMGETMATERIAL) {
                String instructStatus = message.get("instructStatus") + "";
                String driverId = "" + message.get("driverId");
                String sourceAddress = "" + message.get("sourceAddress");
                String podName = this.podRepository.getPodById(message.get("podIndex") + "").getName();
                OutboundInstruct outboundInstruct = this.outboundInstructRepository.getInstruByTripId(tripId);
                if (!ObjectUtils.isEmpty((Object)outboundInstruct)) {
                    HashMap<String, String> param = new HashMap<String, String>();
                    String datetimeStock = DateTimeUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
                    param.put("podName", podName);
                    param.put("driverId", driverId);
                    param.put("sourceAddress", sourceAddress);
                    param.put("datetimeStock", datetimeStock);
                    param.put("instructStatus", instructStatus);
                    Map callParam = this.createInstructCallBackParam(tripType, (Object)outboundInstruct, param);
                    this.restTempConfig.outBoundAck(callParam);
                    WmsInstructOutPosition iop = new WmsInstructOutPosition();
                    iop.setCAR_NO(driverId);
                    iop.setDATETIME_STOCK((Date)DateTimeUtil.strToTimeStamp((String)datetimeStock));
                    iop.setOutboundInstruct(outboundInstruct);
                    iop.setSTATUS(instructStatus);
                    iop.setSTOCK_QTY(outboundInstruct.getQTY().toString());
                    iop.setLOC_CODE(sourceAddress);
                    iop = (WmsInstructOutPosition)this.wmsInstructOutPositionRepository.saveAndFlush((Object)iop);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("\u4fdd\u5b58\u51fa\u5e93\u6307\u4ee4\u72b6\u6001\u6210\u529f\n{}", (Object)JSONUtil.toJSon((Object)iop));
                    }
                } else {
                    LOGGER.error("\u672a\u627e\u5230trip {} \u5bf9\u5e94\u7684\u6307\u4ee4", (Object)tripId);
                }
            } else if (tt == TripType.CARRY_POD) {
                HashMap<String, String> reposeParam = new HashMap<String, String>();
                reposeParam.put("INV_ORG_ID", "200124");
                reposeParam.put("WORKCENTER_CODE", position.getStationnode().getName());
                Pod pod = this.podRepository.getPodById(message.get("podIndex") + "");
                if ("left".equalsIgnoreCase(position.getDirection())) {
                    reposeParam.put("STORAGE_NO_L", pod.getName());
                    reposeParam.put("STORAGE_NO_R", "");
                    reposeParam.put("DATETIME_UPDATED", DateTimeUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                } else {
                    reposeParam.put("STORAGE_NO_R", pod.getName());
                    reposeParam.put("STORAGE_NO_L", "");
                    reposeParam.put("DATETIME_UPDATED", DateTimeUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                this.restTempConfig.inBoundBindPodAck(reposeParam);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void receiveMapMessage2(Map message) {
        try {
            LOGGER.info("\u6a21\u62df\u6d4b\u8bd5\u63a8\u9001\u8fc7\u6765\u662f\u6d88\u606f:" + JSONUtil.toJSon((Object)message));
            String instructId = message.get("instructId") + "";
            String tripType = message.get("tripType") + "";
            TripType tt = TripType.parserTripType((String)tripType);
            if (tt == TripType.ANNTO_MVIN || tt == TripType.FINISHESWAREHOUSING) {
                String instructStatus = message.get("instructStatus") + "";
                String driverId = message.get("driverId") + "";
                String targetAddress = message.get("targetAddress") + "";
                InboundInstruct inboundInstruct = this.inboundInstructRepository.getInstruById(instructId);
                if (!ObjectUtils.isEmpty((Object)inboundInstruct)) {
                    HashMap<String, String> param = new HashMap<String, String>();
                    param.put("targetAddress", targetAddress);
                    param.put("driverId", driverId);
                    param.put("instructStatus", instructStatus);
                    String datetimeStock = DateTimeUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
                    param.put("datetimeStock", datetimeStock);
                    Map callParam = this.createInstructCallBackParam(tripType, (Object)inboundInstruct, param);
                    this.restTempConfig.inBoundAck(callParam);
                    WmsInstructInPosition iip = new WmsInstructInPosition();
                    iip.setInboundInstruct(inboundInstruct);
                    iip.setCAR_NO(driverId);
                    iip.setDATETIME_STOCK((Date)DateTimeUtil.strToTimeStamp((String)datetimeStock));
                    iip.setLOC_CODE(targetAddress);
                    iip.setSTATUS(instructStatus);
                    iip = (WmsInstructInPosition)this.wmsInstructInPositionRepository.saveAndFlush((Object)iip);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("\u4fdd\u5b58\u5165\u5e93\u6307\u4ee4\u72b6\u6001\u6210\u529f\n{}", (Object)JSONUtil.toJSon((Object)iip));
                    }
                } else {
                    LOGGER.error("\u672a\u627e\u5230trip {} \u5bf9\u5e94\u7684\u6307\u4ee4", (Object)instructId);
                }
            } else if (tt == TripType.ANNTOMVOUT || tt == TripType.LMGETMATERIAL) {
                String instructStatus = message.get("instructStatus") + "";
                String driverId = "" + message.get("driverId");
                String sourceAddress = "" + message.get("sourceAddress");
                String podName = message.get("podIndex") + "";
                OutboundInstruct outboundInstruct = this.outboundInstructRepository.getInstruByInstructId(instructId);
                if (!ObjectUtils.isEmpty((Object)outboundInstruct)) {
                    HashMap<String, String> param = new HashMap<String, String>();
                    String datetimeStock = DateTimeUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
                    param.put("podName", podName);
                    param.put("driverId", driverId);
                    param.put("sourceAddress", sourceAddress);
                    param.put("datetimeStock", datetimeStock);
                    param.put("instructStatus", instructStatus);
                    Map callParam = this.createInstructCallBackParam(tripType, (Object)outboundInstruct, param);
                    this.restTempConfig.outBoundAck(callParam);
                    WmsInstructOutPosition iop = new WmsInstructOutPosition();
                    iop.setCAR_NO(driverId);
                    iop.setDATETIME_STOCK((Date)DateTimeUtil.strToTimeStamp((String)datetimeStock));
                    iop.setOutboundInstruct(outboundInstruct);
                    iop.setSTATUS(instructStatus);
                    iop.setSTOCK_QTY(outboundInstruct.getQTY().toString());
                    iop = (WmsInstructOutPosition)this.wmsInstructOutPositionRepository.saveAndFlush((Object)iop);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("\u4fdd\u5b58\u51fa\u5e93\u6307\u4ee4\u72b6\u6001\u6210\u529f\n{}", (Object)JSONUtil.toJSon((Object)iop));
                    }
                } else {
                    LOGGER.error("\u672a\u627e\u5230trip {} \u5bf9\u5e94\u7684\u6307\u4ee4", (Object)instructId);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

