/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.rabbitMq;

import com.mushiny.wms.common.utils.JSONUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RabbitMessageSender
implements RabbitTemplate.ConfirmCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(RabbitMessageSender.class);
    private String EXCHANGE = "exchange_other";
    private String routingKey = "WMS_WCS_POD_ADD_REMOVE";
    private RabbitTemplate rabbitTemplate;

    @Autowired
    public RabbitMessageSender(RabbitTemplate rabbitTemplate) {
        this.rabbitTemplate = rabbitTemplate;
    }

    public void sendMessage(Map msg, String exchange, String rout) {
        LOGGER.debug("\u5f00\u59cb\u53d1\u9001pod\u66f4\u65b0{}", (Object)JSONUtil.toJSon((Object)msg));
        try {
            this.rabbitTemplate.convertAndSend(exchange, rout, (Object)msg);
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u9001pod\u66f4\u65b0\u5931\u8d25,\u5f02\u5e38\u4fe1\u606f\u4e3a{}", (Object)msg, (Object)e.getMessage());
        }
    }

    public void confirm(CorrelationData correlationData, boolean ack, String cause) {
        System.out.println(" \u56de\u8c03id:" + correlationData);
        if (ack) {
            System.out.println("\u6d88\u606f\u6210\u529f\u6d88\u8d39");
        } else {
            System.out.println("\u6d88\u606f\u6d88\u8d39\u5931\u8d25:" + cause);
        }
    }
}

