/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.config;

import com.mushiny.wms.common.utils.EntityManagerUtil;
import com.mushiny.wms.common.utils.JSONUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RestTempConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestTempConfig.class);
    @Value(value="${midea.webApi.instructIn.callBack}")
    private String instructInCallBack;
    @Value(value="${midea.webApi.instructOut.callBack}")
    private String instructOutCallBack;
    @Value(value="${midea.webApi.RFID.callBack}")
    private String rFIDCallBack;
    @Value(value="${midea.webApi.invMitemLabelSyn}")
    private String invMitemLabelSyn;
    @Value(value="${midea.webApi.sfcMitemSyn}")
    private String sfcMitemSyn;
    @Value(value="${mushiny.debug}")
    private Boolean debug = false;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private EntityManagerUtil entityManagerUtil;

    @Bean
    public RestTemplate createRestTemplate() {
        RestTemplateBuilder rb = new RestTemplateBuilder(new RestTemplateCustomizer[0]);
        return rb.build();
    }

    public String sfcMitemSyn(Map param) {
        LOGGER.debug("\u8bf7\u6c42\u5730\u5740{} \u53c2\u6570{}", (Object)this.sfcMitemSyn, (Object)JSONUtil.mapToJSon((Map)param));
        String respose = (String)this.restTemplate.getForObject(this.sfcMitemSyn, String.class, param);
        LOGGER.debug("\u8bf7\u6c42\u5730\u5740{} \u53c2\u6570{} \u8fd4\u56de{}", new Object[]{this.sfcMitemSyn, JSONUtil.mapToJSon((Map)param), respose});
        return respose;
    }

    public String invMitemLabelSyn(Map param) {
        long begain = System.currentTimeMillis();
        LOGGER.debug("\u8bf7\u6c42\u5730\u5740{} \u53c2\u6570{}", (Object)this.invMitemLabelSyn, (Object)JSONUtil.mapToJSon((Map)param));
        String respose = (String)this.restTemplate.getForObject(this.invMitemLabelSyn, String.class, param);
        long end = System.currentTimeMillis();
        int time = (int)((end - begain) / 1000L);
        LOGGER.debug("\u8fd4\u56de\u7528\u65f6 {}", new Object[]{time, this.invMitemLabelSyn, JSONUtil.mapToJSon((Map)param), respose});
        return respose;
    }

    public Map inBoundBindPodAck(Map param) {
        LOGGER.debug("\u8bf7\u6c42\u5730\u5740{} \u53c2\u6570{}", (Object)this.rFIDCallBack, (Object)JSONUtil.mapToJSon((Map)param));
        Map<String, Boolean> respose = null;
        if (!this.debug.booleanValue()) {
            try {
                respose = (Map)this.restTemplate.getForObject(this.rFIDCallBack, Map.class, param);
            }
            catch (RestClientException e) {
                LOGGER.error("\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u51fa\u9519:" + this.rFIDCallBack, (Throwable)e);
                respose = new HashMap();
                respose.put("IsSucess", false);
                respose.put("ErrorCode", (Boolean)((Object)Integer.valueOf(1)));
                respose.put("ErrorMessage", (Boolean)((Object)"\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u51fa\u9519"));
            }
        } else {
            respose = new HashMap<String, Boolean>();
            respose.put("IsSucess", true);
            respose.put("ErrorCode", (Boolean)((Object)Integer.valueOf(0)));
            respose.put("ErrorMessage", null);
        }
        LOGGER.debug("\u8bf7\u6c42\u5730\u5740{} \u8fd4\u56de{}", (Object)this.rFIDCallBack, (Object)JSONUtil.mapToJSon(respose));
        return respose;
    }

    public Map inBoundAck(Map data) {
        LOGGER.debug("\u8bf7\u6c42\u5730\u5740{} \u53c2\u6570{}", (Object)this.instructInCallBack, (Object)JSONUtil.mapToJSon((Map)data));
        Map<String, Boolean> respose = null;
        if (!this.debug.booleanValue()) {
            try {
                respose = (Map)this.restTemplate.getForObject(this.instructInCallBack, Map.class, data);
            }
            catch (Exception e) {
                LOGGER.error("\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u51fa\u9519:" + this.instructInCallBack, (Throwable)e);
                respose = new HashMap();
                respose.put("IsSucess", false);
                respose.put("ErrorCode", (Boolean)((Object)Integer.valueOf(1)));
                respose.put("ErrorMessage", (Boolean)((Object)"\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u51fa\u9519"));
            }
        } else {
            respose = new HashMap<String, Boolean>();
            respose.put("IsSucess", true);
            respose.put("ErrorCode", (Boolean)((Object)Integer.valueOf(0)));
            respose.put("ErrorMessage", null);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u8c03\u7528\u5165\u5e93\u6307\u4ee4\u56de\u4f20\u63a5\u53e3{} \n\u53c2\u6570{} \n\u8fd4\u56de\u7ed3\u679c{}", new Object[]{this.instructInCallBack, JSONUtil.mapToJSon((Map)data), JSONUtil.mapToJSon(respose)});
        }
        return respose;
    }

    public Map outBoundAck(Map data) {
        LOGGER.debug("\u8bf7\u6c42\u5730\u5740{} \u53c2\u6570{}", (Object)this.instructOutCallBack, (Object)JSONUtil.mapToJSon((Map)data));
        Map<String, Boolean> respose = null;
        if (!this.debug.booleanValue()) {
            try {
                respose = (Map)this.restTemplate.getForObject(this.instructOutCallBack, Map.class, data);
            }
            catch (RestClientException e) {
                LOGGER.error("\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u51fa\u9519:" + this.instructOutCallBack, (Throwable)e);
                respose = new HashMap();
                respose.put("IsSucess", false);
                respose.put("ErrorCode", (Boolean)((Object)Integer.valueOf(1)));
                respose.put("ErrorMessage", (Boolean)((Object)"\u8c03\u7528\u7b2c\u4e09\u65b9\u63a5\u53e3\u51fa\u9519"));
            }
        } else {
            respose = new HashMap<String, Boolean>();
            respose.put("IsSucess", true);
            respose.put("ErrorCode", (Boolean)((Object)Integer.valueOf(0)));
            respose.put("ErrorMessage", null);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u8c03\u7528\u51fa\u5e93\u6307\u4ee4\u56de\u4f20\u63a5\u53e3{} \n\u53c2\u6570{} \n\u8fd4\u56de\u7ed3\u679c{}", new Object[]{this.instructOutCallBack, JSONUtil.mapToJSon((Map)data), JSONUtil.mapToJSon(respose)});
        }
        return respose;
    }
}

