/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnBean(value={Environment.class})
public class RabbitConfig {
    private static Logger LOGGER = LoggerFactory.getLogger(RabbitConfig.class);
    @Autowired
    private Environment environment;

    @Bean
    public ConnectionFactory connectionFactory() {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory();
        connectionFactory.setAddresses(this.environment.getProperty("spring.rabbitmq.host"));
        connectionFactory.setPort(Integer.parseInt(this.environment.getProperty("spring.rabbitmq.port")));
        connectionFactory.setUsername(this.environment.getProperty("spring.rabbitmq.username"));
        connectionFactory.setPassword(this.environment.getProperty("spring.rabbitmq.password"));
        connectionFactory.setVirtualHost(this.environment.getProperty("spring.rabbitmq.virtualhost"));
        connectionFactory.setPublisherConfirms(true);
        StringBuilder sb = new StringBuilder();
        sb.append("\u5730\u5740:" + this.environment.getProperty("spring.rabbitmq.host"));
        sb.append("\u7aef\u53e3:" + this.environment.getProperty("spring.rabbitmq.port"));
        sb.append("\u7528\u6237:" + this.environment.getProperty("spring.rabbitmq.username"));
        sb.append("virtualhost:" + this.environment.getProperty("spring.rabbitmq.virtualhost"));
        LOGGER.info("rabbit mq \u7684\u8fde\u63a5\u4fe1\u606f\u4e3a\n" + sb.toString());
        return connectionFactory;
    }

    @Bean
    @Scope(value="prototype")
    public RabbitTemplate rabbitTemplate() {
        RabbitTemplate template = new RabbitTemplate(this.connectionFactory());
        return template;
    }
}

