/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.config;

import com.mushiny.wms.application.business.dto.SectionMapNode;
import com.mushiny.wms.application.domain.Map;
import com.mushiny.wms.application.domain.MapNode;
import com.mushiny.wms.application.repository.MapNodeRepository;
import com.mushiny.wms.application.repository.MapRepository;
import com.mushiny.wms.common.exception.ApiException;
import com.mushiny.wms.common.exception.ExceptionEnum;
import com.mushiny.wms.common.utils.JSONUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
@Order(value=1)
public class MapNodeConfig
implements CommandLineRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapNodeConfig.class);
    public static java.util.Map<String, List<SectionMapNode>> sectionMapNodes = new HashMap();
    @Autowired
    private MapNodeRepository mapNodeRepository;
    @Autowired
    private MapRepository mapRepository;

    private void init(List<SectionMapNode> sectionMapNodes, Map map, MapNode mapNode, List<MapNode> mapNodes) {
        SectionMapNode sectionMapNode = new SectionMapNode();
        sectionMapNode.setCurrentMapNode(mapNode);
        sectionMapNode.setMap(map);
        String classGroup = mapNode.getClassGroup();
        String mapId = map.getId();
        if (!StringUtils.isEmpty((Object)classGroup)) {
            int classValue = mapNode.getClassValue();
            if (classValue == 1) {
                sectionMapNode.setInAddress(true);
                sectionMapNode.setOutSizeMapNodes(this.searchOutsizeMapNode(mapId, mapNodes, classGroup, 2));
            } else if (classValue == 2) {
                sectionMapNode.setInAddress(false);
                sectionMapNode.setInSizeMapNodes(this.searchOutsizeMapNode(mapId, mapNodes, classGroup, 1));
            } else {
                throw new ApiException(ExceptionEnum.EX_MAP_CLASSVALUE_NOT_LEGAL.name());
            }
        }
        sectionMapNodes.add(sectionMapNode);
    }

    private List<MapNode> searchOutsizeMapNode(String mapId, List<MapNode> mapNodes, String classGroup, int classValue) {
        ArrayList<MapNode> result = new ArrayList<MapNode>();
        for (MapNode temp : mapNodes) {
            if (StringUtils.isEmpty((Object)temp.getClassGroup()) || !temp.getClassGroup().equals(classGroup) || temp.getClassValue() != classValue || !temp.getMapId().equals(mapId)) continue;
            result.add(temp);
            break;
        }
        return result;
    }

    public void run(String ... args) throws Exception {
        LOGGER.debug("\u5f00\u59cb\u52a0\u8f7d\u5730\u56fe.....");
        List mapNodes = this.mapNodeRepository.findAll();
        List maps = this.mapRepository.findAllMap();
        for (Map map : maps) {
            for (MapNode mapNode : mapNodes) {
                String mapId = map.getId();
                String mapNodeMapId = mapNode.getMapId();
                String sectionId = map.getSectionId();
                if (!mapId.equals(mapNodeMapId)) continue;
                if (!sectionMapNodes.containsKey(sectionId)) {
                    ArrayList sectionMapNodeTemp = new ArrayList();
                    this.init(sectionMapNodeTemp, map, mapNode, mapNodes);
                    sectionMapNodes.put(sectionId, sectionMapNodeTemp);
                    continue;
                }
                this.init((List)sectionMapNodes.get(sectionId), map, mapNode, mapNodes);
            }
        }
        LOGGER.debug("\u5730\u56fe\u4fe1\u606f\n{}", (Object)JSONUtil.toJSon((Object)sectionMapNodes));
    }

    public static SectionMapNode findSectionMapNode(int addrCode, String sectionId) {
        SectionMapNode result = null;
        List sectionMapNodesTemp = (List)sectionMapNodes.get(sectionId);
        if (!CollectionUtils.isEmpty((java.util.Map)sectionMapNodes) && !CollectionUtils.isEmpty((Collection)sectionMapNodesTemp)) {
            for (SectionMapNode sectionMapNode : sectionMapNodesTemp) {
                if (sectionMapNode.getCurrentMapNode().getAddressCodeId() != addrCode) continue;
                result = sectionMapNode;
                break;
            }
        }
        return result;
    }
}

