/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.business.trip;

import com.mushiny.wms.application.business.common.CommonBusiness;
import com.mushiny.wms.application.business.dto.DrivePodScore;
import com.mushiny.wms.application.business.score.DrivePodScoreBusiness;
import com.mushiny.wms.application.domain.Section;
import com.mushiny.wms.application.domain.Trip;
import com.mushiny.wms.application.domain.WCSRobot;
import com.mushiny.wms.application.domain.enums.TripState;
import com.mushiny.wms.application.repository.TripRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public abstract class TripHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TripHandler.class);
    public final CommonBusiness commonBusiness;
    public final TripRepository tripRepository;
    public final DrivePodScoreBusiness drivePodScoreBusiness;
    protected TripHandler handler = null;
    public static List<String> allocated = new ArrayList();

    public TripHandler(CommonBusiness commonBusiness, TripRepository tripRepository, DrivePodScoreBusiness drivePodScoreBusiness) {
        this.commonBusiness = commonBusiness;
        this.tripRepository = tripRepository;
        this.drivePodScoreBusiness = drivePodScoreBusiness;
    }

    public List<WCSRobot> getAvailableDrives(String sectionId) {
        List robots = this.commonBusiness.getAvailableDrives(sectionId);
        return robots;
    }

    public List<DrivePodScore> getDrivePodScores(Trip trip, List<WCSRobot> robots) {
        List podScores = this.drivePodScoreBusiness.getDrivePodScores(trip, robots);
        return podScores;
    }

    public boolean saveTrip(Trip trip, List<WCSRobot> robots) {
        boolean result = false;
        List drivePodScores = this.drivePodScoreBusiness.getDrivePodScores(trip, robots);
        if (drivePodScores.isEmpty()) {
            return result;
        }
        int driverSize = robots.size();
        for (int m = 0; m < driverSize; ++m) {
            String driverId = ((DrivePodScore)drivePodScores.get(m)).getDriveId();
            try {
                boolean driveCanUse = this.commonBusiness.checkingDriveCanUse(driverId, trip);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("\u53ef\u4ee5\u7ed9\u8c03\u5ea6\u5355{} \u5206\u914d\u5c0f\u8f66 {} {} ", new Object[]{trip.getId(), driverId, driveCanUse});
                }
                if (!driveCanUse || allocated.contains(driverId)) continue;
                trip.setDriveId(driverId);
                trip.setTripState(TripState.AVAILABLE.getName());
                this.tripRepository.saveAndFlush((Object)trip);
                result = true;
                allocated.add(driverId);
                break;
            }
            catch (Exception e) {
                LOGGER.error("\u7ed9\u8c03\u5ea6\u5355" + trip.getId() + "\u5206\u914d\u8f66" + driverId + "\u5931\u8d25" + e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        return result;
    }

    public List<Trip> filterHandlerTrip(List<Trip> trips, String ... tripTypes) {
        ArrayList<Trip> result = new ArrayList<Trip>();
        List<String> tripTypeTemp = Arrays.asList(tripTypes);
        for (Trip trip : trips) {
            if (!tripTypeTemp.contains(trip.getTripType())) continue;
            result.add(trip);
        }
        return result;
    }

    public abstract List<Trip> filterTrip(List<Trip> var1);

    public abstract void handleTrip(List<Trip> var1, Section var2);

    public TripHandler getHandler() {
        return this.handler;
    }

    public void setHandler(TripHandler handler) {
        this.handler = handler;
    }

    public void execute(List<Trip> trips, Section section) {
        ArrayList<Trip> allTrips = new ArrayList<Trip>();
        allTrips.addAll(trips);
        List canAllocationTrips = this.filterTrip(allTrips);
        allTrips.removeAll(canAllocationTrips);
        this.handleTrip(canAllocationTrips, section);
        if (!ObjectUtils.isEmpty((Object)this.getHandler())) {
            this.getHandler().execute(allTrips, section);
        }
    }
}

