/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.business.trip;

import com.mushiny.wms.application.business.common.CommonBusiness;
import com.mushiny.wms.application.business.score.DrivePodScoreBusiness;
import com.mushiny.wms.application.business.trip.TripHandler;
import com.mushiny.wms.application.config.MapNodeConfig;
import com.mushiny.wms.application.domain.MapNode;
import com.mushiny.wms.application.domain.Section;
import com.mushiny.wms.application.domain.Trip;
import com.mushiny.wms.application.domain.WCSRobot;
import com.mushiny.wms.application.domain.enums.TripType;
import com.mushiny.wms.application.repository.TripRepository;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class PodSanTripHandler
extends TripHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PodSanTripHandler.class);
    private static final String[] podScanType = new String[]{TripType.POD_SCAN.getName()};

    @Autowired
    public PodSanTripHandler(CommonBusiness commonBusiness, TripRepository tripRepository, DrivePodScoreBusiness drivePodScoreBusiness) {
        super(commonBusiness, tripRepository, drivePodScoreBusiness);
    }

    public List<Trip> filterTrip(List<Trip> trips) {
        return this.filterHandlerTrip(trips, podScanType);
    }

    public void handleTrip(List<Trip> trips, Section section) {
        if (CollectionUtils.isEmpty((Collection)this.getAvailableDrives(section.getId()))) {
            for (Trip trip : trips) {
                String paths = trip.getPodScanpath();
                Assert.isNull((Object)paths, (String)("trip  " + trip.getId() + " scanPath \u4e0d\u80fd\u4e3a\u7a7a"));
                String[] pathsTemp = paths.split(",");
                if (!StringUtils.isEmpty((Object)pathsTemp[0])) {
                    MapNode mapNode = MapNodeConfig.findSectionMapNode((int)Integer.parseInt(pathsTemp[0]), (String)trip.getSectionId()).getCurrentMapNode();
                    WCSRobot temp = this.getMoveDriveTargetAddress(mapNode, this.getAvailableDrives(section.getId()));
                    if (allocated.contains(temp.getRobotId())) continue;
                    trip.setDriveId(temp.getRobotId());
                    this.tripRepository.saveAndFlush((Object)trip);
                    allocated.add(temp.getRobotId());
                    continue;
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("trip {} scanPath \u4e0d\u548c\u6cd5---{}", (Object)trip.getId(), (Object)paths);
            }
        }
    }

    public WCSRobot getMoveDriveTargetAddress(MapNode baseMapNode, List<WCSRobot> WCSRobots) {
        WCSRobot minWCSRobot = null;
        boolean flag = true;
        for (WCSRobot wcsRobot : WCSRobots) {
            int minValue;
            if (flag) {
                flag = false;
                minWCSRobot = wcsRobot;
                continue;
            }
            int nodeValue = Math.abs(wcsRobot.getxPosition() - baseMapNode.getxPosition()) + Math.abs(wcsRobot.getyPosition() - baseMapNode.getyPosition());
            if (nodeValue >= (minValue = Math.abs(minWCSRobot.getxPosition() - baseMapNode.getxPosition()) + Math.abs(minWCSRobot.getyPosition() - baseMapNode.getyPosition()))) continue;
            minWCSRobot = wcsRobot;
        }
        return minWCSRobot;
    }
}

