/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.business.trip;

import com.mushiny.wms.application.business.common.CommonBusiness;
import com.mushiny.wms.application.business.score.DrivePodScoreBusiness;
import com.mushiny.wms.application.business.trip.TripHandler;
import com.mushiny.wms.application.domain.Section;
import com.mushiny.wms.application.domain.Trip;
import com.mushiny.wms.application.domain.enums.TripType;
import com.mushiny.wms.application.repository.TripRepository;
import com.mushiny.wms.common.utils.JSONUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PodRunTripHandler
extends TripHandler {
    private static final String[] podRunType = new String[]{TripType.POD_RUN.getName(), TripType.ANNTO_MVIN.getName(), TripType.ANNTOMVOUT.getName(), TripType.CARRY_POD.getName(), TripType.FINISHESWAREHOUSING.getName(), TripType.LMGETMATERIAL.getName()};
    private static final Logger LOGGER = LoggerFactory.getLogger(PodRunTripHandler.class);

    public PodRunTripHandler(CommonBusiness commonBusiness, TripRepository tripRepository, DrivePodScoreBusiness drivePodScoreBusiness) {
        super(commonBusiness, tripRepository, drivePodScoreBusiness);
    }

    public List<Trip> filterTrip(List<Trip> trips) {
        return this.filterHandlerTrip(trips, podRunType);
    }

    public void handleTrip(List<Trip> trips, Section section) {
        List roboots = this.getAvailableDrives(section.getId());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5f00\u59cb\u5904\u7406podRun\u8c03\u5ea6\u5355,\u5f53\u524d\u53ef\u7528\u7684\u8f66\u4e3a{}", (Object)JSONUtil.toJSon((Object)roboots));
        }
        if (roboots.isEmpty()) {
            return;
        }
        for (Trip trip : trips) {
            this.saveTrip(trip, roboots);
        }
    }
}

