/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.business.trip;

import com.mushiny.wms.application.business.common.CommonBusiness;
import com.mushiny.wms.application.business.dto.DrivePodScore;
import com.mushiny.wms.application.business.dto.MixTrip;
import com.mushiny.wms.application.business.dto.SectionMapNode;
import com.mushiny.wms.application.business.score.DrivePodScoreBusiness;
import com.mushiny.wms.application.business.trip.TripHandler;
import com.mushiny.wms.application.config.MapNodeConfig;
import com.mushiny.wms.application.domain.MapNode;
import com.mushiny.wms.application.domain.Pod;
import com.mushiny.wms.application.domain.Section;
import com.mushiny.wms.application.domain.Trip;
import com.mushiny.wms.application.domain.WCSRobot;
import com.mushiny.wms.application.domain.enums.PodStateEnum;
import com.mushiny.wms.application.domain.enums.TripState;
import com.mushiny.wms.application.domain.enums.TripType;
import com.mushiny.wms.application.repository.PodRepository;
import com.mushiny.wms.application.repository.TripRepository;
import com.mushiny.wms.common.utils.JSONUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class CommonTripHandler
extends TripHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonTripHandler.class);
    private final PodRepository podRepository;
    private static Map<String, MixTrip> allocateDriverTrips = new HashMap();
    private static final String[] commonTripType = new String[]{TripType.POD_SCAN.getName(), TripType.PICK_POD.getName(), TripType.STOW_POD.getName(), TripType.IBP_POD.getName(), TripType.OBP_POD.getName(), TripType.ICQA_POD.getName(), TripType.POD_RUN.getName()};

    @Autowired
    public CommonTripHandler(CommonBusiness commonBusiness, TripRepository tripRepository, PodRepository podRepository, DrivePodScoreBusiness drivePodScoreBusiness) {
        super(commonBusiness, tripRepository, drivePodScoreBusiness);
        this.podRepository = podRepository;
    }

    private MixTrip generate(Trip trip, Section section, List<Trip> srcTrip) {
        MixTrip mixTrip = null;
        try {
            Pod pod = (Pod)this.podRepository.getOne((Serializable)((Object)trip.getPodId()));
            SectionMapNode sectionMapNodeTemp = MapNodeConfig.findSectionMapNode((int)pod.getPlaceMark(), (String)section.getId());
            if (ObjectUtils.isEmpty((Object)sectionMapNodeTemp)) {
                LOGGER.error("\u5730\u56fe\u4e0d\u5b58\u5728pod" + pod.getName() + "\u5730\u5740" + pod.getPlaceMark());
                return mixTrip;
            }
            if (sectionMapNodeTemp.isInAddress()) {
                int placeMark = ((MapNode)sectionMapNodeTemp.getOutSizeMapNodes().get(0)).getAddressCodeId();
                List newPods = this.podRepository.getByAddressCodeId(placeMark, section.getId());
                Pod newPod = null;
                if (!CollectionUtils.isEmpty((Collection)newPods)) {
                    if (newPods.size() > 1) {
                        LOGGER.error("\u8c03\u5ea6\u5355{} pod{} \u5730\u5740{] \u5916\u90e8\u5730\u5740{} \u5b58\u5728\u591a\u4e2apod{}", new Object[]{trip.getId(), pod.getName(), pod.getPlaceMark(), placeMark, JSONUtil.toJSon((Object)newPods)});
                        return null;
                    }
                    newPod = (Pod)newPods.get(0);
                }
                List releasedTrargetPod = this.commonBusiness.releasedTrargetPod(String.valueOf(placeMark), section.getId());
                if (!ObjectUtils.isEmpty((Object)newPod) && CollectionUtils.isEmpty((Collection)releasedTrargetPod)) {
                    mixTrip = new MixTrip();
                    mixTrip.setCurrentTrip(trip);
                    List searchTrip = this.commonBusiness.getTrip(newPod.getId(), section.getId());
                    if (CollectionUtils.isEmpty((Collection)searchTrip)) {
                        Trip podRunTrip = this.generateRodRunTrip(newPod, section.getId());
                        mixTrip.setPreTrip(podRunTrip);
                    } else {
                        mixTrip.setPreTrip((Trip)searchTrip.get(0));
                    }
                } else if (ObjectUtils.isEmpty((Object)newPod) && ObjectUtils.isEmpty((Object)releasedTrargetPod)) {
                    mixTrip = new MixTrip();
                    mixTrip.setCurrentTrip(trip);
                } else {
                    LOGGER.debug("\u91ca\u653epod{} \u7684\u76ee\u6807\u5730\u5740\u5728{} ", (Object)JSONUtil.toJSon((Object)releasedTrargetPod), (Object)placeMark);
                }
                if (!ObjectUtils.isEmpty((Object)mixTrip)) {
                    mixTrip.setOutSizeAddrcoed(String.valueOf(placeMark));
                }
            } else {
                mixTrip = new MixTrip();
                mixTrip.setCurrentTrip(trip);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5904\u7406\u8c03\u5ea6\u5355\u51fa\u9519" + JSONUtil.toJSon((Object)trip) + "\n" + e.getMessage(), (Throwable)e);
            throw e;
        }
        return mixTrip;
    }

    private Trip generateRodRunTrip(Pod pod, String sectionId) {
        pod.setState(PodStateEnum.RESERVED.getName());
        Pod podRun = (Pod)this.podRepository.saveAndFlush((Object)pod);
        Trip resultTemp = new Trip();
        resultTemp.setTripType(TripType.POD_RUN.getName());
        resultTemp.setTripState(TripState.NEW.getName());
        resultTemp.setPodId(podRun.getId());
        resultTemp.setWarehouseId(podRun.getWarehouseId());
        resultTemp.setSectionId(sectionId);
        Trip result = (Trip)this.tripRepository.saveAndFlush((Object)resultTemp);
        return result;
    }

    private Trip searchPod(List<Trip> srcTrip, Pod pod) {
        Trip result = null;
        if (!CollectionUtils.isEmpty(srcTrip)) {
            for (Trip trip : srcTrip) {
                if (!trip.getPodId().equals(pod.getId())) continue;
                result = trip;
                break;
            }
        }
        return result;
    }

    private void allocateDriver(Map<MixTrip, List<DrivePodScore>> podScores, List<WCSRobot> robots) {
        for (Map.Entry<MixTrip, List<DrivePodScore>> podScore : podScores.entrySet()) {
            Trip currentTrip = (Trip)this.tripRepository.getOne((Serializable)((Object)podScore.getKey().getCurrentTrip().getId()));
            if (!ObjectUtils.isEmpty((Object)podScore.getKey().getPreTrip())) {
                Trip preTrip = (Trip)this.tripRepository.getOne((Serializable)((Object)podScore.getKey().getPreTrip().getId()));
                if (preTrip.getTripState().equals(TripState.NEW.getName())) {
                    this.saveTrip(preTrip, robots);
                }
                int targetAdd = Integer.parseInt(podScore.getKey().getOutSizeAddrcoed());
                List podTemp = this.podRepository.getByTripId(preTrip.getId(), targetAdd);
                List releasedTrargetPod = this.commonBusiness.releasedTrargetPod(String.valueOf(targetAdd), preTrip.getSectionId());
                if (CollectionUtils.isEmpty((Collection)podTemp) && CollectionUtils.isEmpty((Collection)releasedTrargetPod)) {
                    if (!this.saveTrip(currentTrip, robots)) continue;
                    allocateDriverTrips.remove(currentTrip.getId());
                    continue;
                }
                LOGGER.debug("\u5904\u7406\u8c03\u5ea6\u5355{}\u5916\u5c42\u5730\u5740{}\u6709pod {},\u91ca\u653epod\u76ee\u6807\u5730\u5740\u5728\u5916\u5c42\u505c\u6b62\u5206\u8f66{}", new Object[]{currentTrip.getId(), targetAdd, JSONUtil.toJSon((Object)podTemp), releasedTrargetPod});
                continue;
            }
            if (!this.saveTrip(currentTrip, robots)) continue;
            allocateDriverTrips.remove(currentTrip.getId());
        }
    }

    public List<Trip> filterTrip(List<Trip> trips) {
        return this.filterHandlerTrip(trips, commonTripType);
    }

    private boolean containTrip(Trip trip) {
        boolean result = false;
        if (!CollectionUtils.isEmpty((Map)allocateDriverTrips)) {
            Collection trips = allocateDriverTrips.values();
            for (MixTrip temp : trips) {
                if (!ObjectUtils.isEmpty((Object)temp.getPreTrip()) && temp.getPreTrip().getId().equals(trip.getId())) {
                    result = true;
                    break;
                }
                if (!temp.getCurrentTrip().getId().equals(trip.getId())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private Map<MixTrip, List<DrivePodScore>> getDrivePodScores(List<MixTrip> mixTrips, List<WCSRobot> robots) {
        Map podScores = this.drivePodScoreBusiness.getDrivePodScores2(mixTrips, robots);
        return podScores;
    }

    public void handleTrip(List<Trip> trips, Section section) {
        if (CollectionUtils.isEmpty(trips)) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5f00\u59cb\u5904\u7406 section {} \u8c03\u5ea6\u5355\n{}", (Object)section.getName(), (Object)JSONUtil.toJSon(trips));
            LOGGER.debug("\u5185\u5b58\u4e2d allocateDriverTrips \u72b6\u6001 \n{}", (Object)JSONUtil.toJSon((Object)allocateDriverTrips));
        }
        ArrayList<MixTrip> mixTrips = new ArrayList<MixTrip>();
        for (Trip trip : trips) {
            MixTrip mixTrip = this.generate(trip, section, trips);
            if (ObjectUtils.isEmpty((Object)mixTrip)) continue;
            mixTrips.add(mixTrip);
            allocateDriverTrips.put(trip.getId(), mixTrip);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("section {} \u751f\u6210\u6df7\u5408\u8c03\u5ea6\u5355\n{}", (Object)section.getName(), (Object)JSONUtil.toJSon(mixTrips));
        }
        List robots = this.getAvailableDrives(section.getId());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5f53\u524d\u53ef\u7528\u7684\u8f66\u4e3a{}", (Object)JSONUtil.toJSon((Object)robots));
        }
        if (robots.isEmpty()) {
            return;
        }
        Map podScores = this.getDrivePodScores(mixTrips, robots);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u8c03\u5ea6\u5355\u5bf9\u5e94\u5c0f\u8f66\u5f97\u5206\u4e3a\n{}", (Object)JSONUtil.toJSon((Object)podScores));
        }
        if (podScores.isEmpty()) {
            return;
        }
        this.allocateDriver(podScores, robots);
    }
}

