/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.business.trip;

import com.mushiny.wms.application.business.common.CommonBusiness;
import com.mushiny.wms.application.business.common.SystemPropertyBusiness;
import com.mushiny.wms.application.business.score.DrivePodScoreBusiness;
import com.mushiny.wms.application.business.trip.TripHandler;
import com.mushiny.wms.application.domain.Charger;
import com.mushiny.wms.application.domain.Section;
import com.mushiny.wms.application.domain.Trip;
import com.mushiny.wms.application.domain.WCSRobot;
import com.mushiny.wms.application.domain.enums.TripState;
import com.mushiny.wms.application.domain.enums.TripType;
import com.mushiny.wms.application.repository.ChargerRepository;
import com.mushiny.wms.application.repository.TripRepository;
import com.mushiny.wms.application.repository.WCSRobotRepository;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ChargerDriveTripHandler
extends TripHandler {
    private static final String[] chargerDrive = new String[]{TripType.CHARGER_DRIVE.getName()};
    private static final Logger LOGGER = LoggerFactory.getLogger(ChargerDriveTripHandler.class);
    private final SystemPropertyBusiness systemPropertyBusiness;
    private final WCSRobotRepository wcsRobotRepository;
    private final ChargerRepository chargerRepository;

    public ChargerDriveTripHandler(CommonBusiness commonBusiness, TripRepository tripRepository, DrivePodScoreBusiness drivePodScoreBusiness, SystemPropertyBusiness systemPropertyBusiness, WCSRobotRepository wcsRobotRepository, ChargerRepository chargerRepository) {
        super(commonBusiness, tripRepository, drivePodScoreBusiness);
        this.systemPropertyBusiness = systemPropertyBusiness;
        this.wcsRobotRepository = wcsRobotRepository;
        this.chargerRepository = chargerRepository;
    }

    public List<Trip> filterTrip(List<Trip> trips) {
        return this.filterHandlerTrip(trips, chargerDrive);
    }

    private void buildMoveRobotTrip(Charger charger, WCSRobot wcsRobot) {
        Integer moveTargetAddress = this.commonBusiness.getMoveDriveTargetAddress(charger);
        if (moveTargetAddress == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("section {} \u65e0\u53ef\u7528\u7684\u4f11\u606f\u533a---\u5c0f\u8f66{}", (Object)wcsRobot.getSectionId(), (Object)wcsRobot.getRobotId());
            }
            return;
        }
        Trip moveTrip = new Trip();
        moveTrip.setTripType(TripType.MOVE_DRIVE.getName());
        moveTrip.setTripState(TripState.AVAILABLE.getName());
        moveTrip.setDriveId(wcsRobot.getRobotId());
        moveTrip.setEndAddress(moveTargetAddress);
        moveTrip.setSectionId(charger.getSectionId());
        moveTrip.setWarehouseId(charger.getWarehouseId());
        this.tripRepository.saveAndFlush((Object)moveTrip);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u751f\u6210\u5c0f\u8f66 {} \u8c03\u8d70\u7684\u8c03\u5ea6\u5355{}\u6210\u529f", (Object)wcsRobot.getRobotId(), (Object)moveTrip.getId());
        }
    }

    public void handleTrip(List<Trip> trips, Section section) {
        for (Trip trip : trips) {
            trip.setTripState(TripState.AVAILABLE.getName());
            this.tripRepository.saveAndFlush((Object)trip);
        }
    }
}

