/*
 * Decompiled with CFR 0.152.
 */
package com.mushiny.wms.application.business.score;

import com.mushiny.wms.application.business.common.CommonBusiness;
import com.mushiny.wms.application.business.dto.DrivePodScore;
import com.mushiny.wms.application.business.dto.MixTrip;
import com.mushiny.wms.application.business.score.EnRouteWorkBusiness;
import com.mushiny.wms.application.domain.MapNode;
import com.mushiny.wms.application.domain.Pod;
import com.mushiny.wms.application.domain.Trip;
import com.mushiny.wms.application.domain.WCSRobot;
import com.mushiny.wms.application.domain.enums.TripType;
import com.mushiny.wms.application.repository.PodRepository;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DrivePodScoreBusiness {
    private final PodRepository podRepository;
    private final EnRouteWorkBusiness enRouteWorkBusiness;
    private final CommonBusiness commonBusiness;

    @Autowired
    public DrivePodScoreBusiness(PodRepository podRepository, EnRouteWorkBusiness enRouteWorkBusiness, CommonBusiness commonBusiness) {
        this.podRepository = podRepository;
        this.enRouteWorkBusiness = enRouteWorkBusiness;
        this.commonBusiness = commonBusiness;
    }

    /*
     * WARNING - void declaration
     */
    public List<DrivePodScore> getDrivePodScores(List<Trip> trips, List<WCSRobot> robots) {
        ArrayList<DrivePodScore> drivePodScores = new ArrayList<DrivePodScore>();
        for (Trip trip : trips) {
            BigDecimal enRouteWork;
            Pod pod = (Pod)this.podRepository.findOne((Serializable)((Object)trip.getPodId()));
            Duration duration = Duration.between(LocalDateTime.now(), trip.getCreatedDate());
            BigDecimal podWaitTime = BigDecimal.valueOf(Math.abs(duration.getSeconds()));
            if (trip.getTripType().equalsIgnoreCase(TripType.PICK_POD.getName())) {
                enRouteWork = this.enRouteWorkBusiness.getPickTripEnRouteWork(trip.getWorkStationId());
            } else if (trip.getTripType().equalsIgnoreCase(TripType.STOW_POD.getName())) {
                enRouteWork = this.enRouteWorkBusiness.getStowTripEnRouteWork(trip.getWarehouseId());
            } else {
                if (!trip.getTripType().equalsIgnoreCase(TripType.IBP_POD.getName()) && !trip.getTripType().equalsIgnoreCase(TripType.OBP_POD.getName()) && !trip.getTripType().equalsIgnoreCase(TripType.ICQA_POD.getName())) continue;
                enRouteWork = this.enRouteWorkBusiness.getPQATripEnRouteWork(trip.getPodId());
            }
            for (WCSRobot robot : robots) {
                void var9_9;
                BigDecimal fetch = BigDecimal.valueOf(Math.abs(robot.getxPosition() - pod.getxPos()) + Math.abs(robot.getyPosition() - pod.getyPos()));
                BigDecimal score = fetch.add((BigDecimal)var9_9).subtract(podWaitTime);
                DrivePodScore drivePodScore = new DrivePodScore();
                drivePodScore.setDriveId(robot.getRobotId());
                drivePodScore.setPodId(trip.getPodId());
                drivePodScore.setScore(score);
                drivePodScore.setTripId(trip.getId());
                drivePodScores.add(drivePodScore);
            }
            drivePodScores.sort(Comparator.comparing(DrivePodScore::getScore));
        }
        return drivePodScores;
    }

    public List<DrivePodScore> getDrivePodScores(Trip trip, List<WCSRobot> robots) {
        ArrayList<DrivePodScore> drivePodScores = new ArrayList<DrivePodScore>();
        Pod pod = (Pod)this.podRepository.findOne((Serializable)((Object)trip.getPodId()));
        if (pod == null || pod.getPlaceMark() == null || Objects.equals(pod.getPlaceMark(), 0)) {
            return drivePodScores;
        }
        MapNode podNode = this.commonBusiness.findMapNodeBySectionId(pod.getSectionId(), pod.getPlaceMark());
        Duration duration = Duration.between(LocalDateTime.now(), trip.getCreatedDate());
        BigDecimal podWaitTime = BigDecimal.valueOf(Math.abs(duration.getSeconds()));
        BigDecimal enRouteWork = new BigDecimal(0);
        for (WCSRobot robot : robots) {
            BigDecimal fetch = BigDecimal.valueOf(Math.abs(robot.getxPosition() - podNode.getxPosition()) + Math.abs(robot.getyPosition() - podNode.getyPosition()));
            BigDecimal score = fetch.add(enRouteWork).subtract(podWaitTime);
            DrivePodScore drivePodScore = new DrivePodScore();
            drivePodScore.setDriveId(robot.getRobotId());
            drivePodScore.setPodId(trip.getPodId());
            drivePodScore.setScore(score);
            drivePodScore.setTripId(trip.getId());
            drivePodScores.add(drivePodScore);
        }
        drivePodScores.sort(Comparator.comparing(DrivePodScore::getScore));
        return drivePodScores;
    }

    /*
     * WARNING - void declaration
     */
    public Map<MixTrip, List<DrivePodScore>> getDrivePodScores2(List<MixTrip> mixTrips, List<WCSRobot> robots) {
        HashMap<MixTrip, List<DrivePodScore>> result = new HashMap<MixTrip, List<DrivePodScore>>();
        for (MixTrip mixTrip : mixTrips) {
            BigDecimal enRouteWork;
            ArrayList<DrivePodScore> drivePodScores = new ArrayList<DrivePodScore>();
            Trip trip = mixTrip.getCurrentTrip();
            Pod pod = (Pod)this.podRepository.findOne((Serializable)((Object)trip.getPodId()));
            Duration duration = Duration.between(LocalDateTime.now(), trip.getCreatedDate());
            BigDecimal podWaitTime = BigDecimal.valueOf(Math.abs(duration.getSeconds()));
            if (trip.getTripType().equalsIgnoreCase(TripType.PICK_POD.getName())) {
                enRouteWork = this.enRouteWorkBusiness.getPickTripEnRouteWork(trip.getWorkStationId());
            } else if (trip.getTripType().equalsIgnoreCase(TripType.STOW_POD.getName())) {
                enRouteWork = this.enRouteWorkBusiness.getStowTripEnRouteWork(trip.getWarehouseId());
            } else {
                if (!trip.getTripType().equalsIgnoreCase(TripType.IBP_POD.getName()) && !trip.getTripType().equalsIgnoreCase(TripType.OBP_POD.getName()) && !trip.getTripType().equalsIgnoreCase(TripType.ICQA_POD.getName())) continue;
                enRouteWork = this.enRouteWorkBusiness.getPQATripEnRouteWork(trip.getPodId());
            }
            for (WCSRobot robot : robots) {
                void var11_11;
                BigDecimal fetch = BigDecimal.valueOf(Math.abs(robot.getxPosition() - pod.getxPos()) + Math.abs(robot.getyPosition() - pod.getyPos()));
                BigDecimal score = fetch.add((BigDecimal)var11_11).subtract(podWaitTime);
                DrivePodScore drivePodScore = new DrivePodScore();
                drivePodScore.setDriveId(robot.getRobotId());
                drivePodScore.setPodId(trip.getPodId());
                drivePodScore.setScore(score);
                drivePodScore.setTripId(trip.getId());
                drivePodScores.add(drivePodScore);
            }
            drivePodScores.sort(Comparator.comparing(DrivePodScore::getScore));
            result.put(mixTrip, drivePodScores);
        }
        return result;
    }
}

